/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.search.JavaElementLine;
import org.eclipse.jdt.internal.ui.search.JavaElementLineSorter;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchLabelProvider;
import org.eclipse.jdt.internal.ui.search.TextSearchTableContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class OccurrencesSearchResultPage
extends AbstractTextSearchViewPage {
    private TextSearchTableContentProvider fContentProvider;

    public OccurrencesSearchResultPage() {
        super(1);
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        IEditorPart editor = null;
        JavaElementLine element = (JavaElementLine)match.getElement();
        IJavaElement javaElement = element.getJavaElement();
        try {
            editor = EditorUtility.openInEditor(javaElement, false);
        }
        catch (PartInitException partInitException) {
            return;
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(currentOffset, currentLength);
        }
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        throw new IllegalStateException("Doesn't support tree mode.");
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setSorter((ViewerSorter)new JavaElementLineSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new OccurrencesSearchLabelProvider(this));
        this.fContentProvider = new TextSearchTableContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }
}

