/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.InterfaceEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDDragAndDropEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDGraphNodeDragTracker;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ListFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.RowLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;

public class MessageReferenceEditPart
extends BaseEditPart
implements IFeedbackHandler {
    protected Figure contentPane;
    protected Label label;
    protected RowLayout rowLayout;
    protected ASDSelectionEditPolicy selectionHandlesEditPolicy = new ASDSelectionEditPolicy();

    protected IFigure createFigure() {
        ListFigure figure = new ListFigure(true);
        figure.setOpaque(true);
        figure.setPaintFirstLine(false);
        figure.setBackgroundColor(ColorConstants.tooltipBackground);
        this.rowLayout = new RowLayout();
        figure.setLayoutManager((LayoutManager)this.rowLayout);
        this.label = new Label();
        this.label.setLabelAlignment(1);
        this.label.setBorder((Border)new MarginBorder(2, 16, 2, 10));
        figure.add((IFigure)this.label);
        this.contentPane = new ListFigure();
        ((ListFigure)this.contentPane).setOpaque(true);
        this.contentPane.setBackgroundColor(ColorConstants.listBackground);
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout);
        figure.add((IFigure)this.contentPane);
        this.rowLayout.setConstraint((IFigure)this.label, "MessageLabel");
        this.rowLayout.setConstraint((IFigure)this.contentPane, "MessageContentPane");
        return figure;
    }

    protected void createEditPolicies() {
        if (!this.isReadOnly()) {
            this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ASDDragAndDropEditPolicy(this.getViewer(), this.selectionHandlesEditPolicy));
        }
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
    }

    public DragTracker getDragTracker(Request request) {
        return new ASDGraphNodeDragTracker((EditPart)this);
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IMessageReference message = (IMessageReference)this.getModel();
        this.label.setText(message.getText());
        this.label.setIcon(message.getImage());
        if (this.isReadOnly()) {
            this.label.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
            this.label.getParent().setBackgroundColor(DesignViewGraphicsConstants.readOnlyMessageRefHeadingColor);
        } else {
            this.label.setForegroundColor(ColorConstants.black);
            this.label.getParent().setBackgroundColor(ColorConstants.tooltipBackground);
        }
    }

    protected List getModelChildren() {
        IMessageReference theMessage = (IMessageReference)this.getModel();
        return theMessage.getParameters();
    }

    public void addNotify() {
        InterfaceEditPart.attachToInterfaceEditPart((EditPart)this, this.rowLayout);
        super.addNotify();
    }

    public void addFeedback() {
        this.label.getParent().setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
    }

    public void removeFeedback() {
        if (this.isReadOnly()) {
            this.label.getParent().setBackgroundColor(DesignViewGraphicsConstants.readOnlyMessageRefHeadingColor);
        } else {
            this.label.getParent().setBackgroundColor(ColorConstants.tooltipBackground);
        }
    }
}

