/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.project.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.Logger;
import org.eclipse.php.core.project.operation.PHPCreationDataModelProvider;
import org.eclipse.php.project.ui.wizards.PHPIncludePathPage;
import org.eclipse.php.project.ui.wizards.PHPProjectWizardBasePage;
import org.eclipse.php.ui.util.PHPPluginImages;
import org.eclipse.php.ui.wizards.BasicPHPWizardPageExtended;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.osgi.service.prefs.BackingStoreException;

public class PHPProjectCreationWizard
extends DataModelWizard
implements IExecutableExtension,
INewWizard {
    private static final String PHP_WIZARD_PAGS_EXTENSION_POINT = "org.eclipse.php.ui.phpWizardPages";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String WIZARDNAME_ATTRIBUTE = "wizardName";
    private static final String WizardName = "PHPProjectCreationWizard";
    protected PHPIncludePathPage includePathPage;
    protected PHPProjectWizardBasePage basePage;
    private final ArrayList wizardPagesList = new ArrayList();
    private IProject createdProject = null;
    private IConfigurationElement configElement;

    public PHPProjectCreationWizard(IDataModel iDataModel) {
        super(iDataModel);
    }

    public PHPProjectCreationWizard() {
    }

    protected IDataModelProvider getDefaultProvider() {
        return new PHPCreationDataModelProvider();
    }

    public void doAddPages() {
        this.basePage = new PHPProjectWizardBasePage(this.getDataModel(), "page1");
        this.addPage((IWizardPage)this.basePage);
        this.includePathPage = new PHPIncludePathPage(this.getDataModel(), "page2");
        this.addPage((IWizardPage)this.includePathPage);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(PHP_WIZARD_PAGS_EXTENSION_POINT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getAttribute(WIZARDNAME_ATTRIBUTE).equals(WizardName) && iConfigurationElementArray[n].getAttribute(CLASS_ATTRIBUTE) != null) {
                try {
                    BasicPHPWizardPageExtended basicPHPWizardPageExtended = (BasicPHPWizardPageExtended)((Object)iConfigurationElementArray[n].createExecutableExtension(CLASS_ATTRIBUTE));
                    this.addPage((IWizardPage)basicPHPWizardPageExtended);
                    this.wizardPagesList.add(basicPHPWizardPageExtended);
                }
                catch (CoreException coreException) {
                    Logger.logException((String)PHPUIMessages.PHPProjectCreationWizard_LoadPagesFailure, (Throwable)coreException);
                }
            }
            ++n;
        }
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        this.configElement = iConfigurationElement;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(PHPUIMessages.PHPProjectCreationWizard_PageTile);
        this.setDefaultPageImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_PROJECT);
    }

    protected boolean prePerformFinish() {
        this.getDataModel().setProperty("org.eclipse.php.core.includePath", (Object)this.includePathPage.getIncludePathsBlock().getIncludepathEntries());
        this.createdProject = (IProject)this.getDataModel().getProperty("IProjectCreationPropertiesNew.PROJECT");
        if (this.createdProject != null) {
            Iterator iterator = this.wizardPagesList.iterator();
            while (iterator.hasNext()) {
                BasicPHPWizardPageExtended basicPHPWizardPageExtended = (BasicPHPWizardPageExtended)((Object)iterator.next());
                basicPHPWizardPageExtended.prePerformFinish(this.createdProject);
            }
        }
        this.basePage.setProjectOptionInModel(this.getDataModel());
        return super.prePerformFinish();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        if (this.createdProject != null) {
            try {
                new ProjectScope(this.createdProject).getNode("org.eclipse.php.core").flush();
            }
            catch (BackingStoreException backingStoreException) {
                Logger.logException((Throwable)backingStoreException);
            }
        }
    }
}

