/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class MemoryViewUtil {
    public static final int[] ignoreKeyEvents = new int[]{0x1000001, 0x1000002, 0x1000003, 0x1000004, 0x1000005, 0x1000006, 0x1000007, 0x1000008, 0x1000009, 0x100000A, 0x100000B, 0x100000C, 0x100000D, 0x100000E, 0x100000F, 0x1000010, 0x1000011, 0x1000012, 0x1000013, 0x1000014, 0x1000015, 0x1000016, 0x1000017, 0x1000018, 0x1000051, 16777298, 16777299, 16777300, 0x1000055, 16777302, 16777303, 27, 262144, 65536};
    public static ArrayList MEMORY_BLOCKS_HISTORY = new ArrayList();
    static /* synthetic */ Class class$0;

    public static boolean isValidSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        if (selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return false;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        return MemoryViewUtil.isValidContext(elem);
    }

    public static boolean isValidContext(Object elem) {
        IMemoryBlockRetrieval memRetrieval;
        if (!(elem instanceof IDebugElement)) {
            return false;
        }
        IDebugTarget debugTarget = ((IDebugElement)elem).getDebugTarget();
        IDebugElement iDebugElement = (IDebugElement)elem;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((memRetrieval = (IMemoryBlockRetrieval)iDebugElement.getAdapter((Class)clazz)) == null) {
            memRetrieval = debugTarget;
        }
        if (debugTarget == null) {
            return false;
        }
        if (debugTarget.isTerminated() || debugTarget.isDisconnected()) {
            return false;
        }
        return memRetrieval.supportsStorageRetrieval();
    }

    public static void openError(final String title, final String message, final Exception e) {
        UIJob uiJob = new UIJob("open error"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String detail = "";
                if (e != null) {
                    detail = e.getMessage();
                }
                Shell shell = DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)(String.valueOf(message) + "\n" + detail));
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    static IMemoryBlockManager getMemoryBlockManager() {
        return DebugPlugin.getDefault().getMemoryBlockManager();
    }

    public static boolean isLinuxGTK() {
        String ws = Platform.getWS();
        return ws.equals("gtk");
    }

    public static boolean isValidEditEvent(int event) {
        int i = 0;
        while (i < ignoreKeyEvents.length) {
            if (event == ignoreKeyEvents[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static BigInteger alignToBoundary(BigInteger integer, int numberOfUnitsPerLine) {
        BigInteger[] result = integer.divideAndRemainder(BigInteger.valueOf(numberOfUnitsPerLine));
        integer = integer.subtract(result[1]);
        return integer;
    }

    public static void addHistory(String expression) {
        if (!MEMORY_BLOCKS_HISTORY.contains(expression)) {
            MEMORY_BLOCKS_HISTORY.add(0, expression);
        }
        if (MEMORY_BLOCKS_HISTORY.size() > 5) {
            MEMORY_BLOCKS_HISTORY.remove(MEMORY_BLOCKS_HISTORY.size() - 1);
        }
    }

    public static String[] getHistory() {
        return MEMORY_BLOCKS_HISTORY.toArray(new String[MEMORY_BLOCKS_HISTORY.size()]);
    }

    public static IMemoryBlockRetrieval getMemoryBlockRetrieval(Object object) {
        IMemoryBlockRetrieval retrieval = null;
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            retrieval = (IMemoryBlockRetrieval)adaptable.getAdapter((Class)clazz);
        }
        if (retrieval == null && object instanceof IDebugElement) {
            IDebugElement de = (IDebugElement)object;
            retrieval = de.getDebugTarget();
        }
        return retrieval;
    }
}

