/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.project.options.includepath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.core.project.IIncludePathEntry;
import org.eclipse.php.core.project.options.PHPProjectOptions;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class IncludePathValidator
implements IValidator {
    public void cleanup(IReporter iReporter) {
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
        String[] stringArray = iValidationContext.getURIs();
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (stringArray.length > 0) {
            IFile iFile = null;
            int n = 0;
            while (n < stringArray.length && !iReporter.isCancelled()) {
                iFile = iWorkspaceRoot.getFile((IPath)new Path(stringArray[n]));
                if (iFile != null && iFile.exists()) {
                    this.validateIncludePath(iFile, iReporter);
                }
                ++n;
            }
        } else {
            OptionsFileVisitor optionsFileVisitor = new OptionsFileVisitor(iReporter);
            try {
                ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)optionsFileVisitor, 2);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            IFile[] iFileArray = optionsFileVisitor.getFiles();
            int n = 0;
            while (n < iFileArray.length && !iReporter.isCancelled()) {
                this.validateIncludePath(iFileArray[n], iReporter);
                ++n;
            }
        }
    }

    private void clearMarkers(IReporter iReporter, IProject iProject) {
        iReporter.removeAllMessages((IValidator)this, (Object)iProject);
    }

    private void validateIncludePath(IFile iFile, IReporter iReporter) {
        IProject iProject = iFile.getProject();
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
        IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
        this.clearMarkers(iReporter, iProject);
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            String string = iIncludePathEntryArray[n].validate();
            if (string != null) {
                this.addError(iProject, string, iReporter, 2);
            }
            ++n;
        }
    }

    private void addError(IProject iProject, String string, IReporter iReporter, int n) {
        IMarker iMarker;
        try {
            iMarker = iProject.createMarker("org.eclipse.core.resources.taskmarker");
            iMarker.setAttribute("lineNumber", 0);
            iMarker.setAttribute("message", (Object)string);
            iMarker.setAttribute("priority", n);
        }
        catch (CoreException coreException) {}
        iMarker = new LocalizedMessage(1, string, (IResource)iProject);
        iReporter.addMessage((IValidator)this, (IMessage)iMarker);
    }

    private class OptionsFileVisitor
    implements IResourceProxyVisitor {
        private List fFiles = new ArrayList();
        private IReporter fReporter = null;

        public OptionsFileVisitor(IReporter iReporter) {
            this.fReporter = iReporter;
        }

        public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
            if (this.fReporter.isCancelled()) {
                return false;
            }
            if (iResourceProxy.getType() == 1) {
                IFile iFile = (IFile)iResourceProxy.requestResource();
                if (iFile.exists() && this.canHandle(iFile)) {
                    this.fFiles.add(iFile);
                    return false;
                }
                return false;
            }
            return iResourceProxy.getType() != 2;
        }

        private boolean canHandle(IFile iFile) {
            return iFile != null && iFile.getName().equals(".projectOptions");
        }

        public final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }
    }
}

