/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;

public class XMLWriter
extends PrintWriter {
    protected int tab = 0;
    protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public XMLWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(outputStream, "UTF8"));
        this.println(XML_VERSION);
    }

    public void endTag(String string) {
        --this.tab;
        this.printTag(String.valueOf('/') + string, null);
    }

    public void printSimpleTag(String string, Object object) {
        if (object != null) {
            this.printTag(string, null, true, false);
            this.print(XMLWriter.getEscaped(String.valueOf(object)));
            this.printTag(String.valueOf('/') + string, null, false, true);
        }
    }

    public void printTabulation() {
        int n = 0;
        while (n < this.tab) {
            super.print('\t');
            ++n;
        }
    }

    public void printTag(String string, HashMap hashMap) {
        this.printTag(string, hashMap, true, true);
    }

    public void printTag(String string, HashMap hashMap, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(" ");
                String string2 = (String)iterator.next();
                stringBuffer.append(string2);
                stringBuffer.append("=\"");
                stringBuffer.append(XMLWriter.getEscaped(String.valueOf(hashMap.get(string2))));
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        if (bl) {
            this.printTabulation();
        }
        if (bl2) {
            this.println(stringBuffer.toString());
        } else {
            this.print(stringBuffer.toString());
        }
    }

    public void startTag(String string, HashMap hashMap) {
        this.startTag(string, hashMap, true);
    }

    public void startTag(String string, HashMap hashMap, boolean bl) {
        this.printTag(string, hashMap, true, bl);
        ++this.tab;
    }

    private static void appendEscapedChar(StringBuffer stringBuffer, char c) {
        String string = XMLWriter.getReplacement(c);
        if (string != null) {
            stringBuffer.append('&');
            stringBuffer.append(string);
            stringBuffer.append(';');
        } else {
            stringBuffer.append(c);
        }
    }

    public static String getEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            XMLWriter.appendEscapedChar(stringBuffer, string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

