/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class HandlerProxy
extends AbstractHandler {
    private IConfigurationElement configurationElement;
    private final Expression enabledWhenExpression;
    private IHandler handler = null;
    private final String handlerAttributeName;
    private final IHandlerService handlerService;

    public HandlerProxy(IConfigurationElement configurationElement, String handlerAttributeName) {
        this(configurationElement, handlerAttributeName, null, null);
    }

    public HandlerProxy(IConfigurationElement configurationElement, String handlerAttributeName, Expression enabledWhenExpression, IHandlerService handlerService) {
        if (configurationElement == null) {
            throw new NullPointerException("The configuration element backing a handler proxy cannot be null");
        }
        if (handlerAttributeName == null) {
            throw new NullPointerException("The attribute containing the handler class must be known");
        }
        if (enabledWhenExpression != null && handlerService == null) {
            throw new NullPointerException("We must have a handler service to support the enabledWhen expression");
        }
        this.configurationElement = configurationElement;
        this.handlerAttributeName = handlerAttributeName;
        this.enabledWhenExpression = enabledWhenExpression;
        this.handlerService = handlerService;
    }

    public final void dispose() {
        if (this.handler != null) {
            this.handler.dispose();
        }
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.loadHandler()) {
            return this.handler.execute(event);
        }
        return null;
    }

    public final boolean isEnabled() {
        if (this.enabledWhenExpression != null) {
            try {
                EvaluationResult result = this.enabledWhenExpression.evaluate(this.handlerService.getCurrentState());
                if (result == EvaluationResult.TRUE && this.loadHandler()) {
                    return this.handler.isEnabled();
                }
            }
            catch (CoreException e) {
                String message = "An exception occurred while evaluating the enabledWhen expression for " + this.configurationElement.getAttribute(this.handlerAttributeName) + "' could not be loaded";
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, e.getMessage(), (Throwable)e);
                WorkbenchPlugin.log(message, (IStatus)status);
            }
            return false;
        }
        if (this.loadHandler()) {
            return this.handler.isEnabled();
        }
        return false;
    }

    public final boolean isHandled() {
        if (this.loadHandler()) {
            return this.handler.isHandled();
        }
        return false;
    }

    private final boolean loadHandler() {
        if (this.handler == null) {
            try {
                this.handler = (IHandler)this.configurationElement.createExecutableExtension(this.handlerAttributeName);
                this.configurationElement = null;
                return true;
            }
            catch (ClassCastException e) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied handler was the wrong class", (Throwable)e);
                WorkbenchPlugin.log("The proxied handler was the wrong class", (IStatus)status);
                return false;
            }
            catch (CoreException e) {
                String message = "The proxied handler for '" + this.configurationElement.getAttribute(this.handlerAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)e);
                WorkbenchPlugin.log(message, (IStatus)status);
                return false;
            }
        }
        return true;
    }

    public final String toString() {
        if (this.handler == null) {
            return this.configurationElement.getAttribute(this.handlerAttributeName);
        }
        return this.handler.toString();
    }
}

