/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences.phps;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.PixelConverter;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.debug.core.preferences.PHPexeItem;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.preferences.phps.IAddPHPexeDialogRequestor;
import org.eclipse.php.ui.util.StatusInfo;
import org.eclipse.php.ui.wizards.fields.DialogField;
import org.eclipse.php.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddPHPexeDialog
extends StatusDialog {
    private IAddPHPexeDialogRequestor fRequestor;
    private PHPexeItem fEditedPHPexe;
    private PHPexes fPHPexes;
    private StringButtonDialogField fPHPRoot;
    private StringDialogField fPHPexeName;
    private IStatus[] fStati;
    private int fPrevIndex = -1;

    public AddPHPexeDialog(IAddPHPexeDialogRequestor iAddPHPexeDialogRequestor, Shell shell, PHPexes pHPexes, PHPexeItem pHPexeItem) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = iAddPHPexeDialogRequestor;
        this.fStati = new IStatus[5];
        int n = 0;
        while (n < this.fStati.length) {
            this.fStati[n] = new StatusInfo();
            ++n;
        }
        this.fPHPexes = pHPexes;
        this.fEditedPHPexe = pHPexeItem;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void createDialogFields() {
        this.fPHPexeName = new StringDialogField();
        this.fPHPexeName.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpName);
        this.fPHPRoot = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField dialogField) {
                AddPHPexeDialog.this.browseForInstallDir();
            }
        });
        this.fPHPRoot.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpHome);
        this.fPHPRoot.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
    }

    protected void createFieldListeners() {
        this.fPHPexeName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                AddPHPexeDialog.this.setPHPexeNameStatus(AddPHPexeDialog.this.validatePHPexeName());
                AddPHPexeDialog.this.updateStatusLine();
            }
        });
        this.fPHPRoot.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                AddPHPexeDialog.this.setJRELocationStatus(AddPHPexeDialog.this.validateJRELocation());
                AddPHPexeDialog.this.updateStatusLine();
            }
        });
    }

    protected String getPHPexeName() {
        return this.fPHPexeName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fPHPRoot.getText());
    }

    protected Control createDialogArea(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        this.createDialogFields();
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 3;
        this.fPHPexeName.doFillIntoGrid(composite2, 3);
        this.fPHPRoot.doFillIntoGrid(composite2, 3);
        ((GridData)this.fPHPRoot.getTextControl((Composite)composite2).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.initializeFields();
        this.createFieldListeners();
        this.setJRELocationStatus(this.validateJRELocation());
        AddPHPexeDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public void create() {
        super.create();
        this.fPHPexeName.setFocus();
    }

    private void initializeFields() {
        if (this.fEditedPHPexe == null) {
            this.fPHPexeName.setText("");
            this.fPHPRoot.setText("");
        } else {
            this.fPHPexeName.setText(this.fEditedPHPexe.getName());
            this.fPHPRoot.setText(this.fEditedPHPexe.getLocation().getAbsolutePath());
        }
        this.setPHPexeNameStatus(this.validatePHPexeName());
        this.updateStatusLine();
    }

    private IStatus validateJRELocation() {
        String string = this.fPHPRoot.getText();
        StatusInfo statusInfo = null;
        File file = null;
        if (string.length() == 0) {
            statusInfo = new StatusInfo(1, PHPDebugUIMessages.addPHPexeDialog_enterLocation);
        } else {
            file = new File(string);
            if (!file.exists()) {
                statusInfo = new StatusInfo(4, PHPDebugUIMessages.addPHPexeDialog_locationNotExists);
            } else {
                final IStatus[] iStatusArray = new IStatus[1];
                final File file2 = file;
                Runnable runnable = new Runnable(){

                    public void run() {
                        iStatusArray[0] = AddPHPexeDialog.validateLocation(file2);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
                statusInfo = iStatusArray[0];
            }
        }
        return statusInfo;
    }

    private IStatus validatePHPexeName() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fPHPexeName.getText();
        if (string == null || string.trim().length() == 0) {
            statusInfo.setInfo(PHPDebugUIMessages.addPHPexeDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(string) && (this.fEditedPHPexe == null || !string.equals(this.fEditedPHPexe.getName()))) {
            statusInfo.setError(PHPDebugUIMessages.addPHPexeDialog_duplicateName);
        } else {
            IStatus iStatus = ResourcesPlugin.getWorkspace().validateName(string, 1);
            if (!iStatus.isOK()) {
                statusInfo.setError(MessageFormat.format(PHPDebugUIMessages.AddPHPexeDialog_PHP_name_must_be_a_valid_file_name___0__1, iStatus.getMessage()));
            }
        }
        return statusInfo;
    }

    protected void updateStatusLine() {
        IStatus iStatus = null;
        int n = 0;
        while (n < this.fStati.length) {
            IStatus iStatus2 = this.fStati[n];
            if (iStatus2.matches(4)) {
                this.updateStatus(iStatus2);
                return;
            }
            if (iStatus == null || iStatus2.getSeverity() > iStatus.getSeverity()) {
                iStatus = iStatus2;
            }
            ++n;
        }
        this.updateStatus(iStatus);
    }

    private void browseForInstallDir() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setFilterPath(this.fPHPRoot.getText());
        directoryDialog.setMessage(PHPDebugUIMessages.addPHPexeDialog_pickPHPRootDialog_message);
        String string = directoryDialog.open();
        if (string != null) {
            this.fPHPRoot.setText(string);
        }
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
        if (this.fEditedPHPexe == null) {
            PHPexeItem pHPexeItem = new PHPexeItem();
            this.setFieldValuesToPHPexe(pHPexeItem);
            this.fPHPexes.addItem(pHPexeItem);
            this.fRequestor.phpExeAdded(pHPexeItem);
        } else {
            this.setFieldValuesToPHPexe(this.fEditedPHPexe);
        }
    }

    protected void setFieldValuesToPHPexe(PHPexeItem pHPexeItem) {
        pHPexeItem.setLocation(new File(this.fPHPRoot.getText()).getAbsoluteFile());
        pHPexeItem.setName(this.fPHPexeName.getText());
    }

    protected File getAbsoluteFileOrEmpty(String string) {
        if (string == null || string.length() == 0) {
            return new File("");
        }
        return new File(string).getAbsoluteFile();
    }

    private void setPHPexeNameStatus(IStatus iStatus) {
        this.fStati[0] = iStatus;
    }

    private void setJRELocationStatus(IStatus iStatus) {
        this.fStati[1] = iStatus;
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(iStatus.getSeverity() == 0);
        }
    }

    protected void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_PHPexe_DIALOG_SECTION";
    }

    public static IStatus validateLocation(File file) {
        Status status = null;
        File file2 = PHPexeItem.findPHPExecutable((File)file);
        status = file2 == null ? new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.PHPexe_executable_was_not_found_1, null) : new Status(0, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.PHPexe_ok_2, null);
        return status;
    }
}

