/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11AddPartAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Operation;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11DeleteCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11ReorderParametersCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddFaultAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddOperationAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDeleteAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObjectListener;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IOperation;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.visitor.WSDLVisitorForParameters;

public class W11MessageReference
extends WSDLBaseAdapter
implements IMessageReference,
IASDObjectListener {
    protected int messageKind = -1;
    protected List parameters = null;
    protected List otherThingsToListenTo = null;

    public W11MessageReference(int messageKind) {
        this.messageKind = messageKind;
    }

    public IOperation getOwnerOperation() {
        return (IOperation)((Object)this.owner);
    }

    public String getPreview() {
        String previewString = "()";
        List params = this.getParameters();
        if (params.size() > 0) {
            IParameter param = (IParameter)params.get(0);
            previewString = param.getPreview();
        }
        return previewString;
    }

    public MessageReference getMessageReference() {
        return (MessageReference)this.target;
    }

    protected void computeMessageKind() {
        if (this.getMessageReference() instanceof Input) {
            this.messageKind = 1;
        } else if (this.getMessageReference() instanceof Output) {
            this.messageKind = 2;
        } else if (this.getMessageReference() instanceof Fault) {
            this.messageKind = 3;
        }
    }

    public int getKind() {
        if (this.messageKind == -1) {
            this.computeMessageKind();
        }
        return this.messageKind;
    }

    public String getName() {
        MessageReference messageRef = this.getMessageReference();
        if (messageRef.getName() != null) {
            return messageRef.getName();
        }
        return "";
    }

    public List getParameters() {
        ArrayList parameters = new ArrayList();
        EList parts = new ArrayList();
        MessageReference messageRef = this.getMessageReference();
        if (messageRef != null && messageRef.getEMessage() != null && messageRef.getEMessage().getEParts() != null) {
            parts = messageRef.getEMessage().getEParts();
        }
        this.populateAdapterList((List)parts, parameters);
        this.otherThingsToListenTo = new ArrayList();
        WSDLVisitorForParameters visitorForParameters = new WSDLVisitorForParameters();
        visitorForParameters.visitMessageReference(messageRef);
        this.populateAdapterList(visitorForParameters.concreteComponents, this.otherThingsToListenTo);
        this.populateAdapterList(visitorForParameters.thingsToListenTo, this.otherThingsToListenTo);
        Iterator i = this.otherThingsToListenTo.iterator();
        while (i.hasNext()) {
            Adapter adapter = (Adapter)i.next();
            if (!(adapter instanceof IASDObject)) continue;
            IASDObject asdObject = (IASDObject)adapter;
            asdObject.registerListener(this);
        }
        return parameters;
    }

    public void propertyChanged(Object object, String property) {
        if (object instanceof Adapter) {
            ((Adapter)object).getTarget();
        }
        this.clearParameters();
        this.notifyListeners(this, null);
    }

    protected void clearParameters() {
        if (this.otherThingsToListenTo != null) {
            Iterator i = this.otherThingsToListenTo.iterator();
            while (i.hasNext()) {
                Adapter adapter = (Adapter)i.next();
                if (!(adapter instanceof IASDObject)) continue;
                IASDObject asdObject = (IASDObject)adapter;
                asdObject.unregisterListener(this);
            }
        }
        this.parameters = null;
        this.otherThingsToListenTo = null;
    }

    public void notifyChanged(Notification msg) {
        this.clearParameters();
        super.notifyChanged(msg);
    }

    public String[] getActions(Object object) {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add(ASDAddOperationAction.ID);
        actions.addAll(((W11Operation)this.getOwnerOperation()).getValidInputOutpuActions());
        actions.add(ASDAddFaultAction.ID);
        actions.add(W11AddPartAction.ID);
        actions.add(ASDDeleteAction.ID);
        actions.add("SUBMENU_START_ID: " + Messages.getString("_UI_ACTION_SET_MESSAGE"));
        actions.add(W11SetNewMessageAction.ID);
        actions.add(W11SetExistingMessageAction.ID);
        actions.add("SUBMENU_END_ID: ");
        actions.add("org.eclipse.wst.wsdl.ui.internal.asd.actions.ShowPropertiesViewAction");
        String[] actionIDs = new String[actions.size()];
        int index = 0;
        while (index < actions.size()) {
            actionIDs[index] = (String)actions.get(index);
            ++index;
        }
        return actionIDs;
    }

    public Command getReorderParametersCommand(IParameter leftSibling, IParameter rightSibling, IParameter movingParameter) {
        return new W11ReorderParametersCommand(leftSibling, rightSibling, movingParameter);
    }

    public Command getDeleteCommand() {
        return new W11DeleteCommand(this);
    }

    public Image getImage() {
        if (this.getKind() == 1) {
            return WSDLEditorPlugin.getInstance().getImage("icons/input_obj.gif");
        }
        if (this.getKind() == 2) {
            return WSDLEditorPlugin.getInstance().getImage("icons/output_obj.gif");
        }
        if (this.getKind() == 3) {
            return WSDLEditorPlugin.getInstance().getImage("icons/fault_obj.gif");
        }
        return null;
    }

    public String getText() {
        if (this.getKind() == 1) {
            return "Input";
        }
        if (this.getKind() == 2) {
            return "Output";
        }
        if (this.getKind() == 3) {
            return this.getName();
        }
        return "NoName";
    }

    public ITreeElement[] getChildren() {
        List parts = this.getParameters();
        ITreeElement[] treeElements = new ITreeElement[parts.size()];
        int index = 0;
        while (index < parts.size()) {
            treeElements[index] = (ITreeElement)parts.get(index);
            ++index;
        }
        return treeElements;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public ITreeElement getParent() {
        return null;
    }
}

