/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.project.options.includepath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.core.IncludePathVariableInitializer;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.project.options.includepath.IncludePathVariablesListener;

public class IncludePathVariableManager {
    private static IncludePathVariableManager instance;
    IPreferenceStore preferenceStore = PHPCorePlugin.getDefault().getPreferenceStore();
    HashMap variables = new HashMap();
    private ArrayList listeners;

    public static IncludePathVariableManager instance() {
        if (instance == null) {
            instance = new IncludePathVariableManager();
        }
        return instance;
    }

    public String[] getReservedIncludePathVariableNames() {
        return new String[0];
    }

    private IncludePathVariableManager() {
    }

    public IPath getIncludePathVariable(String string) {
        return (IPath)this.variables.get(string);
    }

    public void setIncludePathVariables(String[] stringArray, IPath[] iPathArray, SubProgressMonitor subProgressMonitor) {
        this.variables.clear();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (iPathArray[n] != null) {
                this.variables.put(stringArray[n], iPathArray[n]);
                if (n > 0) {
                    stringBuffer.append(",");
                    stringBuffer2.append(",");
                }
                stringBuffer.append(stringArray[n]);
                stringBuffer2.append(iPathArray[n].toOSString());
            }
            ++n;
        }
        this.preferenceStore.setValue("org.eclipse.php.core.includePathVariableNames", stringBuffer.toString());
        this.preferenceStore.setValue("org.eclipse.php.core.includePathVariablePaths", stringBuffer2.toString());
        this.fireIncludePathVariablesChanged(stringArray, iPathArray);
    }

    private void fireIncludePathVariablesChanged(String[] stringArray, IPath[] iPathArray) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((IncludePathVariablesListener)iterator.next()).includePathVariablesChanged(stringArray, iPathArray);
        }
    }

    public void addListener(IncludePathVariablesListener includePathVariablesListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(includePathVariablesListener)) {
            this.listeners.add(includePathVariablesListener);
        }
    }

    public void removeListener(IncludePathVariablesListener includePathVariablesListener) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        if (this.listeners.contains(includePathVariablesListener)) {
            this.listeners.remove(includePathVariablesListener);
        }
    }

    public String[] getIncludePathVariableNames() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.variables.keySet());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void startUp() {
        String string = this.preferenceStore.getString("org.eclipse.php.core.includePathVariableNames");
        String string2 = this.preferenceStore.getString("org.eclipse.php.core.includePathVariablePaths");
        String[] stringArray = new String[]{};
        if (string.length() > 0) {
            stringArray = string.split(",");
        }
        String[] stringArray2 = new String[]{};
        if (string2.length() > 0) {
            stringArray2 = string2.split(",");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string3 = n < stringArray2.length ? stringArray2[n] : "";
            this.variables.put(stringArray[n], new Path(string3));
            ++n;
        }
        this.initExtensionPoints();
    }

    private void initExtensionPoints() {
        PHPCorePlugin pHPCorePlugin = PHPCorePlugin.getDefault();
        if (pHPCorePlugin == null) {
            return;
        }
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.php.core", "includePathVariableInitializer");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string = iConfigurationElementArray[n2].getAttribute("variable");
                    try {
                        Object object = iConfigurationElementArray[n2].createExecutableExtension("class");
                        if (object instanceof IncludePathVariableInitializer) {
                            ((IncludePathVariableInitializer)object).initialize(string);
                        }
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public synchronized void putVariable(String string, IPath iPath) {
        this.variables.put(string, iPath);
    }
}

