/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class PHPDebugPreferencesWorkspaceAddon
extends AbstractPHPPreferencePageBlock {
    private Text fDebugTextBox;
    private Button fUsePHPDebugPerspective;
    private Button fRunWithDebugInfo;
    private Button fOpenInBrowser;
    private Button fOpenDebugViews;
    private Button fAutoSaveDirty;
    private PropertyPage propertyPage;

    public void setCompositeAddon(Composite composite) {
        Composite composite2 = this.addPageContents(composite);
        this.addWorkspacePreferenceSubsection(this.createSubsection(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_0));
    }

    public void initializeValues(PropertyPage propertyPage) {
        this.propertyPage = propertyPage;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fUsePHPDebugPerspective.setSelection(preferences.getBoolean(PHPDebugCorePreferenceNames.USE_PHP_DEBUG_PERSPECTIVE));
        this.fOpenDebugViews.setSelection(preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS));
        this.fRunWithDebugInfo.setSelection(preferences.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO));
        this.fOpenInBrowser.setSelection(preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER));
        this.fAutoSaveDirty.setSelection(preferences.getBoolean(PHPDebugCorePreferenceNames.AUTO_SAVE_DIRTY));
        this.fDebugTextBox.setText(Integer.toString(preferences.getInt(PHPDebugCorePreferenceNames.DEBUG_PORT)));
    }

    public boolean performOK(boolean bl) {
        this.savePreferences();
        PHPDebugPlugin.getDefault().setLaunchPerspective();
        return true;
    }

    public void performApply(boolean bl) {
        this.performOK(bl);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fUsePHPDebugPerspective.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.USE_PHP_DEBUG_PERSPECTIVE));
        this.fRunWithDebugInfo.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO));
        this.fOpenInBrowser.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER));
        this.fOpenDebugViews.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS));
        this.fAutoSaveDirty.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.AUTO_SAVE_DIRTY));
        this.fDebugTextBox.setText(Integer.toString(preferences.getDefaultInt(PHPDebugCorePreferenceNames.DEBUG_PORT)));
    }

    private void addWorkspacePreferenceSubsection(Composite composite) {
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_3, PHPDebugCorePreferenceNames.DEBUG_PORT);
        this.fDebugTextBox = this.addDebugPortTextField(composite, PHPDebugCorePreferenceNames.DEBUG_PORT, 6, 2);
        this.fUsePHPDebugPerspective = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_2, PHPDebugCorePreferenceNames.USE_PHP_DEBUG_PERSPECTIVE, 0);
        this.fRunWithDebugInfo = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_5, PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, 0);
        this.fOpenInBrowser = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_11, PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, 0);
        this.fOpenDebugViews = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_7, PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, 0);
        this.fAutoSaveDirty = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_10, PHPDebugCorePreferenceNames.AUTO_SAVE_DIRTY, 0);
    }

    private void savePreferences() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        preferences.setValue(PHPDebugCorePreferenceNames.USE_PHP_DEBUG_PERSPECTIVE, this.fUsePHPDebugPerspective.getSelection());
        preferences.setValue(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, this.fRunWithDebugInfo.getSelection());
        preferences.setValue(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, this.fOpenInBrowser.getSelection());
        preferences.setValue(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, this.fOpenDebugViews.getSelection());
        preferences.setValue(PHPDebugCorePreferenceNames.AUTO_SAVE_DIRTY, this.fAutoSaveDirty.getSelection());
        preferences.setValue(PHPDebugCorePreferenceNames.DEBUG_PORT, this.fDebugTextBox.getText());
        PHPDebugPlugin.getDefault().savePluginPreferences();
    }

    private Text addDebugPortTextField(Composite composite, String string, int n, int n2) {
        Text text = new Text(composite, 2052);
        text.setData((Object)string);
        GridData gridData = new GridData();
        if (n != 0) {
            text.setTextLimit(n);
        }
        gridData.horizontalIndent = n2;
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        text.addModifyListener((ModifyListener)new DebugPortValidateListener());
        return text;
    }

    class DebugPortValidateListener
    implements ModifyListener {
        DebugPortValidateListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string = null;
            boolean bl = true;
            String string2 = ((Text)modifyEvent.widget).getText();
            try {
                Integer n = new Integer(string2);
                int n2 = n;
                if (n2 < 0 || n2 > 65535) {
                    bl = false;
                    string = PHPDebugUIMessages.PhpDebugPreferencePage_4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                string = PHPDebugUIMessages.PhpDebugPreferencePage_4;
            }
            catch (Exception exception) {
                bl = false;
                string = PHPDebugUIMessages.PhpDebugPreferencePage_4;
            }
            this.setErrorMessage(string);
            this.setValid(bl);
        }

        private void setValid(boolean bl) {
            if (PHPDebugPreferencesWorkspaceAddon.this.propertyPage != null) {
                PHPDebugPreferencesWorkspaceAddon.this.propertyPage.setValid(bl);
            }
        }

        private void setErrorMessage(String string) {
            if (PHPDebugPreferencesWorkspaceAddon.this.propertyPage != null) {
                PHPDebugPreferencesWorkspaceAddon.this.propertyPage.setErrorMessage(string);
            }
        }
    }
}

