/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.core.manager;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.core.util.preferences.XMLPreferencesReader;
import org.eclipse.php.core.util.preferences.XMLPreferencesWriter;
import org.eclipse.php.server.core.Activator;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.server.core.manager.IServersManagerListener;
import org.eclipse.php.server.core.manager.ServerManagerEvent;

public class ServersManager
implements PropertyChangeListener {
    private ArrayList listeners;
    private Server defaultServer;
    private static ServersManager instance;
    private static final String SERVERS_PREFERENCES_KEY = "phpServers";
    private static final String DEFAULT_SERVER_PREFERENCES_KEY = "defaultPHPServer";
    private static final String BASE_URL = "http://localhost";
    public static final String Default_Server_Name = "Default PHP Web Server";
    private HashMap servers = new HashMap();

    public static ServersManager getInstance() {
        if (instance == null) {
            instance = new ServersManager();
        }
        return instance;
    }

    private ServersManager() {
        this.listeners = new ArrayList();
        this.loadServers();
    }

    public static void addManagerListener(IServersManagerListener iServersManagerListener) {
        ServersManager.getInstance().listeners.add(iServersManagerListener);
    }

    public static void removeManagerListener(IServersManagerListener iServersManagerListener) {
        ServersManager.getInstance().listeners.remove(iServersManagerListener);
    }

    public static void addServer(Server server) {
        ServerManagerEvent serverManagerEvent;
        if (server == null) {
            return;
        }
        ServersManager serversManager = ServersManager.getInstance();
        Server server2 = serversManager.servers.put(server.getName(), server);
        if (server2 != null) {
            server2.removePropertyChangeListener(serversManager);
            serverManagerEvent = new ServerManagerEvent(2, server2);
            serversManager.fireEvent(serverManagerEvent);
        }
        serverManagerEvent = new ServerManagerEvent(0, server);
        serversManager.fireEvent(serverManagerEvent);
        server.addPropertyChangeListener(serversManager);
    }

    public static Server removeServer(String string) {
        if (string == null) {
            return null;
        }
        ServersManager serversManager = ServersManager.getInstance();
        Server server = (Server)serversManager.servers.remove(string);
        if (server != null) {
            Server[] serverArray;
            server.removePropertyChangeListener(serversManager);
            ServerManagerEvent serverManagerEvent = new ServerManagerEvent(2, server);
            serversManager.fireEvent(serverManagerEvent);
            if (server == serversManager.defaultServer && (serverArray = ServersManager.getServers()).length > 0) {
                ServersManager.setDefaultServer(serverArray[0]);
            }
        }
        return server;
    }

    public static Server getServer(String string) {
        ServersManager serversManager = ServersManager.getInstance();
        return (Server)serversManager.servers.get(string);
    }

    public static Server[] getServers() {
        ServersManager serversManager = ServersManager.getInstance();
        Collection collection = serversManager.servers.values();
        Server[] serverArray = new Server[collection.size()];
        collection.toArray(serverArray);
        return serverArray;
    }

    public static Server getDefaultServer() {
        Server server = ServersManager.getInstance().defaultServer;
        if (server == null) {
            ServersManager.getInstance().defaultServer = server = ServersManager.createServer(Default_Server_Name, BASE_URL);
        }
        return server;
    }

    public static void setDefaultServer(Server server) {
        ServersManager serversManager = ServersManager.getInstance();
        if (server != serversManager.defaultServer) {
            serversManager.defaultServer = server;
            serversManager.innerSaveDefaultServer();
        }
    }

    public static Server createServer(String string, String string2) {
        Server server = new Server(string, "localhost", string2, "", false);
        ServersManager.addServer(server);
        return server;
    }

    public static void save() {
        IXMLPreferencesStorable[] iXMLPreferencesStorableArray = ServersManager.getServers();
        XMLPreferencesWriter.write((Preferences)Activator.getDefault().getPluginPreferences(), (String)SERVERS_PREFERENCES_KEY, (IXMLPreferencesStorable[])iXMLPreferencesStorableArray);
        Activator.getDefault().savePluginPreferences();
    }

    private void innerSaveDefaultServer() {
        if (this.defaultServer != null) {
            Activator.getDefault().getPluginPreferences().setValue(DEFAULT_SERVER_PREFERENCES_KEY, this.defaultServer.getName());
            Activator.getDefault().savePluginPreferences();
        }
    }

    private void loadServers() {
        String string = Activator.getDefault().getPluginPreferences().getString(DEFAULT_SERVER_PREFERENCES_KEY);
        HashMap[] hashMapArray = XMLPreferencesReader.read((Preferences)Activator.getDefault().getPluginPreferences(), (String)SERVERS_PREFERENCES_KEY);
        Server server = null;
        int n = 0;
        while (n < hashMapArray.length) {
            HashMap hashMap = hashMapArray[n];
            Server server2 = new Server();
            server2.restoreFromMap(hashMap);
            if (server == null) {
                server = server2;
            }
            String string2 = server2.getName();
            this.servers.put(string2, server2);
            if (this.defaultServer == null && string2.equals(string)) {
                this.defaultServer = server2;
            }
            server2.addPropertyChangeListener(this);
            ++n;
        }
        if (this.defaultServer == null) {
            this.defaultServer = server;
            this.innerSaveDefaultServer();
        }
    }

    public void fireEvent(ServerManagerEvent serverManagerEvent) {
        IServersManagerListener[] iServersManagerListenerArray = new IServersManagerListener[this.listeners.size()];
        this.listeners.toArray(iServersManagerListenerArray);
        if (serverManagerEvent.getType() == 0) {
            this.fireAddEvent(serverManagerEvent, iServersManagerListenerArray);
        } else if (serverManagerEvent.getType() == 2) {
            this.fireRemoveEvent(serverManagerEvent, iServersManagerListenerArray);
        } else if (serverManagerEvent.getType() == 4) {
            this.fireModifiedEvent(serverManagerEvent, iServersManagerListenerArray);
        }
    }

    private void fireAddEvent(ServerManagerEvent serverManagerEvent, IServersManagerListener[] iServersManagerListenerArray) {
        int n = 0;
        while (n < iServersManagerListenerArray.length) {
            iServersManagerListenerArray[n].serverAdded(serverManagerEvent);
            ++n;
        }
    }

    private void fireRemoveEvent(ServerManagerEvent serverManagerEvent, IServersManagerListener[] iServersManagerListenerArray) {
        int n = 0;
        while (n < iServersManagerListenerArray.length) {
            iServersManagerListenerArray[n].serverRemoved(serverManagerEvent);
            ++n;
        }
    }

    private void fireModifiedEvent(ServerManagerEvent serverManagerEvent, IServersManagerListener[] iServersManagerListenerArray) {
        int n = 0;
        while (n < iServersManagerListenerArray.length) {
            iServersManagerListenerArray[n].serverModified(serverManagerEvent);
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Server server = (Server)propertyChangeEvent.getSource();
        String string = (String)propertyChangeEvent.getOldValue();
        String string2 = (String)propertyChangeEvent.getNewValue();
        ServerManagerEvent serverManagerEvent = new ServerManagerEvent(4, server, propertyChangeEvent.getPropertyName(), string, string2);
        this.fireEvent(serverManagerEvent);
    }
}

