/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.core.PHPCorePlugin;
import org.eclipse.php.core.documentModel.validate.PHPProblemsValidator;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;

public class PhpResourceDeltaBuildVisitor
implements IResourceDeltaVisitor {
    private PHPProblemsValidator validator = new PHPProblemsValidator();

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        switch (iResourceDelta.getResource().getType()) {
            case 1: {
                this.processFileDelta(iResourceDelta);
                return false;
            }
            case 4: {
                return this.processProjectDelta(iResourceDelta);
            }
        }
        return true;
    }

    private void processFileDelta(IResourceDelta iResourceDelta) {
        IFile iFile = (IFile)iResourceDelta.getResource();
        switch (iResourceDelta.getKind()) {
            case 1: {
                PHPWorkspaceModelManager.getInstance().addFileToModel(iFile);
                this.validator.validateFile(iFile);
            }
            case 4: {
                this.validator.validateFile(iFile);
                break;
            }
            case 2: {
                PHPWorkspaceModelManager.getInstance().removeFileFromModel(iFile);
            }
        }
    }

    private boolean processProjectDelta(IResourceDelta iResourceDelta) {
        IProject iProject = (IProject)iResourceDelta.getResource();
        try {
            return iProject.hasNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return false;
        }
    }
}

