/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.php.ui.editor.PHPHeuristicScanner;

public final class PHPPairMatcher
implements ICharacterPairMatcher {
    private char[] fPairs;
    private IDocument fDocument;
    private int fOffset;
    private int fStartPos;
    private int fEndPos;
    private int fAnchor;
    private boolean fHighlightAngularBrackets = false;

    public PHPPairMatcher(char[] cArray) {
        this.fPairs = cArray;
    }

    public IRegion match(IDocument iDocument, int n) {
        this.fOffset = n;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = iDocument;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchPairsAt() {
        int n = this.fPairs.length;
        int n2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char c = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int n3 = 0;
            while (n3 < this.fPairs.length) {
                if (c == this.fPairs[n3]) {
                    this.fStartPos = this.fOffset - 1;
                    n = n3;
                }
                n3 += 2;
            }
            n3 = 1;
            while (n3 < this.fPairs.length) {
                if (c == this.fPairs[n3]) {
                    this.fEndPos = this.fOffset - 1;
                    n2 = n3;
                }
                n3 += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[n2 - 1], this.fPairs[n2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
                return false;
            }
            if (this.fStartPos <= -1) return false;
            this.fAnchor = 1;
            this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[n], this.fPairs[n + 1], this.fDocument);
            if (this.fEndPos > -1) {
                return true;
            }
            this.fStartPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private int searchForClosingPeer(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = c == '<';
        if (bl && !this.fHighlightAngularBrackets) {
            return -1;
        }
        PHPHeuristicScanner pHPHeuristicScanner = new PHPHeuristicScanner(iDocument, "___php_partitioning", TextUtilities.getContentType((IDocument)iDocument, (String)"___php_partitioning", (int)n, (boolean)false));
        if (bl && !this.isTypeParameterBracket(n, iDocument, pHPHeuristicScanner)) {
            return -1;
        }
        return pHPHeuristicScanner.findClosingPeer(n + 1, c, c2);
    }

    private int searchForOpeningPeer(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        boolean bl;
        boolean bl2 = bl = c == '<';
        if (bl && !this.fHighlightAngularBrackets) {
            return -1;
        }
        PHPHeuristicScanner pHPHeuristicScanner = new PHPHeuristicScanner(iDocument, "___php_partitioning", TextUtilities.getContentType((IDocument)iDocument, (String)"___php_partitioning", (int)n, (boolean)false));
        int n2 = pHPHeuristicScanner.findOpeningPeer(n - 1, c, c2);
        if (n2 == -1) {
            return -1;
        }
        if (bl && !this.isTypeParameterBracket(n2, iDocument, pHPHeuristicScanner)) {
            return -1;
        }
        return n2;
    }

    private boolean isTypeParameterBracket(int n, IDocument iDocument, PHPHeuristicScanner pHPHeuristicScanner) {
        try {
            String string;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = pHPHeuristicScanner.previousToken(n - 1, iRegion.getOffset());
            int n3 = pHPHeuristicScanner.getPosition() + 1;
            String string2 = string = n2 == -1 ? null : iDocument.get(n3, n - n3).trim();
            return n2 == 1 || n2 == 2 || n2 == 7 || n2 == 1022 || n2 == 1019 || n2 == 2000 && this.isTypeParameterIntroducer(string) || n2 == -1;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTypeParameterIntroducer(String string) {
        return string.length() > 0 && (Character.isUpperCase(string.charAt(0)) || string.startsWith("final") || string.startsWith("public") || string.startsWith("public") || string.startsWith("protected") || string.startsWith("private"));
    }
}

