/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.PHPUIMessages;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.UserData;
import org.eclipse.php.ui.PHPUiPlugin;
import org.eclipse.php.ui.dialogs.openType.OpenPhpTypeDialog;
import org.eclipse.php.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeAction
implements IWorkbenchWindowActionDelegate {
    public void run(IAction iAction) {
        Shell shell = PHPUiPlugin.getActiveWorkbenchShell();
        OpenPhpTypeDialog openPhpTypeDialog = new OpenPhpTypeDialog(shell);
        int n = openPhpTypeDialog.open();
        if (n != 0) {
            return;
        }
        CodeData codeData = openPhpTypeDialog.getSelectedElement();
        this.openEditor(codeData);
    }

    protected void openEditor(CodeData codeData) {
        IEditorPart iEditorPart;
        UserData userData = codeData.getUserData();
        String string = userData.getFileName();
        IFile iFile = PHPUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        try {
            iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
        }
        catch (PartInitException partInitException) {
            ExceptionHandler.handle((CoreException)((Object)partInitException), PHPUIMessages.OpenTypeAction_errorTitle, PHPUIMessages.OpenTypeAction_errorMessage);
            return;
        }
        this.revealInEditor(iEditorPart, userData, codeData);
    }

    private void revealInEditor(IEditorPart iEditorPart, UserData userData, CodeData codeData) {
        this.revealInEditor(iEditorPart, userData.getStopPosition(), codeData.getName().length());
    }

    private void revealInEditor(IEditorPart iEditorPart, int n, int n2) {
        ((ITextEditor)iEditorPart).selectAndReveal(n, n2);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }
}

