/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.util;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.php.ui.util.PHPElementImageProvider;
import org.eclipse.php.ui.util.PHPElementLabels;
import org.eclipse.php.ui.util.StorageLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class PHPUILabelProvider
extends LabelProvider
implements IColorProvider {
    protected PHPElementImageProvider fImageLabelProvider = new PHPElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fImageFlags;
    private int fTextFlags;
    IPHPTreeContentProvider[] treeProviders;

    public PHPUILabelProvider() {
        this(3, 11);
    }

    public PHPUILabelProvider(int n, int n2) {
        this.fImageFlags = n2;
        this.fTextFlags = n;
    }

    public void setTreeProviders(IPHPTreeContentProvider[] iPHPTreeContentProviderArray) {
        this.treeProviders = iPHPTreeContentProviderArray;
    }

    public final void setTextFlags(int n) {
        this.fTextFlags = n;
    }

    public final void setImageFlags(int n) {
        this.fImageFlags = n;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final int getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object object) {
        return this.getImageFlags();
    }

    protected int evaluateTextFlags(Object object) {
        return this.getTextFlags();
    }

    public Image getImage(Object object) {
        Image image = this.fImageLabelProvider.getImageLabel(object, this.evaluateImageFlags(object));
        if (image == null && this.treeProviders != null) {
            int n = 0;
            while (n < this.treeProviders.length && image == null) {
                image = this.treeProviders[n].getImage(object);
                ++n;
            }
        }
        if (image == null && object instanceof IStorage) {
            image = this.fStorageLabelProvider.getImage(object);
        }
        return image;
    }

    public String getText(Object object) {
        String string = PHPElementLabels.getTextLabel(object, this.evaluateTextFlags(object));
        if (string.length() == 0 && this.treeProviders != null) {
            int n = 0;
            while (n < this.treeProviders.length) {
                string = this.treeProviders[n].getText(object);
                if (string != null && string.length() > 0) break;
                ++n;
            }
            if (string == null) {
                string = "";
            }
        }
        if (string.length() == 0 && object instanceof IStorage) {
            string = this.fStorageLabelProvider.getText(object);
        }
        return string;
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public Color getForeground(Object object) {
        return null;
    }

    public Color getBackground(Object object) {
        return null;
    }
}

