/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.properties.PropertyMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.impl.SingletonAdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class AbstractGeneratorAdapter
extends SingletonAdapterImpl
implements GeneratorAdapter {
    protected static final String MANIFEST_ENCODING = "UTF-8";
    protected static final String PROPERTIES_ENCODING = "ISO-8859-1";
    protected GeneratorAdapterFactory adapterFactory;
    protected Object generatingObject;
    protected String message;
    protected JETEmitter[] jetEmitters;
    protected GIFEmitter[] gifEmitters;
    protected ImportManager importManager;
    protected URIConverter uriConverter;
    protected static final Class[] OBJECT_ARGUMENT;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        OBJECT_ARGUMENT = classArray;
    }

    public AbstractGeneratorAdapter() {
    }

    public AbstractGeneratorAdapter(GeneratorAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public GeneratorAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(GeneratorAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory;
    }

    public Collection getCanGenerateChildren(Object object, Object projectType) {
        return Collections.EMPTY_LIST;
    }

    public Object getCanGenerateParent(Object object, Object projectType) {
        return null;
    }

    public abstract boolean canGenerate(Object var1, Object var2);

    public Collection getGenerateChildren(Object object, Object projectType) {
        return Collections.EMPTY_LIST;
    }

    public Object getGenerateParent(Object object, Object projectType) {
        return null;
    }

    public final Diagnostic preGenerate(Object object, Object projectType) {
        try {
            this.generatingObject = object;
            if (this.getGenerator().getOptions().dynamicTemplates) {
                this.jetEmitters = null;
                this.gifEmitters = null;
            }
            Diagnostic diagnostic = this.doPreGenerate(object, projectType);
            Object var3_4 = null;
            this.generatingObject = null;
            return diagnostic;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.generatingObject = null;
            throw throwable;
        }
    }

    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        return Diagnostic.OK_INSTANCE;
    }

    public final Diagnostic generate(Object object, Object projectType, Monitor monitor) {
        Diagnostic diagnostic;
        block5: {
            if (!this.canGenerate(object, projectType)) break block5;
            this.generatingObject = object;
            this.message = null;
            Diagnostic diagnostic2 = this.doGenerate(object, projectType, monitor);
            Object var5_7 = null;
            this.generatingObject = null;
            this.message = null;
            monitor.done();
            return diagnostic2;
        }
        try {
            diagnostic = Diagnostic.OK_INSTANCE;
            Object var5_8 = null;
            this.generatingObject = null;
            this.message = null;
        }
        catch (Exception exception) {
            Diagnostic diagnostic3;
            try {
                diagnostic3 = this.toDiagnostic(exception, this.message);
                Object var5_9 = null;
                this.generatingObject = null;
                this.message = null;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.generatingObject = null;
                this.message = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return diagnostic3;
        }
        monitor.done();
        return diagnostic;
    }

    protected abstract Diagnostic doGenerate(Object var1, Object var2, Monitor var3) throws Exception;

    public final Diagnostic postGenerate(Object object, Object projectType) {
        try {
            this.generatingObject = object;
            if (this.getGenerator().getOptions().dynamicTemplates) {
                this.jetEmitters = null;
                this.gifEmitters = null;
            }
            Diagnostic diagnostic = this.doPostGenerate(object, projectType);
            Object var3_4 = null;
            this.generatingObject = null;
            return diagnostic;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.generatingObject = null;
            throw throwable;
        }
    }

    protected Diagnostic doPostGenerate(Object object, Object projectType) {
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic toDiagnostic(Exception exception, String currentMessage) {
        CodeGenEcorePlugin.INSTANCE.log(exception);
        currentMessage = currentMessage != null ? CodeGenEcorePlugin.INSTANCE.getString("_UI_GenerateException_diagnostic", new Object[]{currentMessage}) : CodeGenEcorePlugin.INSTANCE.getString("_UI_GenericGenerateException_diagnostic");
        BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.codegen.ecore", 0, currentMessage, null);
        diagnostic.add(BasicDiagnostic.toDiagnostic((Throwable)exception));
        return diagnostic;
    }

    protected Generator getGenerator() {
        return this.getAdapterFactory().getGenerator();
    }

    protected JETEmitter getJETEmitter(JETEmitterDescriptor[] jetEmitterDescriptors, int id) {
        JETEmitter jetEmitter;
        if (this.jetEmitters == null) {
            this.jetEmitters = new JETEmitter[jetEmitterDescriptors.length];
        }
        if ((jetEmitter = this.jetEmitters[id]) == null) {
            this.jetEmitters[id] = jetEmitter = this.createJETEmitter(jetEmitterDescriptors[id]);
        }
        return jetEmitter;
    }

    protected JETEmitter createJETEmitter(JETEmitterDescriptor jetEmitterDescriptor) {
        JETEmitter jetEmitter = new JETEmitter(this.getGenerator().getOptions().templatePath, jetEmitterDescriptor.templatePathName, this.getClass().getClassLoader());
        try {
            this.setStaticTemplateClass(jetEmitter, jetEmitterDescriptor.className);
            this.addClasspathEntries(jetEmitter);
        }
        catch (JETException exception) {
            CodeGenEcorePlugin.INSTANCE.log((Object)exception);
        }
        return jetEmitter;
    }

    protected void setStaticTemplateClass(JETEmitter jetEmitter, String className) {
        if (!this.getGenerator().getOptions().dynamicTemplates) {
            try {
                Class<?> templateClass = this.getClass().getClassLoader().loadClass(className);
                Method emitterMethod = templateClass.getDeclaredMethod("generate", OBJECT_ARGUMENT);
                jetEmitter.setMethod(emitterMethod);
            }
            catch (Exception exception) {}
        }
    }

    protected void addClasspathEntries(JETEmitter jetEmitter) throws JETException {
    }

    protected GIFEmitter getGIFEmitter(String[] inputPathNames, int id) {
        GIFEmitter gifEmitter;
        if (this.gifEmitters == null) {
            this.gifEmitters = new GIFEmitter[inputPathNames.length];
        }
        if ((gifEmitter = this.gifEmitters[id]) == null) {
            this.gifEmitters[id] = gifEmitter = this.createGIFEmitter(inputPathNames[id]);
        }
        return gifEmitter;
    }

    protected GIFEmitter createGIFEmitter(String inputPathName) {
        return new GIFEmitter(JETCompiler.find((String[])this.getGenerator().getOptions().templatePath, (String)inputPathName));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateText(String targetPathName, JETEmitter jetEmitter, Object[] arguments, boolean overwrite, String encoding, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingFile_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean exists = this.exists(targetFile);
                if (!exists || overwrite) {
                    if (arguments == null) {
                        arguments = new Object[]{this.generatingObject};
                    }
                    String emitterResult = jetEmitter.generate(this.createMonitor(monitor, 1), arguments);
                    if (PROPERTIES_ENCODING.equals(encoding)) {
                        emitterResult = CodeGenUtil.unicodeEscapeEncode((String)emitterResult);
                    }
                    if (encoding == null) {
                        encoding = this.getEncoding(targetFile);
                    }
                    boolean changed = true;
                    if (exists) {
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                        String oldContents = this.getContents(targetFile, encoding);
                        boolean bl = changed = !emitterResult.equals(oldContents);
                    }
                    if (changed) {
                        boolean redirect;
                        byte[] bytes = encoding == null ? emitterResult.toString().getBytes() : emitterResult.toString().getBytes(encoding);
                        String redirection = this.getGenerator().getOptions().redirectionPattern;
                        boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                        if (redirect) {
                            String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                            targetFile = targetDirectory.appendSegment(baseName);
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                        }
                        if (this.isReadOnly(targetFile)) {
                            if (this.getGenerator().getOptions().forceOverwrite) {
                                this.validateEdit(targetFile, this.createMonitor(monitor, 1));
                                this.setWriteable(targetFile);
                            } else {
                                targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                            }
                        }
                        OutputStream outputStream = this.createOutputStream(targetFile);
                        outputStream.write(bytes);
                        outputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var16_19 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateProperties(String targetPathName, JETEmitter jetEmitter, Object[] arguments, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingFile_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean changed = false;
                if (arguments == null) {
                    arguments = new Object[]{this.generatingObject};
                }
                String emitterResult = CodeGenUtil.unicodeEscapeEncode((String)jetEmitter.generate(this.createMonitor(monitor, 1), arguments));
                byte[] bytes = emitterResult.toString().getBytes(PROPERTIES_ENCODING);
                if (this.exists(targetFile)) {
                    PropertyMerger propertyMerger = new PropertyMerger();
                    propertyMerger.setSourceProperties(emitterResult);
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                    String oldProperties = propertyMerger.createPropertiesForInputStream(this.createInputStream(targetFile));
                    propertyMerger.setTargetProperties(oldProperties);
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                    propertyMerger.merge();
                    String mergedResult = propertyMerger.getTargetProperties();
                    boolean bl = changed = !mergedResult.equals(oldProperties);
                    if (changed) {
                        if (this.isReadOnly(targetFile) && this.validateEdit(targetFile, this.createMonitor(monitor, 1))) {
                            propertyMerger.setTargetProperties(propertyMerger.createPropertiesForInputStream(this.createInputStream(targetFile)));
                            propertyMerger.merge();
                            mergedResult = propertyMerger.getTargetProperties();
                        }
                        bytes = mergedResult.getBytes(PROPERTIES_ENCODING);
                    }
                } else {
                    changed = true;
                    monitor.worked(1);
                }
                if (changed) {
                    boolean redirect;
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(bytes);
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_17 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateGIF(String targetPathName, GIFEmitter gifEmitter, String parentKey, String childKey, boolean overwrite, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingImage_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean exists = this.exists(targetFile);
                if (!exists || overwrite) {
                    boolean redirect;
                    byte[] emitterResult = gifEmitter.generateGIF(parentKey, childKey);
                    monitor.worked(1);
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.validateEdit(targetFile, this.createMonitor(monitor, 1));
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(emitterResult);
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateJava(String targetPath, String packageName, String className, JETEmitter jetEmitter, Object[] arguments, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 4);
                URI targetDirectory = this.toURI(targetPath).appendSegments(packageName.split("\\."));
                URI targetFile = targetDirectory.appendSegment(String.valueOf(className) + ".java");
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{targetFile}));
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                if (arguments == null) {
                    arguments = new Object[]{this.generatingObject};
                }
                this.createImportManager(packageName, className);
                String emitterResult = jetEmitter.generate(this.createMonitor(monitor, 1), arguments);
                boolean changed = true;
                String newContents = emitterResult;
                JControlModel jControlModel = this.getGenerator().getJControlModel();
                if (jControlModel.canMerge()) {
                    Object codeFormatter;
                    JMerger jMerger = new JMerger(jControlModel);
                    jMerger.setFixInterfaceBrace(true);
                    jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(emitterResult));
                    Object object = codeFormatter = this.getGenerator().getOptions().codeFormatting ? this.createCodeFormatter(this.getGenerator().getOptions().codeFormatterOptions, targetFile) : null;
                    if (this.exists(targetFile)) {
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                        jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), this.getEncoding(targetFile)));
                        String oldContents = jMerger.getTargetCompilationUnitContents();
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                        jMerger.merge();
                        newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                        boolean bl = changed = !oldContents.equals(newContents);
                        if (changed && this.isReadOnly(targetFile) && this.validateEdit(targetFile, this.createMonitor(monitor, 1))) {
                            jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), this.getEncoding(targetFile)));
                            jMerger.remerge();
                            newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                        }
                    } else {
                        changed = true;
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                        jMerger.merge();
                        newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                    }
                    if (jControlModel.getFacadeHelper() != null) {
                        jControlModel.getFacadeHelper().reset();
                    }
                } else {
                    newContents = CodeGenUtil.convertFormat((String)jControlModel.getLeadingTabReplacement(), (boolean)jControlModel.convertToStandardBraceStyle(), (String)emitterResult);
                    if (this.exists(targetFile)) {
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                        String oldContents = this.getContents(targetFile, null);
                        changed = !oldContents.equals(newContents);
                    } else {
                        changed = true;
                    }
                }
                monitor.worked(1);
                if (changed) {
                    boolean redirect;
                    String encoding = this.getEncoding(targetFile);
                    byte[] bytes = encoding == null ? newContents.getBytes() : newContents.getBytes(encoding);
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, String.valueOf(className) + ".java");
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + className + ".java.new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(bytes);
                    outputStream.close();
                }
            }
            catch (Exception e) {
                RuntimeException runtimeException;
                if (e instanceof RuntimeException) {
                    runtimeException = (RuntimeException)e;
                    throw runtimeException;
                }
                runtimeException = new WrappedException(e);
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            this.clearImportManager();
            monitor.done();
            throw throwable;
        }
        {
            Object var18_21 = null;
            this.clearImportManager();
        }
        monitor.done();
    }

    protected URI toURI(String pathName) {
        return URI.createURI((String)pathName);
    }

    protected URI toPlatformResourceURI(URI uri) {
        return URI.createPlatformResourceURI((String)uri.toString(), (boolean)true);
    }

    protected Monitor createMonitor(Monitor monitor, int ticks) {
        return CodeGenUtil.createMonitor((Monitor)monitor, (int)ticks);
    }

    protected void createImportManager(String packageName, String className) {
        this.importManager = new ImportManager(packageName);
        this.importManager.addMasterImport(packageName, className);
    }

    protected void clearImportManager() {
        this.importManager = null;
    }

    protected ImportManager getImportManager() {
        return this.importManager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EclipseHelper.ensureProjectExists(workspacePath, object, projectType, force, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ensureContainerExists(URI workspacePath, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EclipseHelper.ensureContainerExists(workspacePath.toString(), monitor);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
    }

    protected URIConverter getURIConverter() {
        URIConverter result;
        ResourceSet resourceSet = this.getGenerator().getOptions().resourceSet;
        URIConverter uRIConverter = result = resourceSet != null ? resourceSet.getURIConverter() : null;
        if (result != null) {
            return result;
        }
        if (this.uriConverter == null) {
            this.uriConverter = new URIConverterImpl();
        }
        return this.uriConverter;
    }

    protected boolean exists(URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.exists(workspacePath.toString());
        }
        URI uri = this.getURIConverter().normalize(this.toPlatformResourceURI(workspacePath));
        if ("file".equalsIgnoreCase(uri.scheme())) {
            return new File(uri.toFileString()).exists();
        }
        try {
            InputStream inputStream = this.getURIConverter().createInputStream(uri);
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected boolean isReadOnly(URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.isReadOnly(workspacePath.toString());
        }
        URI uri = this.getURIConverter().normalize(this.toPlatformResourceURI(workspacePath));
        if ("file".equalsIgnoreCase(uri.scheme())) {
            File file = new File(uri.toFileString());
            return file.exists() && !file.canWrite();
        }
        return false;
    }

    protected void setWriteable(URI workspacePath) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EclipseHelper.setWriteable(workspacePath.toString());
            return;
        }
        URI uri = this.getURIConverter().normalize(this.toPlatformResourceURI(workspacePath));
        if ("file".equalsIgnoreCase(uri.scheme())) {
            new File(uri.toFileString()).delete();
        }
    }

    protected boolean validateEdit(URI workspacePath, Monitor monitor) {
        block3: {
            boolean bl;
            try {
                if (!EMFPlugin.IS_ECLIPSE_RUNNING) break block3;
                bl = EclipseHelper.validateEdit(workspacePath.toString(), monitor);
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return bl;
        }
        Object var3_5 = null;
        monitor.done();
        return false;
    }

    protected InputStream createInputStream(URI workspacePath) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.createInputStream(workspacePath.toString());
        }
        return this.getURIConverter().createInputStream(this.toPlatformResourceURI(workspacePath));
    }

    protected OutputStream createOutputStream(URI workspacePath) throws Exception {
        return this.getURIConverter().createOutputStream(this.toPlatformResourceURI(workspacePath));
    }

    protected String getContents(URI workspacePath, String encoding) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.createInputStream(workspacePath));
        byte[] input = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(input);
        bufferedInputStream.close();
        return encoding == null ? new String(input) : new String(input, encoding);
    }

    protected String getEncoding(URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.getEncoding(workspacePath.toString());
        }
        return null;
    }

    protected Object createCodeFormatter(Map options, URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.createCodeFormatter(options, workspacePath.toString());
        }
        return null;
    }

    protected String formatCode(String contents, Object codeFormatter) {
        return EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseHelper.formatCode(contents, codeFormatter) : contents;
    }

    protected static class JETEmitterDescriptor {
        public String templatePathName;
        public String className;

        public JETEmitterDescriptor(String templatePathName, String className) {
            this.templatePathName = templatePathName;
            this.className = className;
        }
    }

    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static boolean ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
            try {
                Path path = new Path(workspacePath);
                if (path.isAbsolute()) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(path.segment(0));
                    if (!project.exists() || force) {
                        IPath javaSource = path.uptoSegment(1).append("src");
                        org.eclipse.emf.codegen.ecore.Generator.createEMFProject(javaSource, null, Collections.EMPTY_LIST, monitor, org.eclipse.emf.codegen.ecore.Generator.EMF_PLUGIN_PROJECT_STYLE);
                    }
                    return workspace.getRoot().getProject(path.segment(0)).exists();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
            return false;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static boolean ensureContainerExists(String workspacePath, Monitor monitor) {
            Path path = new Path(workspacePath);
            IProject container = null;
            try {
                try {
                    IWorkspace workspace;
                    IProject project;
                    monitor.beginTask("", path.segmentCount() + 1);
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_OpeningFolder_message", new Object[]{path}));
                    if (path.isAbsolute() && (project = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getProject(path.segment(0))).exists()) {
                        if (!project.isOpen()) {
                            project.open(BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)monitor, (int)1)));
                        } else {
                            monitor.worked(1);
                        }
                        container = project;
                        int i = 1;
                        int length = path.segmentCount();
                        while (i < length) {
                            IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                            if (!folder.exists()) {
                                folder.create(false, true, BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)monitor, (int)1)));
                            }
                            container = folder;
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var9_12 = null;
            }
            monitor.done();
            return container != null && container.getFullPath().equals((Object)path);
        }

        public static boolean exists(String workspacePath) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).exists();
        }

        public static boolean isReadOnly(String workspacePath) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).isReadOnly();
        }

        public static void setWriteable(String workspacePath) throws Exception {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath));
            ResourceAttributes resourceAttributes = file.getResourceAttributes();
            if (resourceAttributes != null) {
                resourceAttributes.setReadOnly(false);
                file.setResourceAttributes(resourceAttributes);
            }
        }

        public static boolean validateEdit(String workspacePath, Monitor monitor) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath));
            return file.getWorkspace().validateEdit(new IFile[]{file}, (Object)monitor).isOK();
        }

        public static InputStream createInputStream(String workspacePath) throws Exception {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getContents(true);
        }

        public static String getEncoding(String workspacePath) {
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getCharset();
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public static Object createCodeFormatter(Map options, String workspacePath) {
            IJavaProject javaProject;
            IProject project;
            if (options == null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(workspacePath).segment(0))) != null && (javaProject = JavaCore.create((IProject)project)) != null) {
                options = javaProject.getOptions(true);
            }
            return ToolFactory.createCodeFormatter((Map)options);
        }

        public static String formatCode(String contents, Object codeFormatter) {
            Document doc;
            TextEdit edit;
            if (codeFormatter instanceof CodeFormatter && (edit = ((CodeFormatter)codeFormatter).format(8, (doc = new Document(contents)).get(), 0, doc.get().length(), 0, null)) != null) {
                try {
                    edit.apply((IDocument)doc);
                    contents = doc.get();
                }
                catch (Exception exception) {
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
            return contents;
        }
    }
}

