/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.editor.XSDFileEditorInput;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public class W11OpenExternalEditorHelper
implements IOpenExternalEditorHelper {
    private Object object;
    private IFile wsdlFile;

    public W11OpenExternalEditorHelper(IFile wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public void setModel(Object object) {
        this.object = object;
    }

    public void openExternalEditor() {
        Notifier notifier;
        Object openOnModel;
        if (this.object instanceof WSDLBaseAdapter && (openOnModel = this.getModelToOpenOn(notifier = ((WSDLBaseAdapter)this.object).getTarget())) instanceof XSDConcreteComponent) {
            this.openXSDEditor((XSDConcreteComponent)openOnModel);
        }
    }

    protected XSDSchema getSchema(XSDConcreteComponent xsdComponent) {
        Notifier notifier;
        XSDSchema schema = xsdComponent.getSchema();
        if (schema == null && (notifier = ((WSDLBaseAdapter)this.object).getTarget()) instanceof XSDConcreteComponent) {
            schema = ((XSDConcreteComponent)notifier).getSchema();
        }
        return schema;
    }

    protected void openXSDEditor(XSDConcreteComponent xsdComponent) {
        XSDSchema schema = this.getSchema(xsdComponent);
        if (schema != null) {
            IWorkbenchWindow workbenchWindow;
            String schemaLocation = URIHelper.removePlatformResourceProtocol((String)schema.getSchemaLocation());
            Path schemaPath = new Path(schemaLocation);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
            if (file != null && file.exists() && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                IWorkbenchPage page = workbenchWindow.getActivePage();
                try {
                    IEditorPart editorPart = null;
                    if (this.isInlineSchema(file)) {
                        XSDFileEditorInput editorInput = new XSDFileEditorInput(file, schema);
                        editorInput.setEditorName(String.valueOf(Messages._UI_LABEL_INLINE_SCHEMA_OF) + file.getName());
                        IEditorReference[] refs = page.getEditorReferences();
                        int length = refs.length;
                        int i = 0;
                        while (i < length) {
                            IFile aFile;
                            IEditorInput input = refs[i].getEditorInput();
                            if (input instanceof XSDFileEditorInput && (aFile = ((XSDFileEditorInput)input).getFile()).getFullPath().equals((Object)file.getFullPath()) && ((XSDFileEditorInput)input).getSchema() == schema) {
                                editorPart = refs[i].getEditor(true);
                                page.activate(refs[i].getPart(true));
                                break;
                            }
                            ++i;
                        }
                        if (editorPart == null) {
                            editorPart = page.openEditor((IEditorInput)editorInput, "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", true, 0);
                        }
                    } else {
                        editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    if (editorPart instanceof InternalXSDMultiPageEditor) {
                        InternalXSDMultiPageEditor xsdEditor = (InternalXSDMultiPageEditor)editorPart;
                        xsdEditor.openOnGlobalReference(xsdComponent);
                    }
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    public boolean linkApplicable() {
        IParameter param;
        String prefix;
        boolean applicable = true;
        if (this.object instanceof IParameter && (prefix = (param = (IParameter)this.object).getComponentNameQualifier()) != null && prefix.equals("http://www.w3.org/2001/XMLSchema")) {
            applicable = false;
        }
        return applicable;
    }

    protected Object getModelToOpenOn(Object object) {
        if (object instanceof XSDElementDeclaration) {
            return ((XSDElementDeclaration)object).getTypeDefinition();
        }
        if (object instanceof Part) {
            XSDElementDeclaration elementOrType = ((Part)object).getElementDeclaration();
            if (elementOrType == null) {
                elementOrType = ((Part)object).getTypeDefinition();
            }
            return elementOrType;
        }
        return object;
    }

    protected boolean isInlineSchema(IFile file) {
        return file.getFullPath().equals((Object)this.wsdlFile.getFullPath());
    }
}

