/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointWorkingSetCache;
import org.eclipse.debug.internal.ui.views.breakpoints.WorkingSetCategory;
import org.eclipse.debug.ui.AbstractBreakpointOrganizerDelegate;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class BreakpointSetOrganizer
extends AbstractBreakpointOrganizerDelegate
implements IPropertyChangeListener,
IBreakpointsListener {
    private IWorkingSetManager fWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
    private BreakpointWorkingSetCache fCache = null;

    public BreakpointSetOrganizer() {
        this.fWorkingSetManager.addPropertyChangeListener((IPropertyChangeListener)this);
        this.fCache = new BreakpointWorkingSetCache();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        ArrayList<WorkingSetCategory> result = new ArrayList<WorkingSetCategory>();
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                IAdaptable[] elements = set.getElements();
                int j = 0;
                while (j < elements.length) {
                    IAdaptable adaptable = elements[j];
                    if (adaptable.equals(breakpoint)) {
                        result.add(new WorkingSetCategory(set));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IAdaptable[result.size()]);
    }

    public void dispose() {
        this.fWorkingSetManager.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fWorkingSetManager = null;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        IWorkingSet set = null;
        if (event.getNewValue() instanceof IWorkingSet) {
            set = (IWorkingSet)event.getNewValue();
        } else if (event.getOldValue() instanceof IWorkingSet) {
            set = (IWorkingSet)event.getOldValue();
        }
        if (event.getProperty().equals("workingSetAdd")) {
            IAdaptable[] breakpoints = set.getElements();
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i] instanceof IBreakpoint) {
                    IMarker marker = ((IBreakpoint)breakpoints[i]).getMarker();
                    this.fCache.addEntry(marker, set.getName());
                    this.fCache.flushMarkerCache(marker);
                }
                ++i;
            }
        }
        if (set != null && "org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
            this.fireCategoryChanged((IAdaptable)new WorkingSetCategory(set));
        }
        if (event.getProperty().equals(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME)) {
            IWorkingSet defaultWorkingSet = BreakpointSetOrganizer.getDefaultWorkingSet();
            if (defaultWorkingSet != null) {
                this.fireCategoryChanged((IAdaptable)new WorkingSetCategory(defaultWorkingSet));
            } else {
                this.fireCategoryChanged(null);
            }
        }
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        IWorkingSet set = null;
        int i = 0;
        while (i < breakpoints.length) {
            IMarker marker = breakpoints[i].getMarker();
            String[] names = this.getWorkingsetAttributeFromMarker(marker, "workingset_name");
            if (names.length == 0) {
                this.addBreakpointToSet(breakpoints[i], BreakpointSetOrganizer.getDefaultWorkingSet());
            } else {
                int j = 1;
                while (j < names.length) {
                    set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(names[j]);
                    if (set == null) {
                        set = BreakpointSetOrganizer.getDefaultWorkingSet();
                    }
                    this.addBreakpointToSet(breakpoints[i], set);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addBreakpointToSet(IBreakpoint breakpoint, IWorkingSet set) {
        if (set != null) {
            IAdaptable[] elements = set.getElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].equals(breakpoint)) {
                    return;
                }
                ++i;
            }
            this.fCache.addEntry(breakpoint.getMarker(), set.getName());
            this.fCache.flushMarkerCache(breakpoint.getMarker());
            IAdaptable[] newElements = new IAdaptable[elements.length + 1];
            newElements[newElements.length - 1] = breakpoint;
            System.arraycopy(elements, 0, newElements, 0, elements.length);
            set.setElements(newElements);
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        IWorkingSet set = null;
        int i = 0;
        while (i < workingSets.length) {
            set = workingSets[i];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                this.clean(set);
            }
            ++i;
        }
    }

    private void clean(IWorkingSet workingSet) {
        IAdaptable[] elements = workingSet.getElements();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        boolean update = false;
        int i = 0;
        while (i < elements.length) {
            IBreakpoint breakpoint;
            IAdaptable adaptable = elements[i];
            if (adaptable instanceof IBreakpoint && !manager.isRegistered(breakpoint = (IBreakpoint)adaptable)) {
                update = true;
                elements[i] = null;
            }
            ++i;
        }
        if (update) {
            ArrayList<IAdaptable> newElements = new ArrayList<IAdaptable>(elements.length);
            int i2 = 0;
            while (i2 < elements.length) {
                IAdaptable adaptable = elements[i2];
                if (adaptable != null) {
                    newElements.add(adaptable);
                }
                ++i2;
            }
            workingSet.setElements(newElements.toArray(new IAdaptable[newElements.size()]));
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    public static IWorkingSet getDefaultWorkingSet() {
        IPreferenceStore preferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String name = preferenceStore.getString(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME);
        if (name != null) {
            return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
        }
        return null;
    }

    public static void setDefaultWorkingSet(IWorkingSet set) {
        String name = "";
        if (set != null && "org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
            name = set.getName();
        }
        DebugUIPlugin.getDefault().getPluginPreferences().setValue(IInternalDebugUIConstants.MEMENTO_BREAKPOINT_WORKING_SET_NAME, name);
    }

    public boolean canRemove(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            WorkingSetCategory wsc = (WorkingSetCategory)category;
            return "org.eclipse.debug.ui.breakpointWorkingSet".equals(wsc.getWorkingSet().getId());
        }
        return super.canRemove(breakpoint, category);
    }

    public boolean canAdd(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            WorkingSetCategory wsc = (WorkingSetCategory)category;
            return "org.eclipse.debug.ui.breakpointWorkingSet".equals(wsc.getWorkingSet().getId());
        }
        return super.canAdd(breakpoint, category);
    }

    public void addBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            IWorkingSet set = ((WorkingSetCategory)category).getWorkingSet();
            this.addBreakpointToSet(breakpoint, set);
        }
    }

    private String[] getWorkingsetAttributeFromMarker(IMarker marker, String type) {
        try {
            String name = (String)marker.getAttribute(type);
            if (name != null) {
                return name.split("\\<;#>");
            }
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
        return new String[0];
    }

    public void removeBreakpoint(IBreakpoint breakpoint, IAdaptable category) {
        if (category instanceof WorkingSetCategory) {
            IWorkingSet set = ((WorkingSetCategory)category).getWorkingSet();
            IAdaptable[] elements = set.getElements();
            ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
            int i = 0;
            while (i < elements.length) {
                IAdaptable adaptable = elements[i];
                if (!adaptable.equals(breakpoint)) {
                    list.add(adaptable);
                }
                ++i;
            }
            this.fCache.removeMappedEntry(breakpoint.getMarker(), set.getName());
            this.fCache.flushMarkerCache(breakpoint.getMarker());
            set.setElements(list.toArray(new IAdaptable[list.size()]));
        }
    }

    public IAdaptable[] getCategories() {
        IWorkingSet[] workingSets = this.fWorkingSetManager.getWorkingSets();
        ArrayList<WorkingSetCategory> all = new ArrayList<WorkingSetCategory>();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet set = workingSets[i];
            if ("org.eclipse.debug.ui.breakpointWorkingSet".equals(set.getId())) {
                all.add(new WorkingSetCategory(set));
            }
            ++i;
        }
        return all.toArray(new IAdaptable[all.size()]);
    }
}

