/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.DefaultingUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.ProjectTopologyContext;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.FacetMatchCache;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.ISelection;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceClient;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.wsrt.SimpleContext;
import org.eclipse.wst.ws.internal.wsrt.WebServiceClientInfo;
import org.eclipse.wst.ws.internal.wsrt.WebServiceScenario;
import org.eclipse.wst.ws.internal.wsrt.WebServiceState;

public class ClientRuntimeSelectionWidgetDefaultingCommand
extends AbstractDataModelOperation {
    private String DEFAULT_CLIENT_EAR_PROJECT_EXT = "EAR";
    private TypeRuntimeServer clientIds_;
    private boolean clientIdsFixed_ = false;
    private String clientRuntimeId_;
    private String clientProjectName_;
    private String clientEarProjectName_;
    protected boolean clientNeedEAR_ = true;
    private String clientComponentType_;
    private FacetMatcher clientFacetMatcher_;
    private IContext context_;
    private ISelection selection_;
    private IWebServiceClient webServiceClient_;
    private ResourceContext resourceContext_;
    private boolean test_;
    private IProject initialProject_;
    private IProject clientInitialProject_;
    private String wsdlURI_;
    private WebServicesParser parser_;

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientIds_ = ids;
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientIds_;
    }

    public void setClientIdsFixed(boolean b) {
        this.clientIdsFixed_ = b;
    }

    public String getClientRuntimeId() {
        return this.clientRuntimeId_;
    }

    public String getClientProjectName() {
        return this.clientProjectName_;
    }

    public String getClientEarProjectName() {
        return this.clientEarProjectName_;
    }

    public void setClientEarProjectName(String name) {
        this.clientEarProjectName_ = name;
    }

    public String getClientComponentType() {
        return this.clientComponentType_;
    }

    public IWebServiceClient getWebService() {
        return this.webServiceClient_;
    }

    public IContext getContext() {
        return this.context_;
    }

    public ISelection getSelection() {
        return this.selection_;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        try {
            IStatus serverStatus;
            IProject clientProject;
            if (this.clientIdsFixed_ && this.clientProjectName_ == null) {
                DefaultRuntimeTriplet drt = this.getDefaultClientRuntimeForFixedRuntimeAndServer(this.clientInitialProject_);
                this.clientFacetMatcher_ = drt.getFacetMatcher();
                this.clientProjectName_ = drt.getProjectName();
                this.clientRuntimeId_ = drt.getRuntimeId();
            } else {
                ValidationUtils vu = new ValidationUtils();
                DefaultRuntimeTriplet drt = null;
                if (!vu.isProjectServiceProject(this.clientInitialProject_, this.wsdlURI_, this.parser_) && !this.clientIdsFixed_) {
                    drt = this.getDefaultRuntime(this.clientInitialProject_, this.clientIds_.getTypeId(), true);
                    this.clientFacetMatcher_ = drt.getFacetMatcher();
                    this.clientProjectName_ = drt.getProjectName();
                    this.clientRuntimeId_ = drt.getRuntimeId();
                } else if (!vu.isProjectServiceProject(this.initialProject_, this.wsdlURI_, this.parser_) && !this.clientIdsFixed_) {
                    drt = this.getDefaultRuntime(this.initialProject_, this.clientIds_.getTypeId(), true);
                    this.clientFacetMatcher_ = drt.getFacetMatcher();
                    this.clientProjectName_ = drt.getProjectName();
                    this.clientRuntimeId_ = drt.getRuntimeId();
                } else {
                    drt = this.getDefaultRuntime(null, this.clientIds_.getTypeId(), true);
                    this.clientRuntimeId_ = drt.getRuntimeId();
                }
                this.clientIds_.setRuntimeId(WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(this.clientRuntimeId_).getRuntime().getId());
            }
            if (this.clientProjectName_ == null) {
                this.clientProjectName_ = this.getDefaultClientProjectName();
            }
            this.clientComponentType_ = !(clientProject = ProjectUtilities.getProject((String)this.clientProjectName_)).exists() ? this.getDefaultClientProjectTemplate() : "";
            if (!this.clientIdsFixed_ && (serverStatus = this.setClientDefaultServer()).getSeverity() == 4) {
                env.getStatusHandler().reportError(serverStatus);
                return serverStatus;
            }
            this.setDefaultClientEarProject();
            this.setDefaultsForExtension(env);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            IStatus errorStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Object[])new String[]{e.getMessage()}), (Throwable)e);
            env.getStatusHandler().reportError(errorStatus);
            return errorStatus;
        }
    }

    private void setDefaultClientEarProject() {
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
        if (clientProject.exists()) {
            this.clientNeedEAR_ = !FacetUtils.isJavaProject((IProject)clientProject);
        } else {
            boolean bl = this.clientNeedEAR_ = !FacetUtils.isUtilityTemplate((String)this.clientComponentType_);
        }
        if (this.clientNeedEAR_) {
            String serverId = this.clientIds_.getServerId();
            if (serverId != null) {
                String serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverId);
                if (serverTargetId != null && serverTargetId.length() > 0 && !ServerUtils.isTargetValidForEAR((String)serverTargetId, (String)"13")) {
                    this.clientNeedEAR_ = false;
                }
            } else {
                this.clientNeedEAR_ = false;
            }
        }
        this.clientEarProjectName_ = this.clientNeedEAR_ ? DefaultingUtils.getDefaultEARProjectName(this.clientProjectName_) : "";
    }

    private IStatus setClientDefaultServer() {
        IServerType serverType;
        IServer server;
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)ServerUtils.getModule((IProject)clientProject), null);
        if (configuredServers != null && configuredServers.length > 0) {
            this.clientIds_.setServerId(configuredServers[0].getServerType().getId());
            this.clientIds_.setServerInstanceId(configuredServers[0].getId());
            return Status.OK_STATUS;
        }
        if (clientProject.exists()) {
            server = this.getServerFromProject(this.clientProjectName_, this.clientFacetMatcher_);
            if (server != null) {
                this.clientIds_.setServerId(server.getServerType().getId());
                this.clientIds_.setServerInstanceId(server.getId());
                return Status.OK_STATUS;
            }
            serverType = this.getServerTypeFromProject(this.clientProjectName_, this.clientFacetMatcher_);
            if (serverType != null) {
                this.clientIds_.setServerId(serverType.getId());
                return Status.OK_STATUS;
            }
        }
        if ((server = this.getServerFromClientRuntimeId()) != null) {
            this.clientIds_.setServerId(server.getServerType().getId());
            this.clientIds_.setServerInstanceId(server.getId());
            return Status.OK_STATUS;
        }
        serverType = this.getServerTypeFromClientRuntimeId();
        if (serverType != null) {
            this.clientIds_.setServerId(serverType.getId());
            return Status.OK_STATUS;
        }
        RuntimeDescriptor runtimeDescriptor = WebServiceRuntimeExtensionUtils2.getRuntimeById(this.clientIds_.getRuntimeId());
        if (runtimeDescriptor.getServerRequired()) {
            String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(this.clientIds_.getRuntimeId());
            IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_NO_SERVER_RUNTIME, (Object[])new String[]{runtimeLabel}));
            return status;
        }
        return Status.OK_STATUS;
    }

    private IServer getServerFromClientRuntimeId() {
        IServer[] servers = ServerCore.getServers();
        if (servers != null && servers.length > 0) {
            String serverFactoryId;
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String preferredServerFactoryId = context.getServerFactoryId();
            int j = 0;
            while (j < servers.length) {
                serverFactoryId = servers[j].getServerType().getId();
                if (serverFactoryId == preferredServerFactoryId && WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(this.clientRuntimeId_, serverFactoryId)) {
                    return servers[j];
                }
                ++j;
            }
            int i = 0;
            while (i < servers.length) {
                serverFactoryId = servers[i].getServerType().getId();
                if (WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(this.clientRuntimeId_, serverFactoryId)) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    private IServerType getServerTypeFromClientRuntimeId() {
        String[] serverTypes = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientRuntime(this.clientRuntimeId_);
        if (serverTypes != null && serverTypes.length > 0) {
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String preferredServerFactoryId = context.getServerFactoryId();
            int i = 0;
            while (i < serverTypes.length) {
                if (serverTypes[i].equals(preferredServerFactoryId)) {
                    return ServerCore.findServerType((String)serverTypes[i]);
                }
                ++i;
            }
            return ServerCore.findServerType((String)serverTypes[0]);
        }
        return null;
    }

    protected IServer getServerFromProject(String projectName, FacetMatcher facetMatcher) {
        IServer server = null;
        IProject project = ProjectUtilities.getProject((String)projectName);
        IServer[] servers = ServerCore.getServers();
        if (servers.length > 0) {
            Set facets;
            PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
            String preferredServerFactoryId = context.getServerFactoryId();
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = null;
            IFacetedProject fProject = null;
            if (project != null && project.exists()) {
                try {
                    fProject = ProjectFacetsManager.create((IProject)project);
                    if (fProject != null) {
                        fRuntime = fProject.getRuntime();
                    }
                }
                catch (CoreException coreException) {}
            }
            if (fRuntime != null) {
                IServer firstMatchingServer = null;
                IRuntime sRuntime = FacetUtil.getRuntime(fRuntime);
                int i = 0;
                while (i < servers.length) {
                    IServer thisServer = servers[i];
                    if (thisServer.getRuntime().getId().equals(sRuntime.getId())) {
                        if (firstMatchingServer == null) {
                            firstMatchingServer = thisServer;
                        }
                        if (thisServer.getServerType().getId().equals(preferredServerFactoryId)) {
                            server = thisServer;
                            break;
                        }
                    }
                    ++i;
                }
                if (server == null && firstMatchingServer != null) {
                    server = firstMatchingServer;
                }
            }
            if (server == null && project != null && project.exists() && (facets = FacetUtils.getFacetsForProject((String)project.getName())) != null) {
                HashSet facetsClone = new HashSet();
                facetsClone.addAll(facets);
                if (facetMatcher.getFacetsToAdd() != null) {
                    Iterator itr = facetMatcher.getFacetsToAdd().iterator();
                    while (itr.hasNext()) {
                        facetsClone.add(itr.next());
                    }
                }
                server = this.getServerFromFacets(facetsClone);
            }
        }
        return server;
    }

    protected IServer getServerFromFacets(Set facets) {
        IServer server = null;
        Set runtimes = FacetUtils.getRuntimes((Set[])new Set[]{facets});
        Iterator itr = runtimes.iterator();
        IServer[] servers = ServerCore.getServers();
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredServerFactoryId = context.getServerFactoryId();
        int j = 0;
        while (j < servers.length) {
            IServer thisServer = servers[j];
            if (thisServer.getServerType().getId().equals(preferredServerFactoryId)) {
                Iterator runtimesItr = runtimes.iterator();
                while (runtimesItr.hasNext()) {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtimesItr.next();
                    IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
                    if (!thisServer.getRuntime().getId().equals(sRuntime.getId())) continue;
                    server = thisServer;
                }
            }
            ++j;
        }
        if (server == null) {
            block2: while (itr.hasNext()) {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)itr.next();
                IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
                int i = 0;
                while (i < servers.length) {
                    IServer thisServer = servers[i];
                    if (thisServer.getRuntime().getId().equals(sRuntime.getId())) {
                        server = thisServer;
                        break block2;
                    }
                    ++i;
                }
            }
        }
        return server;
    }

    protected IServerType getServerTypeFromProject(String projectName, FacetMatcher facetMatcher) {
        Set facets;
        IServerType serverType = null;
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredServerFactoryId = context.getServerFactoryId();
        IProject project = ProjectUtilities.getProject((String)projectName);
        IServerType[] serverTypes = ServerCore.getServerTypes();
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = null;
        IFacetedProject fProject = null;
        if (project != null && project.exists()) {
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
                if (fProject != null) {
                    fRuntime = fProject.getRuntime();
                }
            }
            catch (CoreException coreException) {}
        }
        if (fRuntime != null) {
            IRuntime sRuntime = FacetUtil.getRuntime(fRuntime);
            IServerType firstMatchingServerType = null;
            int i = 0;
            while (i < serverTypes.length) {
                IServerType thisServerType = serverTypes[i];
                if (thisServerType.getRuntimeType().getId().equals(sRuntime.getRuntimeType().getId())) {
                    if (firstMatchingServerType == null) {
                        firstMatchingServerType = thisServerType;
                    }
                    if (thisServerType.getId().equals(preferredServerFactoryId)) {
                        serverType = thisServerType;
                        break;
                    }
                }
                ++i;
            }
            if (serverType == null && firstMatchingServerType != null) {
                serverType = firstMatchingServerType;
            }
        }
        if (serverType == null && project != null && project.exists() && (facets = FacetUtils.getFacetsForProject((String)project.getName())) != null) {
            HashSet facetsClone = new HashSet();
            facetsClone.addAll(facets);
            if (facetMatcher.getFacetsToAdd() != null) {
                Iterator itr = facetMatcher.getFacetsToAdd().iterator();
                while (itr.hasNext()) {
                    facetsClone.add(itr.next());
                }
            }
            serverType = this.getServerTypeFromFacets(facetsClone);
        }
        return serverType;
    }

    protected IServerType getServerTypeFromFacets(Set facets) {
        IServerType serverType = null;
        Set runtimes = FacetUtils.getRuntimes((Set[])new Set[]{facets});
        Iterator itr = runtimes.iterator();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredServerFactoryId = context.getServerFactoryId();
        int j = 0;
        while (j < serverTypes.length) {
            IServerType thisServerType = serverTypes[j];
            if (thisServerType.getId().equals(preferredServerFactoryId)) {
                Iterator runtimesItr = runtimes.iterator();
                while (runtimesItr.hasNext()) {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtimesItr.next();
                    IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
                    if (!thisServerType.getRuntimeType().getId().equals(sRuntime.getRuntimeType().getId())) continue;
                    serverType = thisServerType;
                }
            }
            ++j;
        }
        if (serverType == null) {
            block2: while (itr.hasNext()) {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)itr.next();
                IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
                int i = 0;
                while (i < serverTypes.length) {
                    IServerType thisServerType = serverTypes[i];
                    if (thisServerType.getRuntimeType().getId().equals(sRuntime.getRuntimeType().getId())) {
                        serverType = thisServerType;
                        break block2;
                    }
                    ++i;
                }
            }
        }
        return serverType;
    }

    protected IServer getServerFromProjectType(String templateId, FacetMatcher facetMatcher) {
        IServer server = null;
        Set facets = FacetUtils.getInitialFacetVersionsFromTemplate((String)templateId);
        if (facetMatcher.getFacetsToAdd() != null) {
            Iterator itr = facetMatcher.getFacetsToAdd().iterator();
            while (itr.hasNext()) {
                facets.add(itr.next());
            }
        }
        server = this.getServerFromFacets(facets);
        return server;
    }

    protected IServerType getServerTypeFromProjectType(String templateId, FacetMatcher facetMatcher) {
        IServerType serverType = null;
        Set facets = FacetUtils.getInitialFacetVersionsFromTemplate((String)templateId);
        if (facetMatcher.getFacetsToAdd() != null) {
            Iterator itr = facetMatcher.getFacetsToAdd().iterator();
            while (itr.hasNext()) {
                facets.add(itr.next());
            }
        }
        serverType = this.getServerTypeFromFacets(facets);
        return serverType;
    }

    private String getDefaultClientProjectTemplate() {
        String[] templates = WebServiceRuntimeExtensionUtils2.getClientProjectTemplates(this.clientIds_.getTypeId(), this.clientIds_.getRuntimeId());
        ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
        String[] preferredTemplateIds = ptc.getClientTypes();
        int j = 0;
        while (j < preferredTemplateIds.length) {
            int i = 0;
            while (i < templates.length) {
                boolean matches;
                String templateId = templates[i];
                if (templateId.equals(preferredTemplateIds[j]) && (matches = WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportTemplate(this.clientRuntimeId_, templateId))) {
                    return templates[i];
                }
                ++i;
            }
            ++j;
        }
        if (templates.length > 0) {
            return templates[0];
        }
        return "";
    }

    private String getDefaultClientProjectName() {
        ValidationUtils vu = new ValidationUtils();
        IProject[] projects = FacetUtils.getAllProjects();
        ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(this.clientRuntimeId_);
        RequiredFacetVersion[] rfvs = desc.getRequiredFacetVersions();
        int i = 0;
        while (i < projects.length) {
            if (!vu.isProjectServiceProject(projects[i], this.wsdlURI_, this.parser_)) {
                Set facetVersions = FacetUtils.getFacetsForProject((String)projects[i].getName());
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = null;
                String fRuntimeName = null;
                fRuntime = FacetUtils.getFacetRuntimeForProject((String)projects[i].getName());
                if (fRuntime != null) {
                    fRuntimeName = fRuntime.getName();
                }
                if (facetVersions != null) {
                    FacetMatcher fm = FacetMatchCache.getInstance().getMatchForProject(true, this.clientRuntimeId_, projects[i].getName());
                    boolean facetRuntimeMatches = true;
                    if (fRuntimeName != null) {
                        facetRuntimeMatches = FacetUtils.isFacetRuntimeSupported((RequiredFacetVersion[])rfvs, (String)fRuntimeName);
                    }
                    if (fm.isMatch() && facetRuntimeMatches) {
                        this.clientFacetMatcher_ = fm;
                        return projects[i].getName();
                    }
                }
            }
            ++i;
        }
        return ResourceUtils.getDefaultWebProjectName();
    }

    private DefaultRuntimeTriplet getDefaultClientRuntimeForFixedRuntimeAndServer(IProject project) {
        String[] clientRuntimes = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(this.clientIds_.getTypeId());
        ArrayList<String> validClientRuntimes = new ArrayList<String>();
        int i = 0;
        while (i < clientRuntimes.length) {
            ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimes[i]);
            if (desc.getRuntime().getId().equals(this.clientIds_.getRuntimeId()) && WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(desc.getId(), this.clientIds_.getServerId())) {
                FacetMatcher fm;
                Set facetVersions;
                validClientRuntimes.add(desc.getId());
                if (project != null && project.exists() && (facetVersions = FacetUtils.getFacetsForProject((String)project.getName())) != null && (fm = FacetMatchCache.getInstance().getMatchForProject(true, clientRuntimes[i], project.getName())).isMatch()) {
                    DefaultRuntimeTriplet drt = new DefaultRuntimeTriplet();
                    drt.setFacetMatcher(fm);
                    drt.setProjectName(project.getName());
                    drt.setRuntimeId(desc.getId());
                    return drt;
                }
            }
            ++i;
        }
        if (validClientRuntimes.size() > 0) {
            DefaultRuntimeTriplet drt = new DefaultRuntimeTriplet();
            drt.setFacetMatcher(null);
            drt.setProjectName(null);
            drt.setRuntimeId(validClientRuntimes.toArray(new String[0])[0]);
            return drt;
        }
        this.clientIdsFixed_ = false;
        return this.getDefaultRuntime(project, this.clientIds_.getTypeId(), true);
    }

    protected DefaultRuntimeTriplet getDefaultRuntime(IProject project, String typeId, boolean isClient) {
        String[] runtimes = null;
        runtimes = isClient ? WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(typeId) : WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredRuntimeId = context.getRuntimeId();
        ArrayList<String> preferredRuntimeIdsList = new ArrayList<String>();
        ArrayList<String> otherRuntimeIdsList = new ArrayList<String>();
        int k = 0;
        while (k < runtimes.length) {
            Object desc;
            String descRuntimeId = null;
            if (isClient) {
                desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(runtimes[k]);
                descRuntimeId = ((ClientRuntimeDescriptor)desc).getRuntime().getId();
            } else {
                desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(runtimes[k]);
                descRuntimeId = ((ServiceRuntimeDescriptor)desc).getRuntime().getId();
            }
            if (descRuntimeId.equals(preferredRuntimeId)) {
                preferredRuntimeIdsList.add(runtimes[k]);
            } else {
                otherRuntimeIdsList.add(runtimes[k]);
            }
            ++k;
        }
        String[] preferredRuntimeIds = preferredRuntimeIdsList.toArray(new String[0]);
        String[] otherRuntimeIds = otherRuntimeIdsList.toArray(new String[0]);
        Set facetVersions = null;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = null;
        String fRuntimeName = null;
        if (project != null && project.exists()) {
            facetVersions = FacetUtils.getFacetsForProject((String)project.getName());
            fRuntime = FacetUtils.getFacetRuntimeForProject((String)project.getName());
            fRuntimeName = null;
            if (fRuntime != null) {
                fRuntimeName = fRuntime.getName();
            }
            if (facetVersions != null) {
                DefaultRuntimeTriplet drt;
                FacetMatcher fm;
                boolean facetRuntimeMatches;
                FacetMatcher fm2;
                int p = 0;
                while (p < preferredRuntimeIds.length) {
                    RequiredFacetVersion[] prfv = null;
                    prfv = isClient ? WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(preferredRuntimeIds[p]).getRequiredFacetVersions() : WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(preferredRuntimeIds[p]).getRequiredFacetVersions();
                    fm2 = FacetMatchCache.getInstance().getMatchForProject(isClient, preferredRuntimeIds[p], project.getName());
                    facetRuntimeMatches = true;
                    if (fRuntimeName != null) {
                        facetRuntimeMatches = FacetUtils.isFacetRuntimeSupported((RequiredFacetVersion[])prfv, (String)fRuntimeName);
                    }
                    if (fm2.isMatch() && facetRuntimeMatches) {
                        DefaultRuntimeTriplet drt2 = new DefaultRuntimeTriplet();
                        drt2.setFacetMatcher(fm2);
                        drt2.setProjectName(project.getName());
                        drt2.setRuntimeId(preferredRuntimeIds[p]);
                        return drt2;
                    }
                    ++p;
                }
                int i = 0;
                while (i < otherRuntimeIds.length) {
                    RequiredFacetVersion[] rfv = null;
                    rfv = isClient ? WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(otherRuntimeIds[i]).getRequiredFacetVersions() : WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(otherRuntimeIds[i]).getRequiredFacetVersions();
                    fm2 = FacetMatchCache.getInstance().getMatchForProject(isClient, otherRuntimeIds[i], project.getName());
                    facetRuntimeMatches = true;
                    if (fRuntimeName != null) {
                        facetRuntimeMatches = FacetUtils.isFacetRuntimeSupported((RequiredFacetVersion[])rfv, (String)fRuntimeName);
                    }
                    if (fm2.isMatch() && facetRuntimeMatches) {
                        DefaultRuntimeTriplet drt3 = new DefaultRuntimeTriplet();
                        drt3.setFacetMatcher(fm2);
                        drt3.setProjectName(project.getName());
                        drt3.setRuntimeId(otherRuntimeIds[i]);
                        return drt3;
                    }
                    ++i;
                }
                p = 0;
                while (p < preferredRuntimeIds.length) {
                    fm = FacetMatchCache.getInstance().getMatchForProject(isClient, preferredRuntimeIds[p], project.getName());
                    if (fm.isMatch()) {
                        drt = new DefaultRuntimeTriplet();
                        drt.setFacetMatcher(fm);
                        drt.setProjectName(project.getName());
                        drt.setRuntimeId(preferredRuntimeIds[p]);
                        return drt;
                    }
                    ++p;
                }
                i = 0;
                while (i < otherRuntimeIds.length) {
                    fm = FacetMatchCache.getInstance().getMatchForProject(isClient, otherRuntimeIds[i], project.getName());
                    if (fm.isMatch()) {
                        drt = new DefaultRuntimeTriplet();
                        drt.setFacetMatcher(fm);
                        drt.setProjectName(project.getName());
                        drt.setRuntimeId(otherRuntimeIds[i]);
                        return drt;
                    }
                    ++i;
                }
            }
        }
        ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
        String[] preferredTemplateIds = null;
        preferredTemplateIds = isClient ? ptc.getClientTypes() : ptc.getServiceTypes();
        int n = 0;
        while (n < preferredTemplateIds.length) {
            String preferredTemplateId = preferredTemplateIds[n];
            int m = 0;
            while (m < preferredRuntimeIds.length) {
                boolean matches = false;
                matches = isClient ? WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportTemplate(preferredRuntimeIds[m], preferredTemplateId) : WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportTemplate(preferredRuntimeIds[m], preferredTemplateId);
                if (matches) {
                    DefaultRuntimeTriplet drt = new DefaultRuntimeTriplet();
                    drt.setFacetMatcher(null);
                    if (project == null || project.exists()) {
                        drt.setProjectName(null);
                    } else {
                        drt.setProjectName(project.getName());
                    }
                    drt.setRuntimeId(preferredRuntimeIds[m]);
                    return drt;
                }
                ++m;
            }
            ++n;
        }
        if (preferredRuntimeIds.length > 0) {
            DefaultRuntimeTriplet drt = new DefaultRuntimeTriplet();
            drt.setFacetMatcher(null);
            if (project == null || project.exists()) {
                drt.setProjectName(null);
            } else {
                drt.setProjectName(project.getName());
            }
            drt.setRuntimeId(preferredRuntimeIds[0]);
            return drt;
        }
        if (runtimes.length > 0) {
            DefaultRuntimeTriplet drt = new DefaultRuntimeTriplet();
            drt.setFacetMatcher(null);
            if (project == null || project.exists()) {
                drt.setProjectName(null);
            } else {
                drt.setProjectName(project.getName());
            }
            drt.setRuntimeId(runtimes[0]);
            return drt;
        }
        DefaultRuntimeTriplet drt = new DefaultRuntimeTriplet();
        drt.setFacetMatcher(null);
        if (project == null || project.exists()) {
            drt.setProjectName(null);
        } else {
            drt.setProjectName(project.getName());
        }
        drt.setRuntimeId(null);
        return drt;
    }

    protected SelectionListChoices getProjectEARChoice(IProject project) {
        String[] flexProjects = this.getAllFlexibleProjects();
        SelectionList list = new SelectionList(flexProjects, 0);
        return new SelectionListChoices(list, null);
    }

    protected SelectionList getEARProjects() {
        String[] flexProjects = this.getAllFlexibleProjects();
        return new SelectionList(flexProjects, 0);
    }

    protected IResource getResourceFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            try {
                IResource resource = ResourceUtils.getResourceFromSelection((Object)obj);
                return resource;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected IStatus defaultClientSideFromServiceSide(String serviceProjectName, TypeRuntimeServer serviceIds, boolean serviceNeedEAR, String serviceEarProjectName) {
        boolean isEJB = false;
        String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(serviceIds.getTypeId());
        isEJB = implId.equals("org.eclipse.jst.ws.wsImpl.ejb");
        String[] updatedNames = ResourceUtils.getClientProjectComponentName((String)serviceProjectName, (String)serviceProjectName, (boolean)isEJB);
        this.clientProjectName_ = updatedNames[0];
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
        TypeRuntimeServer testIds = new TypeRuntimeServer();
        testIds.setTypeId(this.clientIds_.getTypeId());
        testIds.setRuntimeId(serviceIds.getRuntimeId());
        testIds.setServerId(serviceIds.getServerId());
        testIds.setServerInstanceId(serviceIds.getServerInstanceId());
        if (clientProject.exists()) {
            this.clientComponentType_ = "";
            this.clientRuntimeId_ = WebServiceRuntimeExtensionUtils2.getClientRuntimeId(testIds, serviceProjectName, this.clientComponentType_);
            if (this.clientRuntimeId_ != null && this.clientRuntimeId_.length() > 0) {
                this.clientIds_.setRuntimeId(serviceIds.getRuntimeId());
                this.clientIds_.setServerId(serviceIds.getServerId());
                this.clientIds_.setServerInstanceId(serviceIds.getServerInstanceId());
            }
        } else {
            String[] templateIds = WebServiceRuntimeExtensionUtils2.getClientProjectTemplates(this.clientIds_.getTypeId(), testIds.getRuntimeId());
            if (templateIds != null && templateIds.length > 0) {
                ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
                String[] preferredTemplateIds = ptc.getClientTypes();
                int j = 0;
                block0: while (j < preferredTemplateIds.length) {
                    int i = 0;
                    while (i < templateIds.length) {
                        String newClientRuntimeId;
                        String templateId = templateIds[i];
                        if (templateId.equals(preferredTemplateIds[j]) && (newClientRuntimeId = WebServiceRuntimeExtensionUtils2.getClientRuntimeId(testIds, this.clientProjectName_, templateId)).length() > 0) {
                            this.clientRuntimeId_ = newClientRuntimeId;
                            this.clientComponentType_ = templateId;
                            this.clientIds_.setRuntimeId(serviceIds.getRuntimeId());
                            this.clientIds_.setServerId(serviceIds.getServerId());
                            this.clientIds_.setServerInstanceId(serviceIds.getServerInstanceId());
                            break block0;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        if (this.clientRuntimeId_ != null && this.clientRuntimeId_.length() > 0) {
            this.setDefaultClientEarProject();
            if (serviceNeedEAR) {
                this.defaultClientEarFromServiceEar(serviceProjectName, serviceEarProjectName);
            }
            return Status.OK_STATUS;
        }
        return StatusUtils.errorStatus((String)"");
    }

    protected void defaultClientEarFromServiceEar(String serviceProjectName, String serviceEarProjectName) {
        IProject clientProject;
        if (!(!this.clientNeedEAR_ || (clientProject = ProjectUtilities.getProject((String)this.clientProjectName_)) != null && clientProject.exists() && this.clientEarProjectName_.equalsIgnoreCase(serviceEarProjectName))) {
            ProjectTopologyContext ptc = WebServiceConsumptionUIPlugin.getInstance().getProjectTopologyContext();
            if (!ptc.isUseTwoEARs()) {
                this.clientEarProjectName_ = serviceEarProjectName;
            } else {
                IProject proxyEARProject = this.getUniqueClientEAR(this.clientEarProjectName_, serviceEarProjectName, this.clientProjectName_, serviceProjectName);
                this.clientEarProjectName_ = proxyEARProject.getName();
            }
        }
    }

    private IProject getUniqueClientEAR(String earProjectName, String serviceEARProject, String clientProjectName, String serviceProjectName) {
        String projectName = new String();
        boolean goodJ2EELevel = true;
        if (!earProjectName.equalsIgnoreCase(serviceEARProject)) {
            IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
            IProject serviceProject = ProjectUtilities.getProject((String)serviceProjectName);
            IProject earProject = ProjectUtilities.getProject((String)earProjectName);
            if (!clientProject.exists() && serviceProject.exists()) {
                IStatus associationStatus = J2EEUtils.canAssociateProjectToEAR((IProject)serviceProject, (IProject)earProject);
                boolean bl = goodJ2EELevel = associationStatus.getSeverity() == 0;
            }
        }
        if (!earProjectName.equalsIgnoreCase(serviceEARProject) && goodJ2EELevel) {
            projectName = earProjectName;
        } else {
            projectName = String.valueOf(clientProjectName) + this.DEFAULT_CLIENT_EAR_PROJECT_EXT;
            int i = 1;
            while (projectName.equalsIgnoreCase(serviceEARProject)) {
                projectName = String.valueOf(projectName) + i;
                ++i;
            }
        }
        return projectName.equals("") ? null : ResourceUtils.getWorkspaceRoot().getProject(projectName);
    }

    private void setDefaultsForExtension(IEnvironment env) {
        IWebServiceRuntime wsrt = WebServiceRuntimeExtensionUtils2.getClientRuntime(this.clientRuntimeId_);
        if (wsrt != null) {
            WebServiceClientInfo wsInfo = new WebServiceClientInfo();
            wsInfo.setServerFactoryId(this.clientIds_.getServerId());
            wsInfo.setServerInstanceId(this.clientIds_.getServerInstanceId());
            wsInfo.setState(WebServiceState.UNKNOWN_LITERAL);
            wsInfo.setWebServiceRuntimeId(this.clientIds_.getRuntimeId());
            wsInfo.setWsdlURL(this.wsdlURI_);
            this.webServiceClient_ = wsrt.getWebServiceClient(wsInfo);
            WebServiceScenario scenario = WebServiceScenario.CLIENT_LITERAL;
            if (this.resourceContext_ != null) {
                this.context_ = new SimpleContext(true, true, true, true, true, true, this.test_, false, scenario, this.resourceContext_.isOverwriteFilesEnabled(), this.resourceContext_.isCreateFoldersEnabled(), this.resourceContext_.isCheckoutFilesEnabled());
            }
        }
    }

    public void setClientInitialSelection(IStructuredSelection selection) {
        if (this.clientInitialProject_ == null) {
            this.clientInitialProject_ = this.getProjectFromInitialSelection(selection);
        }
    }

    public void setClientProjectName(String name) {
        this.clientProjectName_ = name;
    }

    public void setClientInitialProject(IProject clientInitialProject) {
        this.clientInitialProject_ = clientInitialProject;
    }

    public void setInitialInitialSelection(IStructuredSelection initialInitialSelection) {
        this.initialProject_ = this.getProjectFromInitialSelection(initialInitialSelection);
    }

    public boolean getClientNeedEAR() {
        return this.clientNeedEAR_;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.parser_ = parser;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI_ = wsdlURI;
    }

    public void setTestService(boolean testService) {
        this.test_ = testService;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext_ = resourceContext;
    }

    private IProject getProjectFromInitialSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            IResource resource;
            block4: {
                try {
                    resource = ResourceUtils.getResourceFromSelection((Object)obj);
                    if (resource != null) break block4;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
            return p;
        }
        return null;
    }

    protected String[] getAllFlexibleProjects() {
        Vector<String> v = new Vector<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].getName().equals("Servers") && !projects[i].getName().startsWith(".")) {
                v.add(projects[i].getName());
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    protected class DefaultRuntimeTriplet {
        FacetMatcher facetMatcher_;
        String projectName_;
        String runtimeId_;

        public FacetMatcher getFacetMatcher() {
            return this.facetMatcher_;
        }

        public void setFacetMatcher(FacetMatcher facetMatcher_) {
            this.facetMatcher_ = facetMatcher_;
        }

        public String getProjectName() {
            return this.projectName_;
        }

        public void setProjectName(String projectName_) {
            this.projectName_ = projectName_;
        }

        public String getRuntimeId() {
            return this.runtimeId_;
        }

        public void setRuntimeId(String runtimeId_) {
            this.runtimeId_ = runtimeId_;
        }
    }

    protected class FacetRuntimeMatcher {
        FacetMatcher facetMatcher;
        boolean runtimeMatches;

        protected FacetRuntimeMatcher() {
        }

        public FacetMatcher getFacetMatcher() {
            return this.facetMatcher;
        }

        public void setFacetMatcher(FacetMatcher facetMatcher) {
            this.facetMatcher = facetMatcher;
        }

        public boolean isRuntimeMatches() {
            return this.runtimeMatches;
        }

        public void setRuntimeMatches(boolean runtimeMatches) {
            this.runtimeMatches = runtimeMatches;
        }
    }
}

