/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filesystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.listeners.ILogEntryListener;
import org.eclipse.team.internal.ccvs.core.util.Util;

class LogEntryCache
implements ILogEntryListener {
    private Map entries = new HashMap();

    LogEntryCache() {
    }

    Map internalGetLogEntries(String path) {
        return (Map)this.entries.get(path);
    }

    public ILogEntry[] getLogEntries(String path) {
        Map map = this.internalGetLogEntries(path);
        return map.values().toArray(new ILogEntry[map.values().size()]);
    }

    ILogEntry internalGetLogEntry(String path, String revision) {
        Map fileEntries = this.internalGetLogEntries(path);
        if (fileEntries != null) {
            return (ILogEntry)fileEntries.get(revision);
        }
        return null;
    }

    public String[] getCachedFilePaths() {
        return this.entries.keySet().toArray(new String[this.entries.size()]);
    }

    public synchronized ILogEntry getLogEntry(ICVSRemoteResource resource) {
        if (resource instanceof ICVSRemoteFile) {
            try {
                String path = this.getFullPath(resource);
                String revision = ((ICVSRemoteFile)resource).getRevision();
                return this.internalGetLogEntry(path, revision);
            }
            catch (TeamException teamException) {}
        }
        return null;
    }

    public synchronized ILogEntry[] getLogEntries(ICVSRemoteResource resource) {
        Map fileEntries = this.internalGetLogEntries(this.getFullPath(resource));
        if (fileEntries != null) {
            return fileEntries.values().toArray(new ILogEntry[fileEntries.size()]);
        }
        return new ILogEntry[0];
    }

    String getFullPath(ICVSRemoteResource resource) {
        return Util.appendPath(resource.getRepository().getLocation(false), resource.getRepositoryRelativePath());
    }

    public synchronized void clearEntries() {
        this.entries.clear();
    }

    public synchronized ICVSRemoteFile getImmediatePredecessor(ICVSRemoteFile file) throws TeamException {
        String revision;
        String predecessorRevision;
        ILogEntry[] allLogs = this.getLogEntries(file);
        ICVSRemoteFile predecessor = this.findRevison(allLogs, predecessorRevision = this.getPredecessorRevision(revision = file.getRevision()));
        if (predecessor == null && this.isBrancheRevision(revision)) {
            predecessorRevision = this.getBaseRevision(revision);
            predecessor = this.findRevison(allLogs, predecessorRevision);
        }
        return predecessor;
    }

    ICVSRemoteFile findRevison(ILogEntry[] allLogs, String predecessorRevision) throws TeamException {
        int i = 0;
        while (i < allLogs.length) {
            ILogEntry entry = allLogs[i];
            ICVSRemoteFile file = entry.getRemoteFile();
            if (file.getRevision().equals(predecessorRevision)) {
                return file;
            }
            ++i;
        }
        return null;
    }

    String getPredecessorRevision(String revision) {
        int[] digits = Util.convertToDigits(revision);
        int n = digits.length - 1;
        digits[n] = digits[n] - 1;
        StringBuffer buffer = new StringBuffer(revision.length());
        int i = 0;
        while (i < digits.length) {
            buffer.append(Integer.toString(digits[i]));
            if (i < digits.length - 1) {
                buffer.append('.');
            }
            ++i;
        }
        return buffer.toString();
    }

    boolean isBrancheRevision(String revision) {
        return Util.convertToDigits(revision).length > 2;
    }

    String getBaseRevision(String revision) {
        int[] digits = Util.convertToDigits(revision);
        int length = digits.length - 1;
        if (length % 2 == 1) {
            --length;
        }
        StringBuffer buffer = new StringBuffer(revision.length());
        int i = 0;
        while (i < length) {
            buffer.append(Integer.toString(digits[i]));
            if (i < length - 1) {
                buffer.append('.');
            }
            ++i;
        }
        return buffer.toString();
    }

    public synchronized void clearEntries(ICVSRemoteResource resource) {
        String remotePath = this.getFullPath(resource);
        this.entries.remove(remotePath);
    }

    public void handleLogEntryReceived(ILogEntry entry) {
        ICVSRemoteFile file = entry.getRemoteFile();
        String fullPath = this.getFullPath(file);
        String revision = entry.getRevision();
        HashMap<String, ILogEntry> fileEntries = this.internalGetLogEntries(fullPath);
        if (fileEntries == null) {
            fileEntries = new HashMap<String, ILogEntry>();
            this.entries.put(fullPath, fileEntries);
        }
        fileEntries.put(revision, entry);
    }
}

