/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.breakpoint;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.php.debug.ui.PHPDebugUIImages;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class PHPBreakpointImageDescriptor
extends CompositeImageDescriptor {
    public static final int ENABLED = 32;
    public static final int CONDITIONAL = 64;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public PHPBreakpointImageDescriptor(ImageDescriptor imageDescriptor, int n) {
        this.fBaseImage = imageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = n;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PHPBreakpointImageDescriptor)) {
            return false;
        }
        PHPBreakpointImageDescriptor pHPBreakpointImageDescriptor = (PHPBreakpointImageDescriptor)((Object)object);
        return this.getBaseImage().equals(pHPBreakpointImageDescriptor.getBaseImage()) && this.getFlags() == pHPBreakpointImageDescriptor.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.getBaseImage().getImageData();
        if (imageData == null) {
            imageData = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(imageData, 0, 0);
        this.drawOverlays();
    }

    private void drawOverlays() {
        int n = this.getFlags();
        int n2 = 0;
        int n3 = 0;
        ImageData imageData = null;
        if ((n & 0x40) != 0) {
            imageData = (n & 0x20) != 0 ? this.getImageData("IMG_OBJS_CONDITIONAL_BREAKPOINT") : this.getImageData("IMG_OBJS_CONDITIONAL_BREAKPOINT_DISABLED");
            n2 = 0;
            n3 = 0;
            this.drawImage(imageData, n2, n3);
        }
    }

    private ImageData getImageData(String string) {
        return PHPDebugUIImages.getImageDescriptor(string).getImageData();
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData imageData = this.getBaseImage().getImageData();
            this.setSize(new Point(imageData.width, imageData.height));
        }
        return this.fSize;
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor imageDescriptor) {
        this.fBaseImage = imageDescriptor;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int n) {
        this.fFlags = n;
    }

    protected void setSize(Point point) {
        this.fSize = point;
    }
}

