/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Messages;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Plugin;

class JSchSession {
    private static final int SSH_DEFAULT_PORT = 22;
    private static JSch jsch = new JSch();
    private static Hashtable pool = new Hashtable();
    private static String current_ssh_home = null;
    private static String current_pkeys = "";
    private final Session session;
    private final UserInfo prompter;
    private final ICVSRepositoryLocation location;

    protected static int getCVSTimeoutInMillis() {
        return 60000;
    }

    public static boolean isAuthenticationFailure(JSchException ee) {
        return ee.getMessage().equals("Auth fail");
    }

    static JSchSession getSession(ICVSRepositoryLocation location, String username, String password, String hostname, int port, IProgressMonitor monitor) throws JSchException {
        if (port == 0) {
            port = JSchSession.getPort(location);
        }
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        String ssh_home = store.getString("CVSSSH2PreferencePage.SSH2HOME");
        String pkeys = store.getString("CVSSSH2PreferencePage.PRIVATEKEY");
        try {
            if (current_ssh_home == null || !current_ssh_home.equals(ssh_home)) {
                JSchSession.loadKnownHosts();
                current_ssh_home = ssh_home;
            }
            if (ssh_home.length() == 0) {
                ssh_home = CVSSSH2Plugin.SSH_HOME_DEFAULT;
            }
            if (!current_pkeys.equals(pkeys)) {
                String[] pkey = pkeys.split(",");
                String[] _pkey = current_pkeys.split(",");
                current_pkeys = "";
                int i = 0;
                while (i < pkey.length) {
                    File file = new File(pkey[i]);
                    if (!file.isAbsolute()) {
                        file = new File(ssh_home, pkey[i]);
                    }
                    if (file.exists()) {
                        boolean notyet = true;
                        int j = 0;
                        while (j < _pkey.length) {
                            if (pkey[i].equals(_pkey[j])) {
                                notyet = false;
                                break;
                            }
                            ++j;
                        }
                        if (notyet) {
                            jsch.addIdentity(file.getPath());
                        }
                        current_pkeys = current_pkeys.length() == 0 ? pkey[i] : String.valueOf(current_pkeys) + "," + pkey[i];
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        String key = JSchSession.getPoolKey(username, hostname, port);
        try {
            JSchSession jschSession = (JSchSession)pool.get(key);
            if (jschSession != null && !jschSession.getSession().isConnected()) {
                pool.remove(key);
                jschSession = null;
            }
            if (jschSession == null) {
                boolean useProxy = CVSProviderPlugin.getPlugin().isUseProxy();
                ProxyHTTP proxy = null;
                if (useProxy) {
                    String _type = CVSProviderPlugin.getPlugin().getProxyType();
                    String _host = CVSProviderPlugin.getPlugin().getProxyHost();
                    String _port = CVSProviderPlugin.getPlugin().getProxyPort();
                    boolean useAuth = CVSProviderPlugin.getPlugin().isUseProxyAuth();
                    String _user = "";
                    String _pass = "";
                    if (useAuth) {
                        _user = CVSProviderPlugin.getPlugin().getProxyUser();
                        _pass = CVSProviderPlugin.getPlugin().getProxyPassword();
                    }
                    String proxyhost = String.valueOf(_host) + ":" + _port;
                    if (_type.equals("HTTP")) {
                        proxy = new ProxyHTTP(proxyhost);
                        if (useAuth) {
                            proxy.setUserPasswd(_user, _pass);
                        }
                    } else if (_type.equals("SOCKS5")) {
                        proxy = new ProxySOCKS5(proxyhost);
                        if (useAuth) {
                            ((ProxySOCKS5)proxy).setUserPasswd(_user, _pass);
                        }
                    } else {
                        proxy = null;
                    }
                }
                MyUserInfo ui = new MyUserInfo(username, password, location);
                UserInfoTimer wrapperUI = new UserInfoTimer(ui);
                ui.aboutToConnect();
                Session session = null;
                try {
                    session = JSchSession.createSession(username, password, hostname, port, new ResponsiveSocketFacory(monitor), proxy, wrapperUI);
                }
                catch (JSchException e) {
                    if (JSchSession.isAuthenticationFailure(e) && wrapperUI.hasPromptExceededTimeout()) {
                        session = JSchSession.createSession(username, password, hostname, port, new ResponsiveSocketFacory(monitor), proxy, wrapperUI);
                    }
                    throw e;
                }
                ui.connectionMade();
                JSchSession schSession = new JSchSession(session, location, wrapperUI);
                pool.put(key, schSession);
                return schSession;
            }
            return jschSession;
        }
        catch (JSchException e) {
            pool.remove(key);
            if (e.toString().indexOf("Auth cancel") != -1) {
                throw new OperationCanceledException();
            }
            throw e;
        }
    }

    private static Session createSession(String username, String password, String hostname, int port, SocketFactory socketFactory, Proxy proxy, UserInfo wrapperUI) throws JSchException {
        Session session = jsch.getSession(username, hostname, port);
        if (proxy != null) {
            session.setProxy(proxy);
        }
        session.setTimeout(JSchSession.getCVSTimeoutInMillis());
        session.setPassword(password);
        session.setUserInfo(wrapperUI);
        session.setSocketFactory(socketFactory);
        try {
            session.connect();
        }
        catch (JSchException e) {
            if (session.isConnected()) {
                session.disconnect();
            }
            throw e;
        }
        return session;
    }

    private static String getPoolKey(String username, String hostname, int port) {
        return String.valueOf(username) + "@" + hostname + ":" + port;
    }

    private static String getPoolKey(ICVSRepositoryLocation location) {
        return String.valueOf(location.getUsername()) + "@" + location.getHost() + ":" + JSchSession.getPort(location);
    }

    private static int getPort(ICVSRepositoryLocation location) {
        int port = location.getPort();
        if (port == 0) {
            port = 22;
        }
        return port;
    }

    static void loadKnownHosts() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        String ssh_home = store.getString("CVSSSH2PreferencePage.SSH2HOME");
        if (ssh_home.length() == 0) {
            ssh_home = CVSSSH2Plugin.SSH_HOME_DEFAULT;
        }
        try {
            File file = new File(ssh_home, "known_hosts");
            jsch.setKnownHosts(file.getPath());
        }
        catch (Exception exception) {}
    }

    static void shutdown() {
        if (jsch != null && pool.size() > 0) {
            Enumeration e = pool.elements();
            while (e.hasMoreElements()) {
                JSchSession session = (JSchSession)e.nextElement();
                try {
                    session.getSession().disconnect();
                }
                catch (Exception exception) {}
            }
            pool.clear();
        }
    }

    static JSch getJSch() {
        return jsch;
    }

    private JSchSession(Session session, ICVSRepositoryLocation location, UserInfo prompter) {
        this.session = session;
        this.location = location;
        this.prompter = prompter;
    }

    public Session getSession() {
        return this.session;
    }

    public UserInfo getPrompter() {
        return this.prompter;
    }

    public boolean hasPromptExceededTimeout() {
        UserInfoTimer timer;
        if (this.prompter instanceof UserInfoTimer && !(timer = (UserInfoTimer)this.prompter).isPrompting()) {
            return timer.getLastDuration() > (long)JSchSession.getCVSTimeoutInMillis();
        }
        return false;
    }

    public void dispose() {
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
        pool.remove(JSchSession.getPoolKey(this.location));
    }

    private static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String username;
        private String password;
        private String passphrase;
        private ICVSRepositoryLocation location;
        private IUserAuthenticator authenticator;
        private int attemptCount;
        private boolean passwordChanged;

        MyUserInfo(String username, String password, ICVSRepositoryLocation location) {
            this.location = location;
            this.username = username;
            this.password = password;
            ICVSRepositoryLocation _location = location;
            if (_location == null) {
                String dummy = ":extssh:dummy@dummy:/";
                try {
                    _location = CVSRepositoryLocation.fromString((String)dummy);
                }
                catch (CVSException cVSException) {}
            }
            this.authenticator = _location.getUserAuthenticator();
        }

        public String getPassword() {
            return this.password;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptYesNo(String str) {
            int prompt = this.authenticator.prompt(this.location, 3, CVSSSH2Messages.JSchSession_5, str, new int[]{2, 3}, 0);
            return prompt == 0;
        }

        private String promptSecret(String message, boolean includeLocation) throws CVSException {
            String[] _password = new String[1];
            IUserInfo info = new IUserInfo(this, _password){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String[] val$_password;
                {
                    this.this$1 = myUserInfo;
                    this.val$_password = stringArray;
                }

                public String getUsername() {
                    return MyUserInfo.access$0(this.this$1);
                }

                public boolean isUsernameMutable() {
                    return false;
                }

                public void setPassword(String password) {
                    this.val$_password[0] = password;
                }

                public void setUsername(String username) {
                }
            };
            try {
                this.authenticator.promptForUserInfo(includeLocation ? this.location : null, info, message);
            }
            catch (OperationCanceledException operationCanceledException) {
                _password[0] = null;
            }
            return _password[0];
        }

        public boolean promptPassphrase(String message) {
            try {
                String _passphrase = this.promptSecret(message, false);
                if (_passphrase != null) {
                    this.passphrase = _passphrase;
                }
                return _passphrase != null;
            }
            catch (CVSException cVSException) {
                return false;
            }
        }

        public boolean promptPassword(String message) {
            try {
                String _password = this.promptSecret(message, true);
                if (_password != null) {
                    this.password = _password;
                    if (this.location != null) {
                        ((CVSRepositoryLocation)this.location).setPassword(this.password);
                    }
                }
                return _password != null;
            }
            catch (CVSException cVSException) {
                return false;
            }
        }

        public void showMessage(String message) {
            this.authenticator.prompt(this.location, 2, CVSSSH2Messages.JSchSession_5, message, new int[1], 0);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] result;
            block7: {
                if (prompt.length == 0) {
                    return new String[0];
                }
                if (this.attemptCount == 0 && this.password != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    ++this.attemptCount;
                    return new String[]{this.password};
                }
                result = this.authenticator.promptForKeyboradInteractive(this.location, destination, name, instruction, prompt, echo);
                if (result != null) break block7;
                return null;
            }
            try {
                if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    this.password = result[0];
                    this.passwordChanged = true;
                }
                ++this.attemptCount;
                return result;
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            catch (CVSException cVSException) {
                return null;
            }
        }

        public void aboutToConnect() {
            this.attemptCount = 0;
            this.passwordChanged = false;
        }

        public void connectionMade() {
            this.attemptCount = 0;
            if (this.passwordChanged && this.password != null && this.location != null) {
                this.location.setPassword(this.password);
            }
        }

        static /* synthetic */ String access$0(MyUserInfo myUserInfo) {
            return myUserInfo.username;
        }
    }

    public static class ResponsiveSocketFacory
    extends SimpleSocketFactory {
        private IProgressMonitor monitor;

        public ResponsiveSocketFacory(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = null;
            socket = Util.createSocket((String)host, (int)port, (IProgressMonitor)this.monitor);
            this.monitor = new NullProgressMonitor();
            socket.setSoTimeout(JSchSession.getCVSTimeoutInMillis());
            return socket;
        }
    }

    public static class SimpleSocketFactory
    implements SocketFactory {
        InputStream in = null;
        OutputStream out = null;

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = null;
            socket = new Socket(host, port);
            return socket;
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            if (this.in == null) {
                this.in = socket.getInputStream();
            }
            return this.in;
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            if (this.out == null) {
                this.out = socket.getOutputStream();
            }
            return this.out;
        }
    }

    private static class UserInfoTimer
    implements UserInfo,
    UIKeyboardInteractive {
        private UserInfo wrappedInfo;
        private long startTime;
        private long endTime;
        private boolean prompting;

        public UserInfoTimer(UserInfo wrappedInfo) {
            this.wrappedInfo = wrappedInfo;
        }

        private synchronized void startTimer() {
            this.prompting = true;
            this.startTime = System.currentTimeMillis();
        }

        private synchronized void endTimer() {
            this.prompting = false;
            this.endTime = System.currentTimeMillis();
        }

        public long getLastDuration() {
            return Math.max(0L, this.endTime - this.startTime);
        }

        public boolean hasPromptExceededTimeout() {
            if (!this.isPrompting()) {
                return this.getLastDuration() > (long)JSchSession.getCVSTimeoutInMillis();
            }
            return false;
        }

        public String getPassphrase() {
            return this.wrappedInfo.getPassphrase();
        }

        public String getPassword() {
            return this.wrappedInfo.getPassword();
        }

        public boolean promptPassword(String arg0) {
            try {
                this.startTimer();
                boolean bl = this.wrappedInfo.promptPassword(arg0);
                Object var2_3 = null;
                this.endTimer();
                return bl;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.endTimer();
                throw throwable;
            }
        }

        public boolean promptPassphrase(String arg0) {
            try {
                this.startTimer();
                boolean bl = this.wrappedInfo.promptPassphrase(arg0);
                Object var2_3 = null;
                this.endTimer();
                return bl;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.endTimer();
                throw throwable;
            }
        }

        public boolean promptYesNo(String arg0) {
            try {
                this.startTimer();
                boolean bl = this.wrappedInfo.promptYesNo(arg0);
                Object var2_3 = null;
                this.endTimer();
                return bl;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.endTimer();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void showMessage(String arg0) {
            if (arg0.length() == 0) return;
            try {
                this.startTimer();
                this.wrappedInfo.showMessage(arg0);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.endTimer();
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.endTimer();
                return;
            }
        }

        public String[] promptKeyboardInteractive(String arg0, String arg1, String arg2, String[] arg3, boolean[] arg4) {
            try {
                this.startTimer();
                String[] stringArray = ((UIKeyboardInteractive)this.wrappedInfo).promptKeyboardInteractive(arg0, arg1, arg2, arg3, arg4);
                Object var6_7 = null;
                this.endTimer();
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.endTimer();
                throw throwable;
            }
        }

        public boolean isPrompting() {
            return this.prompting;
        }
    }
}

