/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.MultiStepConfigureWizardPage;
import org.eclipse.ui.internal.ide.dialogs.MultiStepReviewWizardPage;
import org.eclipse.ui.internal.ide.dialogs.MultiStepWizardDialog;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;

public abstract class MultiStepWizard
extends Wizard {
    private MultiStepWizardDialog wizardDialog;
    private MultiStepReviewWizardPage reviewPage;
    private MultiStepConfigureWizardPage configPage;

    protected MultiStepWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected abstract void addCustomPages();

    public final void addPages() {
        super.addPages();
        this.addCustomPages();
        this.reviewPage = new MultiStepReviewWizardPage("multiStepReviewWizardPage", this);
        this.reviewPage.setTitle(this.getReviewPageTitle());
        this.reviewPage.setDescription(this.getReviewPageDescription());
        this.addPage((IWizardPage)this.reviewPage);
        this.configPage = new MultiStepConfigureWizardPage("multiStepConfigureWizardPage");
        this.configPage.setTitle(this.getConfigurePageTitle());
        this.configPage.setDescription(this.getConfigurePageDescription());
        this.configPage.setWizardDialog(this.wizardDialog);
        this.addPage((IWizardPage)this.configPage);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.reviewPage) {
            return this.canFinishOnReviewPage();
        }
        if (this.isConfigureStepMode()) {
            return this.getStepContainer().canWizardFinish();
        }
        return false;
    }

    protected abstract boolean canFinishOnReviewPage();

    public void dispose() {
        super.dispose();
        this.wizardDialog = null;
    }

    protected abstract String getConfigurePageTitle();

    protected abstract String getConfigurePageDescription();

    protected abstract String getReviewPageTitle();

    protected String getFinishStepLabel(WizardStep[] steps) {
        return IDEWorkbenchMessages.MultiStepWizard_finishLabel;
    }

    public final IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.configPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    protected abstract String getReviewPageDescription();

    MultiStepConfigureWizardPage.WizardStepContainer getStepContainer() {
        return this.configPage.getStepContainer();
    }

    abstract boolean handleMissingStepWizard(WizardStep var1);

    boolean isConfigureStepMode() {
        return this.getContainer().getCurrentPage() == this.configPage;
    }

    public final boolean performCancel() {
        if (this.isConfigureStepMode()) {
            return this.getStepContainer().performCancel();
        }
        return true;
    }

    public boolean performFinish() {
        if (this.getContainer().getCurrentPage() == this.reviewPage) {
            this.getContainer().showPage((IWizardPage)this.configPage);
            return false;
        }
        return true;
    }

    public final WizardStep[] getSteps() {
        if (this.reviewPage != null) {
            return this.reviewPage.getSteps();
        }
        return new WizardStep[0];
    }

    public final void setSteps(WizardStep[] steps) {
        if (this.reviewPage != null) {
            this.reviewPage.setSteps(steps);
        }
        if (this.configPage != null) {
            this.configPage.setSteps(steps);
        }
    }

    void setWizardDialog(MultiStepWizardDialog dialog) {
        this.wizardDialog = dialog;
        if (this.configPage != null) {
            this.configPage.setWizardDialog(this.wizardDialog);
        }
    }
}

