/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.connect;

import com.ibm.icu.text.MessageFormat;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdi.internal.connect.ConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketListeningConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketTransportImpl;

public class SocketLaunchingConnectorImpl
extends ConnectorImpl
implements LaunchingConnector {
    private static final int ACCEPT_TIMEOUT = 10000;
    private String fHome;
    private String fOptions;
    private String fMain;
    private boolean fSuspend;
    private String fLauncher;

    public SocketLaunchingConnectorImpl(VirtualMachineManagerImpl virtualMachineManager) {
        super(virtualMachineManager);
        SocketTransportImpl transport = new SocketTransportImpl();
        this.setTransport(transport);
    }

    public Map defaultArguments() {
        HashMap<String, ConnectorImpl.ArgumentImpl> arguments = new HashMap<String, ConnectorImpl.ArgumentImpl>(6);
        ConnectorImpl.StringArgumentImpl strArg = new ConnectorImpl.StringArgumentImpl("home", ConnectMessages.SocketLaunchingConnectorImpl_Home_directory_of_the_SDK_or_runtime_environment_used_to_launch_the_application_1, ConnectMessages.SocketLaunchingConnectorImpl_Home_2, false);
        strArg.setValue(System.getProperty("java.home"));
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("options", ConnectMessages.SocketLaunchingConnectorImpl_Launched_VM_options_3, ConnectMessages.SocketLaunchingConnectorImpl_Options_4, false);
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("main", ConnectMessages.SocketLaunchingConnectorImpl_Main_class_and_arguments__or_if__jar_is_an_option__the_main_jar_file_and_arguments_5, ConnectMessages.SocketLaunchingConnectorImpl_Main_6, true);
        arguments.put(strArg.name(), strArg);
        ConnectorImpl.BooleanArgumentImpl boolArg = new ConnectorImpl.BooleanArgumentImpl("suspend", ConnectMessages.SocketLaunchingConnectorImpl_All_threads_will_be_suspended_before_execution_of_main_7, ConnectMessages.SocketLaunchingConnectorImpl_Suspend_8, false);
        boolArg.setValue(true);
        arguments.put(boolArg.name(), boolArg);
        strArg = new ConnectorImpl.StringArgumentImpl("quote", ConnectMessages.SocketLaunchingConnectorImpl_Character_used_to_combine_space_delimited_text_into_a_single_command_line_argument_9, ConnectMessages.SocketLaunchingConnectorImpl_Quote_10, true);
        strArg.setValue("\"");
        arguments.put(strArg.name(), strArg);
        strArg = new ConnectorImpl.StringArgumentImpl("vmexec", ConnectMessages.SocketLaunchingConnectorImpl_Name_of_the_Java_VM_launcher_11, ConnectMessages.SocketLaunchingConnectorImpl_Launcher_12, true);
        strArg.setValue("java");
        arguments.put(strArg.name(), strArg);
        return arguments;
    }

    public String name() {
        return "com.sun.jdi.CommandLineLaunch";
    }

    public String description() {
        return ConnectMessages.SocketLaunchingConnectorImpl_Launches_target_using_Sun_Java_VM_command_line_and_attaches_to_it_13;
    }

    private void getConnectionArguments(Map connectionArgs) throws IllegalConnectorArgumentsException {
        String attribute = "";
        try {
            attribute = "home";
            this.fHome = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "options";
            this.fOptions = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "main";
            this.fMain = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "suspend";
            this.fSuspend = ((Connector.BooleanArgument)connectionArgs.get(attribute)).booleanValue();
            attribute = "quote";
            ((Connector.StringArgument)connectionArgs.get(attribute)).value();
            attribute = "vmexec";
            this.fLauncher = ((Connector.StringArgument)connectionArgs.get(attribute)).value();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.SocketLaunchingConnectorImpl_Connection_argument_is_not_of_the_right_type_14, attribute);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.SocketLaunchingConnectorImpl_Necessary_connection_argument_is_null_15, attribute);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalConnectorArgumentsException(ConnectMessages.SocketLaunchingConnectorImpl_Connection_argument_is_not_a_number_16, attribute);
        }
    }

    public VirtualMachine launch(Map connectionArgs) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        VirtualMachineImpl virtualMachine;
        this.getConnectionArguments(connectionArgs);
        SocketListeningConnectorImpl listenConnector = new SocketListeningConnectorImpl(this.virtualMachineManager());
        Map args = listenConnector.defaultArguments();
        int port = SocketLaunchingConnectorImpl.findFreePort();
        ((Connector.IntegerArgument)args.get("port")).setValue(port);
        ((Connector.IntegerArgument)args.get("timeout")).setValue(10000);
        listenConnector.startListening(args);
        String slash = System.getProperty("file.separator");
        String execString = String.valueOf(this.fHome) + slash + "bin" + slash + this.fLauncher;
        execString = String.valueOf(execString) + " -Xdebug -Xnoagent -Djava.compiler=NONE";
        execString = String.valueOf(execString) + " -Xrunjdwp:transport=dt_socket,address=localhost:" + listenConnector.listeningPort() + ",server=n,suspend=" + (this.fSuspend ? "y" : "n");
        if (this.fOptions != null) {
            execString = String.valueOf(execString) + " " + this.fOptions;
        }
        execString = String.valueOf(execString) + " " + this.fMain;
        Process proc = Runtime.getRuntime().exec(execString);
        try {
            virtualMachine = (VirtualMachineImpl)listenConnector.accept(args);
        }
        catch (InterruptedIOException interruptedIOException) {
            proc.destroy();
            String message = MessageFormat.format((String)ConnectMessages.SocketLaunchingConnectorImpl_VM_did_not_connect_within_given_time___0__ms_1, (Object[])new String[]{((Connector.IntegerArgument)args.get("timeout")).value()});
            throw new VMStartException(message, proc);
        }
        virtualMachine.setLaunchedProcess(proc);
        return virtualMachine;
    }

    /*
     * Exception decompiling
     */
    public static int findFreePort() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 46->49)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

