/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ManifestException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ContainerImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ClasspathUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class ArchiveImpl
extends ContainerImpl
implements Archive {
    protected EList types = null;
    protected ArchiveManifest manifest;
    protected SaveStrategy saveStrategy;
    protected SaveFilter saveFilter;
    protected String xmlEncoding = "UTF-8";
    protected ClassLoader archiveClassLoader;
    protected String extraClasspath;
    protected ArchiveOptions options;
    static /* synthetic */ Class class$0;

    public ArchiveImpl() {
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.ARCHIVE;
    }

    public EList getTypes() {
        if (this.types == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.types = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 8);
        }
        return this.types;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getTypes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (types: ");
        result.append(this.types);
        result.append(')');
        return result.toString();
    }

    public Archive addCopy(Archive anArchive) throws DuplicateObjectException {
        this.checkAddValid(anArchive);
        Archive copy = this.getCommonArchiveFactory().copy(anArchive);
        this.getFiles().add((Object)copy);
        return copy;
    }

    public File addCopy(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            this.addCopy((ReadOnlyDirectory)aFile);
            return null;
        }
        this.checkAddValid(aFile);
        File copy = this.copy(aFile);
        this.getFiles().add((Object)copy);
        return copy;
    }

    public List addCopy(ReadOnlyDirectory dir) throws DuplicateObjectException {
        return this.addCopyFiles(dir.getFilesRecursive());
    }

    public List addCopyFiles(List list) throws DuplicateObjectException {
        this.getFiles();
        ArrayList<File> copyList = new ArrayList<File>();
        int i = 0;
        while (i < list.size()) {
            File aFile = (File)list.get(i);
            this.checkAddValid(aFile);
            copyList.add(this.copy(aFile));
            ++i;
        }
        this.getFiles().addAll(copyList);
        return copyList;
    }

    public void addOrReplaceMofResource(Resource aResource) {
        this.getLoadStrategy().addOrReplaceMofResource(aResource);
    }

    public boolean canClose() {
        return !this.getCommonArchiveFactory().getOpenArchivesDependingOn(this).isEmpty();
    }

    protected void checkAddValid(File aFile) throws DuplicateObjectException {
        this.checkAddValid(aFile.getURI());
    }

    protected void checkAddValid(String aUri) throws DuplicateObjectException {
        try {
            File f = this.getFile(aUri);
            if (f != null) {
                throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_file_EXC_, new Object[]{this.getURI(), aUri}), f);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    protected void cleanupAfterTempSave(String aUri, java.io.File original, java.io.File destinationFile) throws SaveFailureException {
        this.checkWriteable(original);
        boolean deleteWorked = false;
        if (original.isDirectory() && !this.isRenameable(original)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{original.getAbsolutePath()}));
        }
        int i = 0;
        while (i < 10) {
            if (ArchiveUtil.delete(original)) {
                deleteWorked = true;
                break;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (deleteWorked) {
            i = 0;
            while (i < 10) {
                if (destinationFile.renameTo(original)) {
                    return;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.unable_replace_EXC_, new Object[]{original.getAbsolutePath()}));
    }

    public void close() {
        this.getLoadStrategy().close();
        this.releaseClassLoader();
        this.getCommonArchiveFactory().archiveClosed(this);
        if (this.isIndexed()) {
            List archives = this.getArchiveFiles();
            int i = 0;
            while (i < archives.size()) {
                ((Archive)archives.get(i)).close();
                ++i;
            }
        }
    }

    protected File copy(File aFile) {
        File copy = null;
        copy = aFile.isArchive() ? this.getCommonArchiveFactory().copy((Archive)aFile) : (File)EtoolsCopyUtility.createCopy((EObject)aFile);
        return copy;
    }

    protected LoadStrategy createLoadStrategyForReopen(Archive parent) throws IOException {
        LoadStrategy aLoadStrategy = null;
        LooseArchive loose = this.getLoadStrategy().getLooseArchive();
        if (loose != null) {
            aLoadStrategy = this.getCommonArchiveFactory().createLoadStrategy(loose.getBinariesPath());
            aLoadStrategy.setLooseArchive(loose);
        } else {
            aLoadStrategy = parent == null ? this.getCommonArchiveFactory().createLoadStrategy(this.getURI()) : this.getCommonArchiveFactory().createChildLoadStrategy(this.getURI(), parent.getLoadStrategy());
        }
        return aLoadStrategy;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String absolutePath) {
        RuntimeClasspathEntryImpl entry = new RuntimeClasspathEntryImpl();
        entry.setAbsolutePath(absolutePath);
        return entry;
    }

    protected List createRuntimeClasspathEntries(String[] entries, String parentPath) {
        ArrayList<RuntimeClasspathEntry> aList = new ArrayList<RuntimeClasspathEntry>(entries.length);
        int i = 0;
        while (i < entries.length) {
            block6: {
                String entry = entries[i];
                Archive dependentJar = this.resolveClasspathEntryInEAR(entry);
                if (dependentJar != null) {
                    try {
                        RuntimeClasspathEntry runEntry = this.createRuntimeClasspathEntry(dependentJar.getBinariesPath(), entry);
                        runEntry.setReferencedArchive(dependentJar);
                        aList.add(runEntry);
                        break block6;
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                java.io.File aFile = new java.io.File(entry);
                String absPath = null;
                if (aFile.isAbsolute()) {
                    absPath = aFile.getAbsolutePath();
                } else {
                    absPath = ArchiveUtil.getOSUri(parentPath, entry);
                    absPath = ClasspathUtil.normalizePath(absPath);
                }
                aList.add(this.createRuntimeClasspathEntry(absPath, entry));
            }
            ++i;
        }
        return aList;
    }

    protected RuntimeClasspathEntry createRuntimeClasspathEntry(String absolutePath, String manifestValue) {
        RuntimeClasspathEntry entry = this.createRuntimeClasspathEntry(absolutePath);
        entry.setManifestValue(manifestValue);
        return entry;
    }

    protected SaveStrategy createSaveStrategyForDirectory(java.io.File dir, int expansionFlags) {
        return new DirectorySaveStrategyImpl(dir.getAbsolutePath(), expansionFlags);
    }

    protected SaveStrategy createSaveStrategyForDirectory(String aUri, int expansionFlags) {
        return new DirectorySaveStrategyImpl(aUri, expansionFlags);
    }

    protected SaveStrategy createSaveStrategyForJar(java.io.File aFile) throws IOException {
        if (aFile.exists() && aFile.isDirectory()) {
            throw new IOException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_exist_as_dir_EXC_, new Object[]{aFile.getAbsolutePath()}));
        }
        java.io.File parent = aFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(aFile);
        return new ZipStreamSaveStrategyImpl(out);
    }

    public void extract(int expansionFlags) throws SaveFailureException, ReopenException {
        this.extractNoReopen(expansionFlags);
        this.reopen();
    }

    public void extractNoReopen(int expansionFlags) throws SaveFailureException {
        String aUri = this.getURI();
        java.io.File aDir = new java.io.File(aUri);
        boolean inUse = this.getLoadStrategy().isUsing(aDir);
        try {
            java.io.File destinationDir = inUse ? ArchiveUtil.createTempDirectory(aUri, aDir.getCanonicalFile().getParentFile()) : aDir;
            SaveStrategy aSaveStrategy = this.createSaveStrategyForDirectory(destinationDir, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
            this.close();
            if (inUse) {
                this.cleanupAfterTempSave(aUri, aDir, destinationDir);
            }
        }
        catch (IOException ex) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{this.uri}), ex);
        }
    }

    public void extractTo(String aUri, int expansionFlags) throws SaveFailureException {
        java.io.File aDir = new java.io.File(aUri);
        if (this.getLoadStrategy().isUsing(aDir)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Extract_destination_is_the_EXC_);
        }
        try {
            SaveStrategy aSaveStrategy = this.createSaveStrategyForDirectory(aDir, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
        }
        catch (IOException ex) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{aUri}), ex);
        }
    }

    public List filterFilesByPrefix(String prefix) {
        return this.filterFiles(prefix, null);
    }

    public List filterFiles(String prefix, String[] suffixes) {
        ArrayList<File> subset = new ArrayList<File>();
        EList theFiles = this.getFiles();
        int i = 0;
        while (i < theFiles.size()) {
            File aFile = (File)theFiles.get(i);
            if (!aFile.isDirectoryEntry() && aFile.getURI().startsWith(prefix) && (suffixes == null || this.hasSuffix(aFile.getURI(), suffixes))) {
                subset.add(aFile);
            }
            ++i;
        }
        return subset;
    }

    private boolean hasSuffix(String aUri, String[] suffixes) {
        int i = 0;
        while (i < suffixes.length) {
            if (aUri.endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List filterFilesWithoutPrefix(String[] prefixes) {
        ArrayList<File> subset = new ArrayList<File>();
        EList theFiles = this.getFiles();
        int i = 0;
        while (i < theFiles.size()) {
            File aFile = (File)theFiles.get(i);
            if (!aFile.isDirectoryEntry()) {
                boolean shouldAdd = true;
                int j = 0;
                while (j < prefixes.length) {
                    if (aFile.getURI().startsWith(prefixes[j])) {
                        shouldAdd = false;
                        break;
                    }
                    ++j;
                }
                if (shouldAdd) {
                    subset.add(aFile);
                }
            }
            ++i;
        }
        return subset;
    }

    public ClassLoader getArchiveClassLoader() {
        if (this.archiveClassLoader == null) {
            this.initializeClassLoader();
        }
        return this.archiveClassLoader;
    }

    public List getArchiveFiles() {
        ArrayList<File> archives = new ArrayList<File>();
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File aFile = (File)fileList.get(i);
            if (aFile.isArchive()) {
                archives.add(aFile);
            }
            ++i;
        }
        return archives;
    }

    protected ClassLoader getClassPathClassLoader(ClassLoader parentCl) {
        String extraCp;
        ArrayList<String> classPathComponents = new ArrayList<String>();
        if (this.getManifest() != null) {
            classPathComponents.addAll(Arrays.asList(this.getManifest().getClassPathTokenized()));
        }
        if ((extraCp = this.getExtraClasspath()) != null) {
            classPathComponents.addAll(Arrays.asList(ArchiveUtil.getTokens(extraCp, ";")));
        }
        URL[] urlArray = ArchiveUtil.toLocalURLs(classPathComponents, this.getRootForRelativeDependentJars());
        return new URLClassLoader(urlArray, parentCl);
    }

    public ResourceSet getResourceSet() {
        return this.getLoadStrategy().getResourceSet();
    }

    protected ClassLoader getDefaultClassLoader() {
        ClassLoader pluginClassLoader = this.getClass().getClassLoader();
        return pluginClassLoader == null ? ClassLoader.getSystemClassLoader() : pluginClassLoader;
    }

    public Set getDependentOpenArchives() {
        return this.getCommonArchiveFactory().getOpenArchivesDependingOn(this);
    }

    protected List getEntriesAsAbsolutePaths(String[] entries, String parentPath) {
        ArrayList<String> aList = new ArrayList<String>(entries.length);
        int i = 0;
        while (i < entries.length) {
            block6: {
                java.io.File aFile;
                String entry = entries[i];
                Archive dependentJar = this.resolveClasspathEntryInEAR(entry);
                if (dependentJar != null) {
                    try {
                        aList.add(dependentJar.getAbsolutePath());
                        break block6;
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                if ((aFile = new java.io.File(entry)).isAbsolute()) {
                    aList.add(aFile.getAbsolutePath());
                } else {
                    aList.add(ArchiveUtil.getOSUri(parentPath, entry));
                }
            }
            ++i;
        }
        return aList;
    }

    public String getExtraClasspath() {
        return this.extraClasspath;
    }

    public FileIterator getFilesForSave() throws IOException {
        return this.getLoadStrategy().getFileIterator();
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        if (this.getLoadingContainer() != null || this.getLoadStrategy() == null || this.getLoadStrategy().isDirectory()) {
            return super.getInputStream();
        }
        if (this.isModuleFile() || !this.getOptions().isSaveLibrariesAsFiles()) {
            throw new IOException("Undefined state of nested archive");
        }
        EList list = this.getFiles();
        String absolutePath = null;
        int i = 0;
        while (i < list.size()) {
            File aFile = (File)list.get(i);
            if (!aFile.isArchive()) {
                absolutePath = aFile.getLoadingContainer().getAbsolutePath();
            }
            ++i;
        }
        return new FileInputStream(absolutePath);
    }

    public InputStream getResourceInputStream(String aUri) throws IOException {
        return this.getLoadStrategy().getResourceInputStream(aUri);
    }

    protected JavaJDKAdapterFactory getJavaAdapterFactory() {
        return (JavaJDKAdapterFactory)EcoreUtil.getAdapterFactory((List)this.getLoadStrategy().getResourceSet().getAdapterFactories(), (Object)"JavaReflection");
    }

    public Collection getLoadedMofResources() {
        return this.getLoadStrategy().getLoadedMofResources();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArchiveManifest getManifest() {
        block12: {
            if (this.manifest != null) break block12;
            InputStream in = null;
            try {
                try {
                    in = this.getInputStream("META-INF/MANIFEST.MF");
                    this.makeManifest(in);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.makeManifest();
                }
                catch (Resource.IOWrappedException ex) {
                    WrappedException wrapEx = new WrappedException(ex.getWrappedException());
                    if (!ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrapEx)) {
                        throw new ManifestException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_manifest_EXC_, new Object[]{this.getURI()}), (Exception)((Object)ex));
                    }
                    this.makeManifest();
                }
                catch (IOException ex) {
                    throw new ManifestException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_manifest_EXC_, new Object[]{this.getURI()}), ex);
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var4_7 = null;
                if (in == null) break block12;
            }
            try {}
            catch (IOException iOException) {}
            in.close();
        }
        if (this.manifest.getManifestVersion() != null) {
            if (!this.manifest.getManifestVersion().equals("")) return this.manifest;
        }
        this.manifest.setManifestVersion("1.0");
        return this.manifest;
    }

    public Resource getMofResource(String aUri) throws FileNotFoundException, ResourceLoadException {
        return this.getLoadStrategy().getMofResource(aUri);
    }

    protected Resource getMofResourceMakeIfNecessary(String aUri) {
        if (this.getLoadStrategy() == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = this.getMofResource(aUri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                resource = this.makeMofResource(aUri);
            }
            catch (DuplicateObjectException duplicateObjectException) {}
        }
        return resource;
    }

    public ArchiveOptions getOptions() {
        if (this.options == null) {
            this.options = new ArchiveOptions();
        }
        return this.options;
    }

    public String getRootForRelativeDependentJars() {
        String path = null;
        Container theContainer = this;
        while (theContainer != null && path == null) {
            try {
                path = theContainer.getAbsolutePath();
            }
            catch (FileNotFoundException fileNotFoundException) {}
            theContainer = theContainer.getLoadingContainer();
        }
        if (path == null) {
            path = System.getProperty("user.dir");
            if (path == null) {
                return "";
            }
            return new java.io.File(path).getAbsolutePath();
        }
        return new java.io.File(path).getParentFile().getAbsolutePath();
    }

    public String[] getRuntimeClassPath() {
        String absolutePath;
        try {
            absolutePath = this.getBinariesPath();
        }
        catch (IOException iOException) {
            return new String[0];
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(absolutePath);
        String parentPath = new java.io.File(absolutePath).getParentFile().getAbsolutePath();
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        entries.addAll(this.getEntriesAsAbsolutePaths(mfEntries, parentPath));
        return entries.toArray(new String[entries.size()]);
    }

    public SaveFilter getSaveFilter() {
        return this.saveFilter;
    }

    public SaveStrategy getSaveStrategy() {
        return this.saveStrategy;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public void initializeAfterOpen() {
    }

    public void initializeClassLoader() {
        if (!this.shouldUseJavaReflection()) {
            return;
        }
        ClassLoader extraCl = null;
        ClassLoader defaultCl = this.getDefaultClassLoader();
        if (this.getContainer() == null || !this.getContainer().isEARFile()) {
            extraCl = this.getClassPathClassLoader(defaultCl);
        }
        ClassLoader cl = this.createDynamicClassLoader(defaultCl, extraCl);
        this.setArchiveClassLoader(cl);
        JavaJDKAdapterFactory factory = this.getJavaAdapterFactory();
        factory.setContextClassLoader(cl);
        factory.flushAll();
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new ArchiveFileDynamicClassLoader(this, parentCl, extraCl);
    }

    public boolean isArchive() {
        return true;
    }

    public boolean isDuplicate(String aUri) {
        return this.containsFile(aUri) || this.isMofResourceLoaded(aUri) || "META-INF/MANIFEST.MF".equals(aUri);
    }

    public boolean isManifestSet() {
        return this.manifest != null;
    }

    public boolean isMofResourceLoaded(String aUri) {
        return this.getLoadStrategy().isMofResourceLoaded(aUri);
    }

    public boolean isNestedArchive(String aUri) {
        if (this.getLoadStrategy().isDirectory()) {
            try {
                String path = ArchiveUtil.getOSUri(this.getAbsolutePath(), aUri);
                java.io.File ioFile = new java.io.File(path);
                if (!ioFile.exists() || ioFile.isDirectory() && aUri.startsWith("ALT-INF")) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return ArchiveTypeDiscriminatorRegistry.INSTANCE.isKnownArchiveType(aUri);
    }

    public boolean isOpen() {
        return this.getLoadStrategy() != null && this.getLoadStrategy().isOpen();
    }

    public ArchiveManifest makeManifest() {
        ArchiveManifestImpl mf = new ArchiveManifestImpl();
        this.setManifest(mf);
        return mf;
    }

    public ArchiveManifest makeManifest(InputStream in) throws IOException {
        ArchiveManifestImpl mf = new ArchiveManifestImpl(in);
        this.setManifest(mf);
        return mf;
    }

    public Resource makeMofResource(String aUri) throws DuplicateObjectException {
        return this.makeMofResource(aUri, null);
    }

    public Resource makeMofResource(String aUri, EList extent) throws DuplicateObjectException {
        if (this.isDuplicate(aUri)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.duplicate_entry_EXC_, new Object[]{aUri, this.getURI()}));
        }
        return this.getLoadStrategy().makeMofResource(aUri, extent);
    }

    public Archive openNestedArchive(String aUri) throws OpenFailureException {
        return this.getCommonArchiveFactory().openNestedArchive(aUri, (Archive)this);
    }

    public Archive openNestedArchive(LooseArchive loose) throws OpenFailureException {
        return this.getCommonArchiveFactory().openNestedArchive(loose, (Archive)this);
    }

    public void primSetExtraClasspath(String newExtraClasspath) {
        this.extraClasspath = newExtraClasspath;
    }

    public void releaseClassLoader() {
        if (this.archiveClassLoader != null) {
            this.setArchiveClassLoader(null);
            this.getJavaAdapterFactory().setContextClassLoader(null);
        }
    }

    public void remove(File aFile) {
        this.getFiles().remove((Object)aFile);
    }

    public void reopen() throws ReopenException {
        this.reopen(null);
    }

    public void reopen(Archive parent) throws ReopenException {
        LoadStrategy aLoadStrategy = null;
        try {
            aLoadStrategy = this.createLoadStrategyForReopen(parent);
        }
        catch (IOException ex) {
            throw new ReopenException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.io_ex_reopen_EXC_, new Object[]{this.getURI()}), ex);
        }
        LoadStrategy current = this.getLoadStrategy();
        if (current != null) {
            aLoadStrategy.setResourceSet(current.primGetResourceSet());
            current.setResourceSet(null);
        }
        this.setLoadStrategy(aLoadStrategy);
        this.initializeClassLoader();
        if (!this.isIndexed()) {
            return;
        }
        EList fileList = this.getFiles();
        int i = 0;
        while (i < fileList.size()) {
            File f = (File)fileList.get(i);
            f.setOriginalURI(f.getURI());
            f.setLoadingContainer(this);
            if (f.isArchive()) {
                ((Archive)f).reopen(this);
            }
            ++i;
        }
        this.getCommonArchiveFactory().archiveOpened(this);
    }

    protected void replaceRoot(Resource aResource, EObject root) {
        if (aResource == null) {
            return;
        }
        EList extent = aResource.getContents();
        EObject existingRoot = null;
        if (!extent.isEmpty()) {
            existingRoot = (EObject)extent.get(0);
            if (existingRoot == root) {
                return;
            }
            extent.remove(0);
        }
        if (root != null) {
            extent.add(0, (Object)root);
        }
    }

    protected Archive resolveClasspathEntryInEAR(String entry) {
        Container parent = this.getContainer();
        if (parent == null || !parent.isEARFile()) {
            return null;
        }
        String aUri = ArchiveUtil.deriveEARRelativeURI(entry, this);
        if (aUri == null) {
            return null;
        }
        File aFile = null;
        try {
            aFile = parent.getFile(aUri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return aFile.isArchive() ? (Archive)aFile : null;
    }

    public void save() throws SaveFailureException, ReopenException {
        this.saveAs(this.getURI());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(SaveStrategy aStrategy) throws SaveFailureException {
        SaveFilter existingFilter;
        block7: {
            this.setSaveStrategy(aStrategy);
            existingFilter = aStrategy.getFilter();
            boolean oldDelivery = this.eDeliver();
            try {
                if (this.getOptions().isReadOnly()) {
                    this.eSetDeliver(false);
                }
                aStrategy.setFilter(this.getSaveFilter());
                aStrategy.save();
                try {
                    aStrategy.finish();
                }
                catch (IOException iox) {
                    throw new SaveFailureException(this.getURI(), iox);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.getOptions().isReadOnly() && !this.getLoadStrategy().isDirectory()) {
                    this.files.clear();
                    this.eSetDeliver(oldDelivery);
                    this.eAdapters().remove((Object)this.getFileIndexAdapter());
                    this.fileIndexAdapter = null;
                    this.fileIndex = null;
                }
                this.setSaveStrategy(null);
                aStrategy.setFilter(existingFilter);
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (!this.getOptions().isReadOnly() || this.getLoadStrategy().isDirectory()) break block7;
            }
            this.files.clear();
            this.eSetDeliver(oldDelivery);
            this.eAdapters().remove((Object)this.getFileIndexAdapter());
            this.fileIndexAdapter = null;
            this.fileIndex = null;
        }
        this.setSaveStrategy(null);
        aStrategy.setFilter(existingFilter);
    }

    public void saveAs(String aUri) throws SaveFailureException, ReopenException {
        this.saveAsNoReopen(aUri);
        this.reopen();
    }

    protected boolean isRenameable(java.io.File orig) {
        java.io.File origCopy1 = null;
        java.io.File origCopy2 = null;
        try {
            origCopy1 = orig.getCanonicalFile();
            origCopy2 = orig.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        String name = null;
        String baseName = "save.tmp";
        try {
            if (orig.getParent() != null) {
                baseName = new java.io.File(orig.getParent(), baseName).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        java.io.File temp = null;
        int index = 0;
        do {
            name = String.valueOf(baseName) + index;
            temp = new java.io.File(name);
            ++index;
        } while (temp.exists());
        return origCopy1.renameTo(temp) && temp.renameTo(origCopy2);
    }

    protected void checkWriteable(java.io.File dest) throws SaveFailureException {
        List locked = ArchiveUtil.getWriteProtectedFiles(dest, null);
        if (locked.isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Cannot write to file: ");
        msg.append(dest.getAbsolutePath());
        msg.append('\n');
        msg.append("One or more files is write protected or locked:");
        msg.append('\n');
        int i = 0;
        while (i < locked.size()) {
            java.io.File aFile = (java.io.File)locked.get(i);
            msg.append(aFile.getAbsolutePath());
            msg.append('\n');
            ++i;
        }
        throw new SaveFailureException(msg.toString());
    }

    public void saveAsNoReopen(String aUri) throws SaveFailureException {
        java.io.File aFile = new java.io.File(aUri);
        this.checkWriteable(aFile);
        boolean fileExisted = aFile.exists();
        SaveStrategy aSaveStrategy = null;
        try {
            try {
                java.io.File destinationFile = fileExisted ? ArchiveUtil.createTempFile(aUri, aFile.getCanonicalFile().getParentFile()) : aFile;
                aSaveStrategy = this.createSaveStrategyForJar(destinationFile);
                this.save(aSaveStrategy);
                aSaveStrategy.close();
                this.close();
                if (fileExisted) {
                    this.cleanupAfterTempSave(aUri, aFile, destinationFile);
                }
            }
            catch (IOException ex) {
                throw new SaveFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.error_saving_EXC_, new Object[]{aUri}), ex);
            }
        }
        catch (SaveFailureException failure) {
            try {
                if (aSaveStrategy != null) {
                    aSaveStrategy.close();
                }
            }
            catch (IOException iOException) {}
            if (!fileExisted) {
                aFile.delete();
            }
            throw failure;
        }
        this.setURI(aUri);
    }

    public void saveNoReopen() throws SaveFailureException {
        this.saveAsNoReopen(this.getURI());
    }

    public void setArchiveClassLoader(ClassLoader newArchiveClassLoader) {
        this.archiveClassLoader = newArchiveClassLoader;
    }

    public void setExtraClasspath(String newExtraClasspath) {
        this.primSetExtraClasspath(newExtraClasspath);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setManifest(ArchiveManifest newManifest) {
        this.manifest = newManifest;
    }

    public void setManifest(Manifest aManifest) {
        this.setManifest(new ArchiveManifestImpl(aManifest));
    }

    public void setManifestClassPathAndRefresh(String classpath) {
        ArchiveManifest mf = this.getManifest();
        if (this.manifest == null) {
            this.makeManifest();
        }
        mf.setClassPath(classpath);
        if (this.archiveClassLoader != null) {
            this.initializeClassLoader();
        }
    }

    public void setOptions(ArchiveOptions newOptions) {
        this.options = newOptions;
    }

    public void setSaveFilter(SaveFilter newSaveFilter) {
        this.saveFilter = newSaveFilter;
    }

    public void setSaveStrategy(SaveStrategy newSaveStrategy) {
        this.saveStrategy = newSaveStrategy;
        if (newSaveStrategy != null) {
            newSaveStrategy.setArchive(this);
        }
    }

    public void setXmlEncoding(String newXmlEncoding) {
        this.xmlEncoding = newXmlEncoding;
    }

    public boolean shouldUseJavaReflection() {
        return this.getOptions().useJavaReflection() && this.getLoadStrategy().isClassLoaderNeeded();
    }

    protected void throwResourceLoadException(String resourceUri, Exception ex) throws ResourceLoadException {
        throw new ResourceLoadException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.load_resource_EXC_, new Object[]{resourceUri, this.getURI()}), ex);
    }

    public String getResourcesPath() throws FileNotFoundException {
        return this.getLoadStrategy().getResourcesPath();
    }

    public String getBinariesPath() throws FileNotFoundException {
        return this.getLoadStrategy().getBinariesPath();
    }

    protected RuntimeClasspathEntry[] emptyClasspath() {
        return new RuntimeClasspathEntry[0];
    }

    protected String internalGetBinariesPath() {
        try {
            return this.getBinariesPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            return this.emptyClasspath();
        }
        return new RuntimeClasspathEntry[]{this.createRuntimeClasspathEntry(absolutePath)};
    }

    protected RuntimeClasspathEntry[] getDependencyClassPathAtThisLevel() {
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            return this.emptyClasspath();
        }
        String parentPath = new java.io.File(absolutePath).getParentFile().getAbsolutePath();
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        if (mfEntries.length == 0) {
            return this.emptyClasspath();
        }
        ArrayList entries = new ArrayList();
        entries.addAll(this.createRuntimeClasspathEntries(mfEntries, parentPath));
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    public RuntimeClasspathEntry[] getFullRuntimeClassPath() {
        return this.concat(this.getLocalRuntimeClassPath(), this.getDependencyClassPath());
    }

    protected RuntimeClasspathEntry[] concat(RuntimeClasspathEntry[] array1, RuntimeClasspathEntry[] array2) {
        ArrayList<RuntimeClasspathEntry> temp = new ArrayList<RuntimeClasspathEntry>();
        temp.addAll(Arrays.asList(array1));
        temp.addAll(Arrays.asList(array2));
        return temp.toArray(new RuntimeClasspathEntry[temp.size()]);
    }

    public RuntimeClasspathEntry[] getDependencyClassPath() {
        ArrayList entries = new ArrayList();
        HashSet<ArchiveImpl> visited = new HashSet<ArchiveImpl>();
        HashSet processedEntries = new HashSet();
        visited.add(this);
        this.getDependencyClassPath(visited, entries, processedEntries, this);
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    protected void getDependencyClassPath(Set visitedArchives, List entries, Set processedEntries, Archive current) {
        RuntimeClasspathEntry[] local = ((ArchiveImpl)current).getDependencyClassPathAtThisLevel();
        int i = 0;
        while (i < local.length) {
            Archive resolved;
            RuntimeClasspathEntry entry = local[i];
            if (!processedEntries.contains(entry)) {
                entries.add(entry);
                processedEntries.add(entry);
            }
            if ((resolved = entry.getReferencedArchive()) == null) {
                ClasspathUtil.processManifest(entry.getAbsolutePath(), entries, processedEntries);
            } else if (!visitedArchives.contains(resolved)) {
                visitedArchives.add(resolved);
                this.getDependencyClassPath(visitedArchives, entries, processedEntries, resolved);
            }
            ++i;
        }
    }

    protected EARFile getEARFile() {
        Container parent = this.getContainer();
        if (parent == null || !(parent instanceof EARFile)) {
            return null;
        }
        return (EARFile)parent;
    }

    protected Archive getResolvedArchive(String mfValue, EARFile ear) {
        String aUri = ArchiveUtil.deriveEARRelativeURI(mfValue, this);
        if (aUri == null) {
            return null;
        }
        try {
            return (Archive)ear.getFile(aUri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public boolean hasClasspathVisibilityTo(Archive other) {
        if (other == null) {
            return false;
        }
        EARFile ear = this.getEARFile();
        if (ear == null) {
            return false;
        }
        HashSet visited = new HashSet();
        return this.hasClasspathVisibilityTo(other, visited, ear);
    }

    public boolean hasClasspathVisibilityTo(Archive other, Set visited, EARFile ear) {
        if (this == other) {
            return true;
        }
        if (visited.contains(this)) {
            return false;
        }
        visited.add(this);
        String[] mfEntries = this.getManifest().getClassPathTokenized();
        int i = 0;
        while (i < mfEntries.length) {
            Archive anArchive = this.getResolvedArchive(mfEntries[i], ear);
            if (anArchive != null && anArchive.hasClasspathVisibilityTo(other, visited, ear)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isType(String type) {
        return this.types != null && this.getTypes().contains((Object)type);
    }
}

