/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.edit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Type;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDElementDeclarationCommand;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLSetComponentHelper;
import org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDSchema;

public class WSDLXSDElementReferenceEditManager
extends XSDElementReferenceEditManager {
    public WSDLXSDElementReferenceEditManager(IFile currentFile, XSDSchema[] schemas) {
        super(currentFile, schemas);
    }

    public WSDLXSDElementReferenceEditManager(IFile currentFile, XSDSchema[] schemas, IDescription description) {
        super(currentFile, null);
        if (schemas == null || schemas.length == 0) {
            this.setSchemas(this.getInlineSchemas(description));
        }
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification component) {
        if (referencingObject instanceof Adapter) {
            Adapter adapter = (Adapter)referencingObject;
            referencingObject = adapter.getTarget();
        }
        if (referencingObject instanceof Part) {
            Part part = (Part)referencingObject;
            IFile file = null;
            if (ASDEditorPlugin.getActiveEditor().getEditorInput() instanceof IFileEditorInput) {
                file = ((IFileEditorInput)ASDEditorPlugin.getActiveEditor().getEditorInput()).getFile();
            }
            if (component.isNew() && component.getMetaName() == IXSDSearchConstants.ELEMENT_META_NAME) {
                AddXSDElementDeclarationCommand command = new AddXSDElementDeclarationCommand(part.getEnclosingDefinition(), component.getName());
                command.run();
                String tns = command.getXSDElement().getTargetNamespace();
                component.setQualifier(tns);
            }
            WSDLSetComponentHelper helper = new WSDLSetComponentHelper(file, part.getEnclosingDefinition());
            helper.setXSDElementComponent(part, component);
        }
    }

    public ComponentSpecification[] getQuickPicks() {
        return new ComponentSpecification[0];
    }

    public void setSchemas(XSDSchema[] schemas) {
        this.schemas = schemas;
    }

    private XSDSchema[] getInlineSchemas(IDescription description) {
        List types = description.getTypes();
        XSDSchema[] schemas = new XSDSchema[types.size()];
        int index = 0;
        while (index < types.size()) {
            W11Type type = (W11Type)types.get(index);
            schemas[index] = (XSDSchema)type.getTarget();
            ++index;
        }
        return schemas;
    }

    private class ElementComponentList
    implements IComponentList {
        private List list = new ArrayList();

        private ElementComponentList() {
        }

        public void add(Object object) {
            this.list.add(object);
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        public int size() {
            return this.list.size();
        }

        public Object get(int index) {
            return this.list.get(index);
        }
    }
}

