/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.workingsets;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class WorkingSetsContentProvider
implements ICommonContentProvider {
    public static final String EXTENSION_ID = "org.eclipse.ui.navigator.resources.workingSets";
    public static final String SHOW_TOP_LEVEL_WORKING_SETS = "org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets";
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final int WORKING_SETS = 0;
    private static final int PROJECTS = 1;
    private WorkingSetHelper helper;
    private int rootMode = 0;
    private IExtensionStateModel extensionStateModel;
    private IPropertyChangeListener rootModeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (WorkingSetsContentProvider.SHOW_TOP_LEVEL_WORKING_SETS.equals(event.getProperty())) {
                WorkingSetsContentProvider.this.updateRootMode();
            }
        }
    };

    public void init(ICommonContentExtensionSite aConfig) {
        this.extensionStateModel = aConfig.getExtensionStateModel();
        this.extensionStateModel.addPropertyChangeListener(this.rootModeListener);
        this.updateRootMode();
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkingSet) {
            IWorkingSet workingSet = (IWorkingSet)parentElement;
            if (workingSet.isAggregateWorkingSet()) {
                switch (this.rootMode) {
                    case 0: {
                        return ((AggregateWorkingSet)workingSet).getComponents();
                    }
                    case 1: {
                        return workingSet.getElements();
                    }
                }
            }
            return workingSet.getElements();
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (this.helper != null) {
            return this.helper.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.helper = null;
        this.extensionStateModel.removePropertyChangeListener(this.rootModeListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IWorkingSet) {
            IWorkingSet rootSet = (IWorkingSet)newInput;
            this.helper = new WorkingSetHelper(rootSet);
        }
    }

    private void updateRootMode() {
        this.rootMode = this.extensionStateModel.getBooleanProperty(SHOW_TOP_LEVEL_WORKING_SETS) ? 0 : 1;
    }

    protected class WorkingSetHelper {
        private final IWorkingSet workingSet;
        private final Map parents = new WeakHashMap();

        public WorkingSetHelper(IWorkingSet set) {
            this.workingSet = set;
            if (this.workingSet.isAggregateWorkingSet()) {
                AggregateWorkingSet aggregateSet = (AggregateWorkingSet)this.workingSet;
                IWorkingSet[] components = aggregateSet.getComponents();
                int componentIndex = 0;
                while (componentIndex < components.length) {
                    IAdaptable[] elements = components[componentIndex].getElements();
                    int elementsIndex = 0;
                    while (elementsIndex < elements.length) {
                        this.parents.put(elements[elementsIndex], components[componentIndex]);
                        ++elementsIndex;
                    }
                    this.parents.put(components[componentIndex], aggregateSet);
                    ++componentIndex;
                }
            } else {
                IAdaptable[] elements = this.workingSet.getElements();
                int elementsIndex = 0;
                while (elementsIndex < elements.length) {
                    this.parents.put(elements[elementsIndex], this.workingSet);
                    ++elementsIndex;
                }
            }
        }

        public Object getParent(Object element) {
            return this.parents.get(element);
        }
    }
}

