/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.server.core.Activator;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.server.core.manager.ServersManager;
import org.osgi.framework.BundleContext;

public class PHPDebugPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.core";
    public static final int INTERNAL_ERROR = 10001;
    private static PHPDebugPlugin plugin;
    private static final String BASE_URL = "http://localhost";
    private static String fPHPDebugPerspective;
    private static String fDebugPerspective;
    private static boolean fIsSupportingMultipleDebugAllPages;
    private boolean fInitialAutoRemoveLaunches;
    private static boolean fLaunchChangedAutoRemoveLaunches;
    public static final boolean DebugPHP;

    static {
        fPHPDebugPerspective = "org.eclipse.php.debug.ui.PHPDebugPerspective";
        fDebugPerspective = "org.eclipse.debug.ui.DebugPerspective";
        fIsSupportingMultipleDebugAllPages = true;
        String string = Platform.getDebugOption((String)"org.eclipse.php.debug.core/debug");
        DebugPHP = string != null && string.equalsIgnoreCase("true");
    }

    public PHPDebugPlugin() {
        plugin = this;
        IPreferenceStore iPreferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        this.fInitialAutoRemoveLaunches = iPreferenceStore.getBoolean(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES);
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)new AutoRemoveOldLaunchesListener());
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        Activator.getDefault();
        this.setLaunchPerspective();
        PHPDebugPlugin.createDefaultPHPServer();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES, this.fInitialAutoRemoveLaunches);
    }

    public static PHPDebugPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static boolean getStopAtFirstLine() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
    }

    public static boolean getDebugInfoOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO);
    }

    public static boolean getOpenInBrowserOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER);
    }

    public static boolean getAutoSaveDirtyOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.AUTO_SAVE_DIRTY);
    }

    public static boolean getOpenDebugViewsOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS);
    }

    public static int getDebugPort() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getInt(PHPDebugCorePreferenceNames.DEBUG_PORT);
    }

    public static String getWorkspaceDefaultServer() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        return preferences.getString("defaultPHPServer");
    }

    public void setLaunchPerspective() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = iLaunchManager.getLaunchConfigurationTypes();
        Preferences preferences = this.getPluginPreferences();
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.USE_PHP_DEBUG_PERSPECTIVE);
        int n = 0;
        while (n < iLaunchConfigurationTypeArray.length) {
            if (iLaunchConfigurationTypeArray[n].getIdentifier().startsWith("org.eclipse.php.")) {
                if (bl) {
                    DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationTypeArray[n], (String)"debug", (String)fPHPDebugPerspective);
                } else {
                    DebugUITools.setLaunchPerspective((ILaunchConfigurationType)iLaunchConfigurationTypeArray[n], (String)"debug", (String)fDebugPerspective);
                }
            }
            ++n;
        }
    }

    public static void createDefaultPHPServer() {
        if (ServersManager.getServers().length == 0) {
            Server server = ServersManager.createServer((String)"Default PHP Web Server", (String)BASE_URL);
            ServersManager.save();
            ServersManager.setDefaultServer(null, (Server)server);
        }
    }

    public static void log(IStatus iStatus) {
        try {
            PHPDebugPlugin.getDefault().getLog().log(iStatus);
        }
        catch (Exception exception) {}
    }

    public static void log(Throwable throwable) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, "PHPDebug plugin internal error", throwable));
    }

    public static void logErrorMessage(String string) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, string, null));
    }

    public static boolean supportsMultipleDebugAllPages() {
        return fIsSupportingMultipleDebugAllPages;
    }

    public static void setMultipleDebugAllPages(boolean bl) {
        fIsSupportingMultipleDebugAllPages = bl;
    }

    public static void setDisableAutoRemoveLaunches(boolean bl) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES) == bl) {
            fLaunchChangedAutoRemoveLaunches = true;
            DebugUIPlugin.getDefault().getPreferenceStore().setValue(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES, !bl);
        }
    }

    public boolean getInitialAutoRemoveLaunches() {
        return this.fInitialAutoRemoveLaunches;
    }

    private class AutoRemoveOldLaunchesListener
    implements IPropertyChangeListener {
        private AutoRemoveOldLaunchesListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES.equals(propertyChangeEvent.getProperty())) {
                if (fLaunchChangedAutoRemoveLaunches) {
                    fLaunchChangedAutoRemoveLaunches = false;
                } else {
                    PHPDebugPlugin.this.fInitialAutoRemoveLaunches = (Boolean)propertyChangeEvent.getNewValue();
                }
            }
        }
    }
}

