/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.communication;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.core.util.BlockingQueue;
import org.eclipse.php.core.util.collections.IntHashtable;
import org.eclipse.php.debug.core.Logger;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.communication.CommunicationAdministrator;
import org.eclipse.php.debug.core.communication.CommunicationClient;
import org.eclipse.php.debug.core.communication.ResponseHandler;
import org.eclipse.php.debug.core.debugger.DebugMessagesRegistry;
import org.eclipse.php.debug.core.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.debug.core.debugger.handlers.IDebugRequestHandler;
import org.eclipse.php.debug.core.debugger.messages.DebugSessionStartedNotification;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugNotificationMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.debug.core.launching.PHPProcess;
import org.eclipse.php.debug.core.launching.PHPServerLaunchDecorator;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugConnectionThread
implements Runnable {
    protected static int startMessageId = new DebugSessionStartedNotification().getType();
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    protected boolean validProtocol;
    private boolean isInitialized;
    private InputMessageHandler inputMessageHandler;
    private CommunicationClient communicationClient;
    private CommunicationAdministrator administrator;
    private Object CONNECTION_CLOSED_MSG = new Object();
    protected boolean isDebugMode = System.getProperty("loggingDebug") != null;
    private IntHashtable requestsTable;
    private IntHashtable responseTable;
    private Hashtable responseHandlers;
    private InputManager inputManager;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    private int lastRequestID = 1000;
    protected int peerResponseTimeout = 10000;
    private Thread theThread;
    private PHPDebugTarget debugTarget;

    public DebugConnectionThread(Socket socket) {
        this.socket = socket;
        this.requestsTable = new IntHashtable();
        this.responseTable = new IntHashtable();
        this.responseHandlers = new Hashtable();
        this.theThread = new Thread(this);
        this.theThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.socket.setTcpNoDelay(true);
            DataInputStream dataInputStream = new DataInputStream(this.socket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(this.socket.getOutputStream());
            DataInputStream dataInputStream2 = dataInputStream;
            synchronized (dataInputStream2) {
                this.restartInputMessageHandler(dataOutputStream);
                this.restartInputManager(dataInputStream);
                this.in = dataInputStream;
                this.out = dataOutputStream;
                this.isInitialized = true;
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
    }

    public void setCommunicationClient(CommunicationClient communicationClient) {
        this.communicationClient = communicationClient;
    }

    public CommunicationClient getCommunicationClient() {
        return this.communicationClient;
    }

    public void setCommunicationAdministrator(CommunicationAdministrator communicationAdministrator) {
        this.administrator = communicationAdministrator;
    }

    public CommunicationAdministrator getCommunicationAdministrator() {
        return this.administrator;
    }

    public int getPeerResponseTimeout() {
        return this.peerResponseTimeout;
    }

    public void setPeerResponseTimeout(int n) {
        this.peerResponseTimeout = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.byteArrayOutputStream;
            synchronized (byteArrayOutputStream) {
                this.byteArrayOutputStream.reset();
                ((IDebugMessage)object).serialize(this.dataOutputStream);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(this.byteArrayOutputStream.size());
                    if (this.isDebugMode) {
                        System.out.println("sending notification request size=" + this.byteArrayOutputStream.size());
                    }
                    this.byteArrayOutputStream.writeTo(this.out);
                    this.out.flush();
                }
            }
        }
        catch (SocketException socketException) {
            if (this.isDebugMode) {
                Logger.log(2, socketException.getMessage(), socketException);
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendRequest(Object object) throws Exception {
        try {
            IDebugRequestMessage iDebugRequestMessage = (IDebugRequestMessage)object;
            Object object2 = this.byteArrayOutputStream;
            synchronized (object2) {
                this.byteArrayOutputStream.reset();
                iDebugRequestMessage.setID(this.lastRequestID++);
                iDebugRequestMessage.serialize(this.dataOutputStream);
                int n = this.byteArrayOutputStream.size();
                if (this.isDebugMode) {
                    System.out.println("sending message request size=" + n + " type=" + iDebugRequestMessage.getType());
                }
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.requestsTable.put(iDebugRequestMessage.getID(), (Object)iDebugRequestMessage);
                    this.out.writeInt(n);
                    this.byteArrayOutputStream.writeTo(this.out);
                    this.out.flush();
                }
            }
            object2 = null;
            while (object2 == null && this.isConnected()) {
                Object object3 = object;
                synchronized (object3) {
                    object2 = (IDebugResponseMessage)this.responseTable.remove(iDebugRequestMessage.getID());
                    if (object2 == null) {
                        object.wait(this.peerResponseTimeout);
                    } else if (this.isDebugMode) {
                        System.out.println("waiting for response " + object2.getID());
                    }
                }
                if (object2 == null) {
                    object2 = (IDebugResponseMessage)this.responseTable.remove(iDebugRequestMessage.getID());
                }
                if (object2 != null || !this.isConnected()) continue;
                if (this.isDebugMode) {
                    System.out.println("Communication problems");
                }
                this.handlePeerResponseTimeout();
                if (!this.isConnected()) break;
            }
            if (this.isDebugMode) {
                System.out.println("response received by client: " + object2);
            }
            return object2;
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(Object object, ResponseHandler responseHandler) {
        int n = this.lastRequestID++;
        IDebugRequestMessage iDebugRequestMessage = (IDebugRequestMessage)object;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            iDebugRequestMessage.setID(n);
            iDebugRequestMessage.serialize(dataOutputStream);
            int n2 = byteArrayOutputStream.size();
            if (this.isDebugMode) {
                System.out.println("sending message request size=" + n2);
            }
            DataOutputStream dataOutputStream2 = this.out;
            synchronized (dataOutputStream2) {
                this.requestsTable.put(n, object);
                this.responseHandlers.put(new Integer(n), responseHandler);
                this.out.writeInt(n2);
                byteArrayOutputStream.writeTo(this.out);
                this.out.flush();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception for request no." + iDebugRequestMessage.getType() + exception.toString());
            responseHandler.handleResponse(object, null);
            this.responseHandlers.remove(new Integer(n));
        }
    }

    public boolean isConnected() {
        if (this.in != null) {
            try {
                this.in.available();
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public synchronized void closeConnection() {
        Logger.debugMSG("[" + this + "] DebugConnectionThread: Starting closeConnection");
        this.cleanSocket();
        Logger.debugMSG("[" + this + "] DebugConnectionThread: Thread interrupt");
        if (this.theThread.isAlive()) {
            this.theThread.interrupt();
        }
        Logger.debugMSG("[" + this + "] DebugConnectionThread: closing the socket");
        if (this.socket != null) {
            try {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (Exception exception) {
                PHPDebugPlugin.log(exception);
            }
            this.socket = null;
        }
    }

    protected void restartInputMessageHandler(DataOutputStream dataOutputStream) {
        if (this.inputMessageHandler == null) {
            this.inputMessageHandler = new InputMessageHandler(dataOutputStream);
        } else {
            this.inputMessageHandler.waitForStart(dataOutputStream, true);
        }
    }

    protected void restartInputManager(DataInputStream dataInputStream) {
        try {
            if (this.inputManager == null) {
                this.inputManager = new InputManager(dataInputStream);
            } else {
                this.inputManager.waitForStart(dataInputStream);
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSocket() {
        DataOutputStream dataOutputStream;
        if (!this.isInitialized) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {}
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {}
        }
        if (this.out != null) {
            try {
                dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {}
        }
        this.socket = null;
        this.in = null;
        if (this.out != null) {
            dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                this.out = null;
            }
        }
    }

    private void handlePeerResponseTimeout() {
        this.getCommunicationClient().handlePeerResponseTimeout();
    }

    protected int getSessionID(String string) {
        int n = string.lastIndexOf("debug_session_id=");
        if (n < 0) {
            return -1;
        }
        n += "debug_session_id=".length();
        if ((n = (string = string.substring(n)).indexOf(38)) > -1) {
            return Integer.parseInt(string.substring(0, n));
        }
        return Integer.parseInt(string.trim());
    }

    protected boolean hookDebugSession(DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        ILaunch[] iLaunchArray;
        String string = debugSessionStartedNotification.getQuery();
        int n = this.getSessionID(string);
        ILaunch iLaunch = PHPSessionLaunchMapper.get(n);
        if (iLaunch == null) {
            iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            int n2 = 0;
            while (n2 < iLaunchArray.length) {
                ILaunch iLaunch2 = iLaunchArray[n2];
                String string2 = iLaunch2.getAttribute("debugPages");
                if (iLaunch2.isTerminated() && ("debugAllPages".equals(string2) || "debugFrom".equals(string2))) {
                    iLaunch = iLaunch2;
                    break;
                }
                ++n2;
            }
        }
        if (iLaunch != null) {
            iLaunchArray = iLaunch.getDebugTargets();
            IProcess[] iProcessArray = iLaunch.getProcesses();
            int n3 = 0;
            while (n3 < iLaunchArray.length) {
                if (iLaunchArray[n3].isTerminated()) {
                    iLaunch.removeDebugTarget((IDebugTarget)iLaunchArray[n3]);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < iProcessArray.length) {
                if (iProcessArray[n3].isTerminated()) {
                    iLaunch.removeProcess(iProcessArray[n3]);
                }
                ++n3;
            }
            if (iLaunch instanceof PHPServerLaunchDecorator || Boolean.toString(true).equals(iLaunch.getAttribute("webServerDebugger"))) {
                this.hookServerDebug(iLaunch, debugSessionStartedNotification);
            } else {
                this.hookPHPExeDebug(iLaunch, debugSessionStartedNotification);
            }
            return true;
        }
        return this.handleHookError("No session id");
    }

    protected boolean handleHookError(Object object) {
        if (object != null) {
            Logger.log(4, object.toString());
        } else {
            Logger.log(4, "Debug hook error");
        }
        return false;
    }

    protected void hookServerDebug(final ILaunch iLaunch, DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        Object object;
        String string;
        PHPServerLaunchDecorator pHPServerLaunchDecorator;
        ILaunchConfiguration iLaunchConfiguration = iLaunch.getLaunchConfiguration();
        if (iLaunch instanceof PHPServerLaunchDecorator) {
            pHPServerLaunchDecorator = (PHPServerLaunchDecorator)iLaunch;
        } else {
            string = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            object = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            pHPServerLaunchDecorator = new PHPServerLaunchDecorator(iLaunch, (IProject)object);
        }
        this.inputManager.setTransferEncoding(iLaunchConfiguration.getAttribute("debugTransferEncoding", ""));
        string = iLaunchConfiguration.getAttribute("base_url", "");
        object = iLaunchConfiguration.getAttribute("context_root", "");
        boolean bl = PHPProjectPreferences.getStopAtFirstLine(pHPServerLaunchDecorator.getProject());
        int n = PHPProjectPreferences.getDebugPort(pHPServerLaunchDecorator.getProject());
        boolean bl2 = iLaunchConfiguration.getAttribute("run_with_debug", true);
        if (iLaunch.getLaunchMode().equals("debug")) {
            bl2 = false;
        }
        PHPProcess pHPProcess = new PHPProcess(iLaunch, string);
        this.debugTarget = new PHPDebugTarget(this, iLaunch, string, n, pHPProcess, (String)object, bl2, bl, pHPServerLaunchDecorator.getProject());
        iLaunch.addDebugTarget((IDebugTarget)this.debugTarget);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LaunchManager launchManager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                launchManager.fireUpdate(new ILaunch[]{iLaunch}, 0);
            }
        });
    }

    protected void hookPHPExeDebug(final ILaunch iLaunch, DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        IProject iProject;
        String string;
        Object object;
        Path path;
        IWorkspaceRoot iWorkspaceRoot;
        IResource iResource;
        ILaunchConfiguration iLaunchConfiguration = iLaunch.getLaunchConfiguration();
        this.inputManager.setTransferEncoding(iLaunchConfiguration.getAttribute("debugTransferEncoding", ""));
        String string2 = iLaunchConfiguration.getAttribute("ATTR_LOCATION", null);
        String string3 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
        boolean bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        String string4 = iLaunchConfiguration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        if (iLaunch.getLaunchMode().equals("debug")) {
            bl = false;
        }
        if ((iResource = (iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)(path = new Path(string3)))) != null) {
            object = (IFile)iResource;
            string = object.getName();
            iProject = object.getProject();
        } else if (string4 != null) {
            iProject = iWorkspaceRoot.getProject(string4);
            string = string3;
        } else {
            return;
        }
        object = PHPDebugTarget.getWorkspaceRootPath(iProject.getWorkspace());
        boolean bl2 = PHPProjectPreferences.getStopAtFirstLine(iProject);
        int n = PHPProjectPreferences.getDebugPort(iProject);
        Path path2 = new Path(string2);
        PHPProcess pHPProcess = new PHPProcess(iLaunch, path2.toOSString());
        this.debugTarget = new PHPDebugTarget(this, iLaunch, string2, string, (String)object, n, pHPProcess, bl, bl2, iProject);
        iLaunch.addDebugTarget((IDebugTarget)this.debugTarget);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LaunchManager launchManager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                launchManager.fireUpdate(new ILaunch[]{iLaunch}, 0);
            }
        });
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return String.valueOf(string) + "@" + Integer.toHexString(this.hashCode());
    }

    static /* synthetic */ PHPDebugTarget access$5(DebugConnectionThread debugConnectionThread) {
        return debugConnectionThread.debugTarget;
    }

    private class InputManager
    implements Runnable {
        private DataInputStream in;
        private boolean inWork = false;
        private boolean isAlive = true;
        private Thread theThread;
        private Object READY_FOR_RESTART_LOCK = new Object();
        private String transferEncoding;

        public void setTransferEncoding(String string) {
            this.transferEncoding = string;
        }

        InputManager(DataInputStream dataInputStream) {
            this.in = dataInputStream;
            this.inWork = true;
            this.isAlive = true;
            this.theThread = new Thread(this);
            this.theThread.start();
        }

        public synchronized void start(DataInputStream dataInputStream) {
            this.stop();
            this.in = dataInputStream;
            this.inWork = true;
            this.notifyAll();
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(DataInputStream dataInputStream) {
            if (this.inWork) {
                Object object = this.READY_FOR_RESTART_LOCK;
                synchronized (object) {
                    try {
                        this.READY_FOR_RESTART_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.start(dataInputStream);
        }

        public synchronized void stop() {
            if (!this.inWork) {
                return;
            }
            this.inWork = false;
            this.isAlive = true;
            this.theThread.interrupt();
        }

        public synchronized void terminate() {
            this.inWork = false;
            this.isAlive = false;
            this.theThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ** GOTO lbl99
            {
                block41: {
                    try {
                        var1_1 = this;
                        synchronized (var1_1) {
                            var2_5 = this.READY_FOR_RESTART_LOCK;
                            synchronized (var2_5) {
                                this.READY_FOR_RESTART_LOCK.notify();
                            }
                            this.wait();
                            v1 = this.in;
                            ** synchronized (v1)
lbl16:
                            // 1 sources

                        }
                    }
                    catch (InterruptedException v3) {
                        if (!DebugConnectionThread.this.isDebugMode) break block41;
                        System.out.println("interrupted: inWork = " + this.inWork + ", isAlive = " + this.isAlive);
                    }
                }
                do {
                    if (!this.inWork && this.isAlive) continue block20;
                    try {
                        if (!this.isAlive) break block20;
                        var1_2 = this.in.readInt();
                        if (DebugConnectionThread.this.isDebugMode) {
                            System.out.println("recieved message size = " + var1_2);
                        }
                        if (var1_2 < 0) {
                            this.shutDown();
                            if (DebugConnectionThread.this.isDebugMode) {
                                System.out.println("Socket error (length is negative): possibly Server is SSL, Client is not.");
                            }
                            Logger.log(4, "Socket error (length is negative): possibly Server is SSL, Client is not.");
                        }
                        var2_5 = this;
                        synchronized (var2_5) {
                            var3_6 = this.in.readShort();
                            if (!DebugConnectionThread.this.validProtocol && var3_6 != DebugConnectionThread.startMessageId) {
                                var4_7 = new Status(4, PHPDebugPlugin.getID(), 150, "Incompatible Debug Server version.\nProbably the remote debugger protocol does not match the expected protocol version (2006040701)", null);
                                DebugPlugin.log((IStatus)var4_7);
                                Display.getDefault().asyncExec(new Runnable(this){
                                    final /* synthetic */ InputManager this$1;
                                    {
                                        this.this$1 = inputManager;
                                    }

                                    public void run() {
                                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debugger Error", (String)"Incompatible Debug Server version.\nProbably the remote debugger protocol does not match the expected protocol version (2006040701)");
                                    }
                                });
                                this.shutDown();
                                return;
                            }
                            DebugConnectionThread.this.validProtocol = true;
                            if (DebugConnectionThread.this.isDebugMode) {
                                System.out.println("message type=" + var3_6);
                            }
                            if ((var4_7 = DebugMessagesRegistry.getMessage(var3_6)) != null) {
                                var4_7.setTransferEncoding(this.transferEncoding);
                            }
                            if (var4_7 instanceof IDebugNotificationMessage) {
                                if (DebugConnectionThread.this.isDebugMode) {
                                    System.out.println("Starting to read notification ");
                                }
                                var4_7.deserialize(this.in);
                                if (DebugConnectionThread.this.isDebugMode) {
                                    System.out.println("End reading of notification " + var4_7);
                                }
                                DebugConnectionThread.access$6(DebugConnectionThread.this).queueIn(var4_7);
                            } else if (var4_7 instanceof IDebugResponseMessage) {
                                if (DebugConnectionThread.this.isDebugMode) {
                                    System.out.println("Starting to read response");
                                }
                                var4_7.deserialize(this.in);
                                var5_8 = ((IDebugResponseMessage)var4_7).getID();
                                if (DebugConnectionThread.this.isDebugMode) {
                                    System.out.println("End reading of response " + var4_7);
                                }
                                if ((var6_9 = (ResponseHandler)DebugConnectionThread.access$4(DebugConnectionThread.this).get(new Integer(var5_8))) == null) {
                                    DebugConnectionThread.access$3(DebugConnectionThread.this).put(var5_8, (Object)var4_7);
                                    var8_11 = var7_10 = (IDebugRequestMessage)DebugConnectionThread.access$2(DebugConnectionThread.this).remove(var5_8);
                                    synchronized (var8_11) {
                                        var7_10.notifyAll();
                                    }
                                } else {
                                    DebugConnectionThread.access$6(DebugConnectionThread.this).queueIn(var4_7);
                                }
                            } else if (var4_7 instanceof IDebugRequestMessage) {
                                if (DebugConnectionThread.this.isDebugMode) {
                                    System.out.println("Starting to read request");
                                }
                                var4_7.deserialize(this.in);
                                if (DebugConnectionThread.this.isDebugMode) {
                                    System.out.println("End reading of request " + var4_7);
                                }
                                DebugConnectionThread.access$6(DebugConnectionThread.this).queueIn(var4_7);
                            }
                        }
                    }
                    catch (EOFException v6) {
                        this.shutDown();
                    }
                    catch (SocketException v7) {
                        this.shutDown();
                    }
                    catch (IOException var1_3) {
                        PHPDebugPlugin.log(var1_3);
                        this.shutDown();
                    }
                    catch (Exception var1_4) {
                        PHPDebugPlugin.log(var1_4);
                    }
lbl99:
                    // 9 sources

                } while (this.isAlive);
            }
        }

        private void shutDown() {
            this.terminate();
            DebugConnectionThread.this.cleanSocket();
            DebugConnectionThread.this.inputMessageHandler.connectionClosed();
        }
    }

    private class InputMessageHandler
    implements Runnable {
        private BlockingQueue inputMessageQueue = new BlockingQueue(100);
        private boolean shouldExit = false;
        private boolean isAlive = true;
        private boolean inWork = true;
        private Thread theThread;
        private DataOutputStream out;
        private Object STOP_MSG = new Object();
        private ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        private DataOutputStream outArray = new DataOutputStream(this.byteArray);
        private Object WAIT = new Object();
        private Object READY_FOR_RESTART_LOCK = new Object();

        public InputMessageHandler(DataOutputStream dataOutputStream) {
            this.out = dataOutputStream;
            this.isAlive = true;
            this.inWork = true;
            this.shouldExit = false;
            this.theThread = new Thread(this);
            this.theThread.setPriority(1);
            this.theThread.start();
        }

        public synchronized void start(DataOutputStream dataOutputStream, boolean bl) {
            if (bl) {
                this.inputMessageQueue.clear();
            }
            this.out = dataOutputStream;
            this.ensureStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(DataOutputStream dataOutputStream, boolean bl) {
            if (this.inWork) {
                Object object = this.READY_FOR_RESTART_LOCK;
                synchronized (object) {
                    try {
                        this.READY_FOR_RESTART_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.start(dataOutputStream, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void ensureStarted() {
            Object object = this.WAIT;
            synchronized (object) {
                this.inWork = true;
                this.isAlive = true;
                this.shouldExit = false;
                this.WAIT.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stopImmediately(boolean bl) {
            if (!this.inWork) {
                return;
            }
            this.inWork = false;
            this.isAlive = true;
            this.inputMessageQueue.releaseReaders();
            if (bl) {
                this.inputMessageQueue.clear();
            }
            Object object = this.WAIT;
            synchronized (object) {
                this.WAIT.notifyAll();
            }
        }

        public void terminate() {
            this.inWork = false;
            this.isAlive = false;
            DebugConnectionThread.this.validProtocol = false;
            this.inputMessageQueue.releaseReaders();
            this.inputMessageQueue.clear();
            this.theThread.interrupt();
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void queueIn(IDebugMessage iDebugMessage) {
            this.inputMessageQueue.queueIn((Object)iDebugMessage);
        }

        private void queueIn(Object object) {
            this.inputMessageQueue.queueIn(object);
        }

        public synchronized void connectionClosed() {
            this.ensureStarted();
            this.queueIn(DebugConnectionThread.this.CONNECTION_CLOSED_MSG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void resetCommunication() {
            if (DebugConnectionThread.this.inputManager != null) {
                DebugConnectionThread.this.inputManager.stop();
            }
            this.stopImmediately(true);
            IntHashtable intHashtable = DebugConnectionThread.this.requestsTable;
            synchronized (intHashtable) {
                Iterator iterator = DebugConnectionThread.this.requestsTable.values().iterator();
                while (iterator.hasNext()) {
                    IDebugRequestMessage iDebugRequestMessage;
                    IDebugRequestMessage iDebugRequestMessage2 = iDebugRequestMessage = (IDebugRequestMessage)iterator.next();
                    synchronized (iDebugRequestMessage2) {
                        iDebugRequestMessage.notifyAll();
                    }
                }
            }
            DebugConnectionThread.this.requestsTable.clear();
            DebugConnectionThread.this.responseTable.clear();
            DebugConnectionThread.this.responseHandlers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ** GOTO lbl87
            {
                try {
                    var1_1 = this.WAIT;
                    synchronized (var1_1) {
                        var2_3 = this.READY_FOR_RESTART_LOCK;
                        synchronized (var2_3) {
                            this.READY_FOR_RESTART_LOCK.notify();
                        }
                        this.WAIT.wait();
                    }
                }
                catch (InterruptedException v2) {}
                do {
                    if (!this.inWork && this.isAlive) continue block21;
                    if (!this.isAlive) break block21;
                    try {
                        var1_1 = this.inputMessageQueue.queueOut();
                        var2_3 = this;
                        synchronized (var2_3) {
                            block34: {
                                try {
                                    if (var1_1 instanceof DebugSessionStartedNotification) {
                                        DebugConnectionThread.this.hookDebugSession((DebugSessionStartedNotification)var1_1);
                                        if (DebugConnectionThread.this.getCommunicationClient() != null) {
                                            DebugConnectionThread.this.getCommunicationClient().handleNotification(var1_1);
                                        } else {
                                            this.handleConnectionClosed();
                                        }
                                        break block34;
                                    }
                                    if (var1_1 instanceof IDebugNotificationMessage) {
                                        DebugConnectionThread.this.getCommunicationClient().handleNotification(var1_1);
                                        break block34;
                                    }
                                    if (var1_1 instanceof IDebugRequestMessage) {
                                        var3_4 = DebugMessagesRegistry.getHandler((IDebugRequestMessage)var1_1);
                                        if (!(var3_4 instanceof IDebugRequestHandler)) break block34;
                                        var3_4.handle((IDebugRequestMessage)var1_1, DebugConnectionThread.access$5(DebugConnectionThread.this));
                                        var4_6 = ((IDebugRequestHandler)var3_4).getResponseMessage();
                                        this.byteArray.reset();
                                        var4_6.serialize(this.outArray);
                                        if (DebugConnectionThread.this.isDebugMode) {
                                            System.out.println("sending message size=" + this.byteArray.size());
                                        }
                                        var5_8 = this.out;
                                        synchronized (var5_8) {
                                            this.out.writeInt(this.byteArray.size());
                                            this.byteArray.writeTo(this.out);
                                            this.out.flush();
                                            break block34;
                                        }
                                    }
                                    if (var1_1 instanceof IDebugResponseMessage) {
                                        var3_4 = (IDebugResponseMessage)var1_1;
                                        var4_7 = var3_4.getID();
                                        var5_8 = (IDebugRequestMessage)DebugConnectionThread.access$2(DebugConnectionThread.this).remove(var4_7);
                                        var6_9 = (ResponseHandler)DebugConnectionThread.access$4(DebugConnectionThread.this).remove(new Integer(var4_7));
                                        var6_9.handleResponse(var5_8, var3_4);
                                        break block34;
                                    }
                                    if (var1_1 == this.STOP_MSG) {
                                        var3_4 = this.STOP_MSG;
                                        synchronized (var3_4) {
                                            this.inWork = false;
                                            this.STOP_MSG.notifyAll();
                                            if (this.shouldExit) {
                                                this.isAlive = false;
                                                this.inputMessageQueue.releaseReaders();
                                            }
                                            break block34;
                                        }
                                    }
                                    if (var1_1 == DebugConnectionThread.access$0(DebugConnectionThread.this)) {
                                        this.handleConnectionClosed();
                                    }
                                }
                                catch (Exception var3_5) {
                                    PHPDebugPlugin.log(var3_5);
                                }
                            }
                        }
                    }
                    catch (Exception var1_2) {
                        PHPDebugPlugin.log(var1_2);
                    }
lbl87:
                    // 3 sources

                } while (this.isAlive);
            }
        }

        private void handleConnectionClosed() {
            this.resetCommunication();
            if (DebugConnectionThread.this.getCommunicationAdministrator() != null) {
                DebugConnectionThread.this.getCommunicationAdministrator().connectionClosed();
            }
            this.terminate();
            DebugConnectionThread.this.closeConnection();
        }
    }
}

