/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.php.debug.core.model.PHPDebugElement;
import org.eclipse.php.debug.core.model.PHPDebugTarget;

public class PHPThread
extends PHPDebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = false;

    public PHPThread(PHPDebugTarget pHPDebugTarget) {
        super(pHPDebugTarget);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return ((PHPDebugTarget)this.getDebugTarget()).getStackFrames();
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] iStackFrameArray = this.getStackFrames();
        if (iStackFrameArray.length > 0) {
            return iStackFrameArray[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return "PHPthread";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] iBreakpointArray) {
        this.fBreakpoints = iBreakpointArray;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.setStepping(false);
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.setStepping(false);
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        this.setStepping(true);
        ((PHPDebugTarget)this.getDebugTarget()).stepInto();
    }

    public void stepOver() throws DebugException {
        this.setStepping(true);
        ((PHPDebugTarget)this.getDebugTarget()).stepOver();
    }

    public void stepReturn() throws DebugException {
        this.setStepping(true);
        ((PHPDebugTarget)this.getDebugTarget()).stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public void setStepping(boolean bl) {
        this.fStepping = bl;
    }

    public Object getError() {
        return null;
    }
}

