/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.debug.core.model.DebugOutput;
import org.eclipse.php.debug.core.model.PHPDebugTarget;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.views.DebugViewHelper;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class DebugBrowserView
extends ViewPart
implements ISelectionListener {
    private Browser swtBrowser;
    private PHPDebugTarget fTarget;
    private int fUpdateCount;
    private IDebugEventSetListener terminateListener;
    private DebugViewHelper debugViewHelper;
    private DebugViewPartListener fPartListener;

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 1;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        try {
            this.swtBrowser = new Browser(composite2, 0);
            this.swtBrowser.setLayoutData((Object)gridData);
        }
        catch (SWTError sWTError) {
            this.swtBrowser = null;
            Label label = new Label(composite2, 64);
            label.setText(PHPDebugUIMessages.DebugBrowserView_swtBrowserNotAvailable0);
            label.setLayoutData((Object)gridData);
        }
        this.debugViewHelper = new DebugViewHelper();
        this.terminateListener = new IDebugEventSetListener(){
            PHPDebugTarget target;

            public void handleDebugEvents(DebugEvent[] debugEventArray) {
                if (debugEventArray != null) {
                    int n = debugEventArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = debugEventArray[n2].getSource();
                        if (object instanceof PHPDebugTarget && debugEventArray[n2].getKind() == 8) {
                            this.target = (PHPDebugTarget)object;
                            UIJob uIJob = new UIJob(this, "debug output"){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = var1_1;
                                    super(string);
                                }

                                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                    1.access$0(this.this$1).update(this.this$1.target);
                                    return Status.OK_STATUS;
                                }
                            };
                            uIJob.schedule();
                        }
                        ++n2;
                    }
                }
            }

            static /* synthetic */ DebugBrowserView access$0(1 var0) {
                return var0.DebugBrowserView.this;
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.terminateListener);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        if (this.fPartListener == null) {
            this.fPartListener = new DebugViewPartListener();
            this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener(this.terminateListener);
        if (this.swtBrowser != null && !this.swtBrowser.isDisposed()) {
            this.swtBrowser.dispose();
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        PHPDebugTarget pHPDebugTarget = this.debugViewHelper.getSelectionElement(iSelection);
        this.update(pHPDebugTarget);
    }

    public void update(PHPDebugTarget pHPDebugTarget) {
        if (this.swtBrowser != null) {
            int n;
            PHPDebugTarget pHPDebugTarget2 = this.fTarget;
            int n2 = this.fUpdateCount;
            this.fTarget = pHPDebugTarget;
            String string = "";
            if (this.fTarget != null) {
                if (this.fTarget.isSuspended() || this.fTarget.isTerminated()) {
                    DebugOutput debugOutput = this.fTarget.getOutputBufffer();
                    this.fUpdateCount = debugOutput.getUpdateCount();
                    if (this.fTarget == pHPDebugTarget2 && this.fUpdateCount == n2) {
                        return;
                    }
                    string = debugOutput.toString();
                } else {
                    return;
                }
            }
            if ((n = string.indexOf("\r\n\r\n")) != -1) {
                string = string.substring(n + 4);
            }
            this.swtBrowser.setText(string);
        }
    }

    private class DebugViewPartListener
    implements IPartListener2 {
        private DebugViewPartListener() {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPart(false);
            if (iWorkbenchPart == DebugBrowserView.this) {
                PHPDebugTarget pHPDebugTarget = DebugBrowserView.this.debugViewHelper.getSelectionElement(null);
                DebugBrowserView.this.update(pHPDebugTarget);
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    }
}

