/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.ant.internal.ui.preferences.AbstractAntEditorPreferencePage;
import org.eclipse.ant.internal.ui.preferences.AntEditorPreferenceConstants;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntPreviewerUpdater;
import org.eclipse.ant.internal.ui.preferences.ColorEditor;
import org.eclipse.ant.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.ant.internal.ui.preferences.TabFolderLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class AntEditorPreferencePage
extends AbstractAntEditorPreferencePage {
    private String[][] fSyntaxColorListModel;
    private final String[] fProblemPreferenceKeys = new String[]{"problem_classpath", "problem_properties", "problem_imports", "problem_tasks", "problem_security"};
    private ColorEditor fSyntaxForegroundColorEditor;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private TableViewer fHighlightingColorListViewer;
    private final List fHighlightingColorList = new ArrayList(5);
    private SourceViewer fPreviewViewer;
    private AntPreviewerUpdater fPreviewerUpdater;
    private SelectionListener fSelectionListener;
    protected Map fWorkingValues;
    protected List fComboBoxes;
    private List fProblemLabels;
    private Button fIgnoreAllProblems;
    private Text fBuildFilesToIgnoreProblems;
    private Label fBuildFilesToIgnoreProblemsLabel;
    private Label fSeverityLabel;
    private Label fBuildFilesToIgnoreProblemsDescription;

    public AntEditorPreferencePage() {
        this.setDescription(AntPreferencesMessages.AntEditorPreferencePage_description);
    }

    protected OverlayPreferenceStore createOverlayStore() {
        String[][] stringArrayArray = new String[6][];
        String[] stringArray = new String[3];
        stringArray[0] = AntPreferencesMessages.AntEditorPreferencePage_Ant_editor_text_1;
        stringArray[1] = "org.eclipse.ant.ui.textColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = AntPreferencesMessages.AntEditorPreferencePage_Ant_editor_processing_instuctions_2;
        stringArray2[1] = "org.eclipse.ant.ui.processingInstructionsColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = AntPreferencesMessages.AntEditorPreferencePage_Ant_editor_constant_strings_3;
        stringArray3[1] = "org.eclipse.ant.ui.constantStringsColor";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = AntPreferencesMessages.AntEditorPreferencePage_Ant_editor_tags_4;
        stringArray4[1] = "org.eclipse.ant.ui.tagsColor";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = AntPreferencesMessages.AntEditorPreferencePage_Ant_editor_comments_5;
        stringArray5[1] = "org.eclipse.ant.ui.commentsColor";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = AntPreferencesMessages.AntEditorPreferencePage_26;
        stringArray6[1] = "org.eclipse.ant.ui.dtdColor";
        stringArrayArray[5] = stringArray6;
        this.fSyntaxColorListModel = stringArrayArray;
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spaces_for_tabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.ant.ui.codeAssistProposalsBackgroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.ant.ui.codeAssistProposalsForegroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_java"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_comments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_dtd"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_defining"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_targets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_show_text_hover_affordance"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_mark_occurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "stickyOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, AntEditorPreferenceConstants.BUILDFILE_IGNORE_ALL));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, AntEditorPreferenceConstants.BUILDFILE_NAMES_TO_IGNORE));
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            String colorKey = this.fSyntaxColorListModel[i][1];
            this.addTextKeyToCover(overlayKeys, colorKey);
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private void addTextKeyToCover(ArrayList overlayKeys, String mainKey) {
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, mainKey));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_italic"));
    }

    private Control createAppearancePage(Composite parent) {
        Font font = parent.getFont();
        Composite appearanceComposite = new Composite(parent, 0);
        appearanceComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String labelText = AntPreferencesMessages.AntEditorPreferencePage_2;
        this.addCheckBox(appearanceComposite, labelText, "editor_mark_occurrences", 0);
        labelText = AntPreferencesMessages.AntEditorPreferencePage_4;
        this.addCheckBox(appearanceComposite, labelText, "stickyOccurrences", 0);
        labelText = AntPreferencesMessages.AntEditorPreferencePage_40;
        this.addCheckBox(appearanceComposite, labelText, "spaces_for_tabs", 0);
        labelText = AntPreferencesMessages.AntEditorPreferencePage_32;
        this.addCheckBox(appearanceComposite, labelText, "editor_show_text_hover_affordance", 0);
        return appearanceComposite;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ant.ui.ant_editor_preference_page_context");
        this.getOverlayStore().load();
        this.getOverlayStore().start();
        this.createHeader(parent);
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.AntEditorPreferencePage_general);
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.AntEditorPreferencePage_1);
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.AntEditorPreferencePage_10);
        item.setControl((Control)this.createProblemsTabContent(folder));
        item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.AntEditorPreferencePage_19);
        item.setControl(this.createFoldingTabContent(folder));
        this.initialize();
        this.applyDialogFont(parent);
        return folder;
    }

    private Control createFoldingTabContent(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addCheckBox(composite, AntPreferencesMessages.AntEditorPreferencePage_20, "editor_folding_enabled", 0);
        Label label = new Label(composite, 16384);
        label.setText(AntPreferencesMessages.AntEditorPreferencePage_21);
        this.addCheckBox(composite, AntPreferencesMessages.AntEditorPreferencePage_22, "editor_folding_dtd", 0);
        this.addCheckBox(composite, AntPreferencesMessages.AntEditorPreferencePage_23, "editor_folding_comments", 0);
        this.addCheckBox(composite, AntPreferencesMessages.AntEditorPreferencePage_24, "editor_folding_defining", 0);
        this.addCheckBox(composite, AntPreferencesMessages.AntEditorPreferencePage_25, "editor_folding_targets", 0);
        return composite;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + "_bold", String.valueOf(this.fSyntaxColorListModel[i][1]) + "_italic", null));
            ++i;
        }
        this.fHighlightingColorListViewer.setInput((Object)this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
    }

    protected void handleDefaults() {
        this.handleSyntaxColorListSelection();
        this.restoreWorkingValuesToDefaults();
        this.updateControlsForProblemReporting(!AntUIPlugin.getDefault().getCombinedPreferenceStore().getBoolean(AntEditorPreferenceConstants.BUILDFILE_IGNORE_ALL));
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Label label = new Label(colorComposite, 16384);
        label.setText(AntPreferencesMessages.AntEditorPreferencePage_5);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer = new TableViewer(editorComposite, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(AntPreferencesMessages.AntEditorPreferencePage_6);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(AntPreferencesMessages.AntEditorPreferencePage_7);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(AntPreferencesMessages.AntEditorPreferencePage_8);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(AntPreferencesMessages.AntEditorPreferencePage_9);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AntEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AntEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)AntEditorPreferencePage.this.getOverlayStore(), (String)item.getColorKey(), (RGB)AntEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AntEditorPreferencePage.this.getHighlightingColorListItem();
                AntEditorPreferencePage.this.getOverlayStore().setValue(item.getBoldKey(), AntEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = AntEditorPreferencePage.this.getHighlightingColorListItem();
                AntEditorPreferencePage.this.getOverlayStore().setValue(item.getItalicKey(), AntEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        this.fPreviewViewer = new SourceViewer(parent, null, null, false, 2816);
        AntSourceViewerConfiguration configuration = new AntSourceViewerConfiguration();
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.setEditable(false);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getOverlayStore(), EditorsUI.getPreferenceStore()});
        this.fPreviewerUpdater = new AntPreviewerUpdater(this.fPreviewViewer, configuration, (IPreferenceStore)store);
        String content = this.loadPreviewContentFromFile("SyntaxPreviewCode.txt");
        Document document = new Document(content);
        new AntDocumentSetupParticipant().setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        return this.fPreviewViewer.getControl();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getItalicKey()));
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)selection.getFirstElement();
    }

    public void dispose() {
        super.dispose();
        if (this.fPreviewerUpdater != null) {
            this.fPreviewerUpdater.dispose();
        }
    }

    private Composite createProblemsTabContent(TabFolder folder) {
        this.fComboBoxes = new ArrayList();
        this.fProblemLabels = new ArrayList();
        this.initializeWorkingValues();
        String[] errorWarningIgnoreLabels = new String[]{AntPreferencesMessages.AntEditorPreferencePage_11, AntPreferencesMessages.AntEditorPreferencePage_12, AntPreferencesMessages.AntEditorPreferencePage_13};
        String[] errorWarningIgnore = new String[]{"error", "warning", "ignore"};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite othersComposite = new Composite((Composite)folder, 0);
        othersComposite.setLayout((Layout)layout);
        String labelText = AntPreferencesMessages.AntEditorPreferencePage_28;
        this.fIgnoreAllProblems = this.addCheckBox(othersComposite, labelText, AntEditorPreferenceConstants.BUILDFILE_IGNORE_ALL, 0);
        this.fIgnoreAllProblems.addSelectionListener(this.getSelectionListener());
        this.fBuildFilesToIgnoreProblemsDescription = new Label(othersComposite, 64);
        this.fBuildFilesToIgnoreProblemsDescription.setText(AntPreferencesMessages.AntEditorPreferencePage_29);
        GridData gd = new GridData(768);
        gd.horizontalSpan = nColumns;
        this.fBuildFilesToIgnoreProblemsDescription.setLayoutData((Object)gd);
        Control[] controls = this.addLabelledTextField(othersComposite, AntPreferencesMessages.AntEditorPreferencePage_30, AntEditorPreferenceConstants.BUILDFILE_NAMES_TO_IGNORE, -1, 0, null);
        this.fBuildFilesToIgnoreProblems = this.getTextControl(controls);
        this.fBuildFilesToIgnoreProblemsLabel = this.getLabelControl(controls);
        this.fSeverityLabel = new Label(othersComposite, 64);
        this.fSeverityLabel.setText(AntPreferencesMessages.AntEditorPreferencePage_14);
        gd = new GridData(768);
        gd.horizontalSpan = nColumns;
        this.fSeverityLabel.setLayoutData((Object)gd);
        String label = AntPreferencesMessages.AntEditorPreferencePage_18;
        this.addComboBox(othersComposite, label, "problem_tasks", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AntPreferencesMessages.AntEditorPreferencePage_15;
        this.addComboBox(othersComposite, label, "problem_classpath", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AntPreferencesMessages.AntEditorPreferencePage_16;
        this.addComboBox(othersComposite, label, "problem_properties", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AntPreferencesMessages.AntEditorPreferencePage_17;
        this.addComboBox(othersComposite, label, "problem_imports", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AntPreferencesMessages.AntEditorPreferencePage_27;
        this.addComboBox(othersComposite, label, "problem_security", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        this.updateControlsForProblemReporting(!AntUIPlugin.getDefault().getCombinedPreferenceStore().getBoolean(AntEditorPreferenceConstants.BUILDFILE_IGNORE_ALL));
        return othersComposite;
    }

    private void initializeWorkingValues() {
        this.fWorkingValues = new HashMap(this.fProblemPreferenceKeys.length);
        int i = 0;
        while (i < this.fProblemPreferenceKeys.length) {
            String key = this.fProblemPreferenceKeys[i];
            this.fWorkingValues.put(key, this.getPreferenceStore().getString(key));
            ++i;
        }
    }

    private void restoreWorkingValuesToDefaults() {
        this.fWorkingValues = new HashMap(this.fProblemPreferenceKeys.length);
        int i = 0;
        while (i < this.fProblemPreferenceKeys.length) {
            String key = this.fProblemPreferenceKeys[i];
            this.fWorkingValues.put(key, this.getPreferenceStore().getDefaultString(key));
            ++i;
        }
        this.updateControls();
    }

    protected Combo addComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setLayoutData((Object)new GridData(256));
        comboBox.addSelectionListener(this.getSelectionListener());
        Label placeHolder = new Label(parent, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        String currValue = (String)this.fWorkingValues.get(key);
        comboBox.select(data.getSelection(currValue));
        this.fProblemLabels.add(labelControl);
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AntEditorPreferencePage.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            if (widget == this.fIgnoreAllProblems) {
                this.updateControlsForProblemReporting(!((Button)widget).getSelection());
                return;
            }
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        this.fWorkingValues.put(data.getKey(), newValue);
    }

    private void updateControlsForProblemReporting(boolean reportProblems) {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            ((Control)this.fComboBoxes.get(i)).setEnabled(reportProblems);
            ((Control)this.fProblemLabels.get(i)).setEnabled(reportProblems);
            --i;
        }
        this.fSeverityLabel.setEnabled(reportProblems);
        this.fBuildFilesToIgnoreProblems.setEnabled(reportProblems);
        this.fBuildFilesToIgnoreProblemsDescription.setEnabled(reportProblems);
        this.fBuildFilesToIgnoreProblemsLabel.setEnabled(reportProblems);
    }

    protected void updateControls() {
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            String currValue = (String)this.fWorkingValues.get(data.getKey());
            curr.select(data.getSelection(currValue));
            --i;
        }
    }

    public boolean performOk() {
        Iterator iter = this.fWorkingValues.keySet().iterator();
        IPreferenceStore store = this.getPreferenceStore();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            store.putValue(key, (String)this.fWorkingValues.get(key));
        }
        if (store.needsSaving()) {
            store.putValue("problem", "changed");
            store.setToDefault("problem");
        }
        return super.performOk();
    }

    private void createHeader(Composite contents) {
        final Link link = new Link(contents, 0);
        link.setText(AntPreferencesMessages.AntEditorPreferencePage_0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        String linktooltip = AntPreferencesMessages.AntEditorPreferencePage_3;
        link.setToolTipText(linktooltip);
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getForeground(Object element) {
            return ((HighlightingColorListItem)element).getItemColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }

    private class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private Color fItemColor;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, Color itemColor) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fItemColor = itemColor;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }
}

