/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.IWizardContext;
import org.eclipse.wst.common.project.facet.ui.internal.AddRemoveFacetsDataModel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;

public final class FacetsSelectionPage
extends WizardPage {
    private static final String IMG_PATH_WIZBAN = "images/facets-page-wizban.png";
    private IWizardContext context;
    private Set base;
    private IPreset initialPreset;
    private Set initialSelection;
    private final Set fixed;
    public FacetsSelectionPanel panel;
    private List listeners;
    private List initialSyncWithPresetsCombos;
    private IRuntime initialSetDefaultFacetsForRuntime;
    private AddRemoveFacetsDataModel model;
    static /* synthetic */ Class class$0;

    public FacetsSelectionPage(IWizardContext context, Set base, AddRemoveFacetsDataModel model) {
        super("facets.selection.page");
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
        this.setImageDescriptor(FacetUiPlugin.getImageDescriptor(IMG_PATH_WIZBAN));
        this.context = context;
        this.base = base;
        this.model = model;
        this.initialPreset = null;
        this.initialSelection = null;
        this.fixed = new HashSet();
        this.listeners = new ArrayList();
        this.initialSyncWithPresetsCombos = new ArrayList();
        this.initialSetDefaultFacetsForRuntime = null;
    }

    public void setInitialPreset(IPreset preset) {
        this.initialPreset = preset;
    }

    public void setInitialSelection(Set sel) {
        this.initialSelection = sel;
    }

    public void setFixedProjectFacets(Set fixed) {
        this.fixed.clear();
        this.fixed.addAll(fixed);
    }

    public Set getActions() {
        return this.panel.getActions();
    }

    public Set getSelectedProjectFacets() {
        return this.panel.getSelectedProjectFacets();
    }

    public void addSelectedFacetsChangedListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectedFacetsChangedListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setDefaultFacetsForRuntime(IRuntime runtime) {
        if (this.panel == null) {
            this.initialSetDefaultFacetsForRuntime = runtime;
        } else {
            this.panel.setDefaultFacetsForRuntime(runtime);
        }
    }

    public void syncWithPresetsModel(Combo combo) {
        if (this.initialSyncWithPresetsCombos == null) {
            this.panel.syncWithPresetsModel(combo);
        } else {
            this.initialSyncWithPresetsCombos.add(combo);
        }
    }

    public void createControl(Composite parent) {
        this.panel = new FacetsSelectionPanel(parent, 0, this.context, this.base, this.model);
        this.panel.setFixedProjectFacets(this.fixed);
        if (this.initialPreset != null) {
            this.panel.selectPreset(this.initialPreset);
        }
        if (this.initialSelection != null) {
            this.panel.setSelectedProjectFacets(this.initialSelection);
        }
        if (this.initialSetDefaultFacetsForRuntime != null) {
            this.panel.setDefaultFacetsForRuntime(this.initialSetDefaultFacetsForRuntime);
        }
        this.setPageComplete(this.panel.isSelectionValid());
        this.panel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                FacetsSelectionPage.this.handleSelectionChangedEvent(e);
            }
        });
        this.panel.addProjectFacetsListener(new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPage.this.handleSelectedFacetsChangedEvent(event);
            }
        });
        Iterator itr = this.initialSyncWithPresetsCombos.iterator();
        while (itr.hasNext()) {
            this.panel.syncWithPresetsModel((Combo)itr.next());
        }
        this.initialSyncWithPresetsCombos = null;
        IWorkbenchHelpSystem h = PlatformUI.getWorkbench().getHelpSystem();
        h.setHelp((Control)this.panel, "org.eclipse.wst.common.project.facet.ui.facetsSelectionPage");
        this.setControl((Control)this.panel);
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent e) {
        IStructuredSelection ss = (IStructuredSelection)e.getSelection();
        Object sel = ss.getFirstElement();
        if (sel != null) {
            String desc = sel instanceof IProjectFacet ? ((IProjectFacet)sel).getDescription() : ((ICategory)sel).getDescription();
            this.setDescription(desc);
        }
    }

    private void handleSelectedFacetsChangedEvent(Event event) {
        this.setPageComplete(this.panel.isSelectionValid());
        int i = 0;
        int n = this.listeners.size();
        while (i < n) {
            ((Listener)this.listeners.get(i)).handleEvent(event);
            ++i;
        }
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Iterator itr = this.panel.getActions().iterator();
            while (itr.hasNext()) {
                Object config = ((IFacetedProject.Action)itr.next()).getConfig();
                if (config == null) continue;
                IActionConfig c = null;
                if (config instanceof IActionConfig) {
                    c = (IActionConfig)config;
                } else {
                    IAdapterManager m = Platform.getAdapterManager();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.wst.common.project.facet.core.IActionConfig");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    String t = clazz.getName();
                    c = (IActionConfig)m.loadAdapter(config, t);
                }
                if (c == null) continue;
                c.setProjectName(this.context.getProjectName());
            }
        }
        super.setVisible(visible);
        if (visible) {
            this.panel.setFocus();
        }
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPage$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

