/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.StackFrameEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;

public class DebugTargetProxy
extends EventHandlerModelProxy {
    private IDebugTarget fDebugTarget;

    public DebugTargetProxy(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    public synchronized void dispose() {
        super.dispose();
        this.fDebugTarget = null;
    }

    protected boolean containsEvent(DebugEvent event) {
        IDebugTarget debugTarget;
        Object source = event.getSource();
        if (source instanceof IDebugElement && (debugTarget = ((IDebugElement)source).getDebugTarget()) != null) {
            return debugTarget.equals(this.fDebugTarget);
        }
        return false;
    }

    protected DebugEventHandler[] createEventHandlers() {
        ThreadEventHandler threadEventHandler = new ThreadEventHandler(this);
        return new DebugEventHandler[]{new DebugTargetEventHandler(this), threadEventHandler, new StackFrameEventHandler(this, threadEventHandler)};
    }

    public void installed() {
        IDebugTarget target = this.fDebugTarget;
        if (target != null) {
            try {
                IThread[] threads = target.getThreads();
                int i = 0;
                while (i < threads.length) {
                    IStackFrame frame;
                    IThread thread = threads[i];
                    if (thread.isSuspended() && (frame = thread.getTopStackFrame()) != null) {
                        ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
                        ModelDelta node = delta.addNode(target.getLaunch(), 0);
                        node = node.addNode(target, 0);
                        node = node.addNode(thread, 0x100000);
                        node = node.addNode(frame, 0x200000);
                        this.fireModelChanged(delta);
                        return;
                    }
                    ++i;
                }
                ModelDelta delta = new ModelDelta(DebugPlugin.getDefault().getLaunchManager(), 0);
                ModelDelta node = delta.addNode(target.getLaunch(), 0);
                node = node.addNode(target, 0x300000);
                this.fireModelChanged(delta);
            }
            catch (DebugException debugException) {}
        }
    }
}

