/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.phpModel.parser;

import org.eclipse.core.resources.IProject;
import org.eclipse.php.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.core.project.properties.handlers.PhpVersionProjectPropertyHandler;

public class PHPLanguageModelManager
extends PhpModelProxy
implements IPHPLanguageModel {
    private IPHPLanguageModel languageModel;
    private IProject project;
    private PhpVersionListener phpVersionListener;

    public void initialize(IProject iProject) {
        this.project = iProject;
        String string = PhpVersionProjectPropertyHandler.getVersion(iProject);
        this.setVersion(string);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
    }

    private void setVersion(String string) {
        this.languageModel = (IPHPLanguageModel)PHPLanguageManagerProvider.instance().getPHPLanguageManager(string).getModel();
        this.model = this.languageModel;
    }

    public String getPHPVersion() {
        return this.languageModel.getPHPVersion();
    }

    public PHPClassData getClass(String string) {
        return this.languageModel.getClass(string);
    }

    public PHPKeywordData[] getKeywordData() {
        return this.languageModel.getKeywordData();
    }

    public PHPVariableData[] getServerVariables() {
        return this.languageModel.getServerVariables();
    }

    public PHPVariableData[] getSessionVariables() {
        return this.languageModel.getSessionVariables();
    }

    public PHPVariableData[] getPHPVariables() {
        return this.languageModel.getPHPVariables();
    }

    public void dispose() {
        super.dispose();
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
    }

    public IPHPLanguageModel setDefaultLanguageModel() {
        this.setVersion(PhpVersionProjectPropertyHandler.getVersion());
        return this;
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string = (String)preferencesPropagatorEvent.getNewValue();
            PHPLanguageModelManager.this.setVersion(string);
        }

        public IProject getProject() {
            return PHPLanguageModelManager.this.project;
        }
    }
}

