/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.Logger;
import org.eclipse.php.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.autoEdit.MatchingCharAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class QuotesAutoEditStrategy
extends MatchingCharAutoEditStrategy {
    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (TypingPreferences.closeQuotes && documentCommand.text != null) {
            char c;
            int n = documentCommand.text.length();
            if (n == 0 && documentCommand.length == 1) {
                try {
                    c = iDocument.getChar(documentCommand.offset);
                    if (this.isQuote(c)) {
                        this.deleteQuote((IStructuredDocument)iDocument, documentCommand, c);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.logException(badLocationException);
                }
            }
            if (n == 1 && this.isQuote(c = documentCommand.text.charAt(0))) {
                this.autoAddPairQuote((IStructuredDocument)iDocument, documentCommand, c);
            }
        }
    }

    private void autoAddPairQuote(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand, char c) {
        int n = documentCommand.offset;
        int n2 = n + documentCommand.length;
        try {
            int n3;
            String string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)n, (boolean)true);
            String string2 = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)n2, (boolean)true);
            if (string == "org.eclipse.php.PHP_QUOTED_STRING" || string2 == "org.eclipse.php.PHP_QUOTED_STRING") {
                char c2;
                char c3;
                if (n2 < iStructuredDocument.getLength() && n == n2 && c == (c3 = iStructuredDocument.getChar(n2)) && (c2 = iStructuredDocument.getChar(n - 1)) != '\\') {
                    if (documentCommand.length == 0) {
                        ++documentCommand.offset;
                        documentCommand.text = "";
                    } else {
                        ++documentCommand.length;
                    }
                }
                return;
            }
            if (this.isQuoteAllowed(string, c) && this.shouldAddClosingBracket(iStructuredDocument, n2, true) && (n3 = this.isMatchingCharNeeded(iStructuredDocument, n2, c)) == 0) {
                documentCommand.text = String.valueOf(documentCommand.text) + c;
                iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                iStructuredDocument.getUndoManager().disableUndoManagement();
                iStructuredDocument.replace(documentCommand.offset + 1, 0, "");
                iStructuredDocument.getUndoManager().enableUndoManagement();
                ++documentCommand.offset;
                documentCommand.length = 0;
                documentCommand.text = "";
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            iStructuredDocument.getUndoManager().enableUndoManagement();
        }
    }

    private boolean isQuoteAllowed(String string, char c) {
        return string == "org.eclipse.php.PHP_DEFAULT" || string == "PHP_OPENTAG" || string == "PHP_CLOSETAG";
    }

    public int isMatchingCharNeeded(IStructuredDocument iStructuredDocument, int n, char c) {
        block6: {
            String string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)n, (boolean)true);
            if (string != "org.eclipse.php.PHP_DEFAULT" && string != "PHP_OPENTAG" && string != "PHP_CLOSETAG" && QuotesAutoEditStrategy.isSpecialOpenCurlyInQuotes(iStructuredDocument, n)) {
                string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(n + 1));
            }
            if (string == "org.eclipse.php.PHP_DEFAULT" || string == "PHP_OPENTAG" || string == "PHP_CLOSETAG") break block6;
            return -1;
        }
        try {
            if (FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(iStructuredDocument.getLength() - 1)) == "org.eclipse.php.PHP_QUOTED_STRING") {
                IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getLastStructuredDocumentRegion();
                ITextRegion iTextRegion = iStructuredDocumentRegion.getLastRegion();
                char c2 = iStructuredDocument.getChar(iStructuredDocumentRegion.getStartOffset() + iTextRegion.getTextEnd() - 1);
                if (c2 != c) {
                    return 1;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
        return 0;
    }

    private void deleteQuote(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand, char c) {
        int n = documentCommand.offset;
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        if (iStructuredDocumentRegion == null || iStructuredDocumentRegion.getType() != "PHP_CONTENT") {
            return;
        }
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null) {
            return;
        }
        String string = iTextRegion.getType();
        if (string != "PHP_CONSTANT_ENCAPSED_STRING") {
            return;
        }
        if (n != iTextRegion.getStart() + iStructuredDocumentRegion.getStartOffset() || iTextRegion.getTextLength() != 2 && !this.isBetweenBackquotes(iStructuredDocumentRegion, n)) {
            return;
        }
        try {
            char c2 = iStructuredDocument.getChar(n + 1);
            if (c2 != c) {
                return;
            }
            documentCommand.length = 2;
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isBetweenBackquotes(IStructuredDocumentRegion iStructuredDocumentRegion, int n) {
        if (iStructuredDocumentRegion.getParentDocument().getLength() <= n) {
            return false;
        }
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null || iTextRegion.getLength() > 1) {
            return false;
        }
        if (iStructuredDocumentRegion.getText(iTextRegion).charAt(0) != '`') {
            return false;
        }
        iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n + 1);
        if (iTextRegion == null || iTextRegion.getLength() > 1) {
            return false;
        }
        if (iStructuredDocumentRegion.getText(iTextRegion).charAt(0) != '`') {
            return false;
        }
        String string = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocumentRegion.getParentDocument(), (int)n, (boolean)true);
        return string != "org.eclipse.php.PHP_QUOTED_STRING";
    }
}

