/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.wst.common.frameworks.internal.AbstractRegistryDescriptor;
import org.eclipse.wst.common.internal.emf.utilities.Assert;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchEditResourceHandler;

public class AdapterFactoryDescriptor
extends AbstractRegistryDescriptor
implements Comparable {
    private String packageURI = null;
    private String id = null;
    private Set viewIDs = null;
    private final int loadOrder;
    private static int loadOrderCounter = 0;

    public AdapterFactoryDescriptor(IConfigurationElement element) {
        super(element);
        this.packageURI = element.getAttribute("packageURI");
        this.id = element.getAttribute("id");
        Assert.isNotNull((Object)this.packageURI, (String)EMFWorkbenchEditResourceHandler.AdapterFactoryDescriptor_ERROR_0);
        Assert.isNotNull((Object)this.id, (String)EMFWorkbenchEditResourceHandler.getString(EMFWorkbenchEditResourceHandler.AdapterFactoryDescriptor_ERROR_1, new Object[]{element.getDeclaringExtension().getNamespace()}));
        this.readViewIDs();
        this.loadOrder = loadOrderCounter++;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AdapterFactoryDescriptor");
        sb.append('[');
        sb.append(this.packageURI);
        sb.append(",p");
        sb.append(this.getPriority());
        if (this.viewIDs != null && !this.viewIDs.isEmpty()) {
            sb.append(':');
            boolean first = true;
            Iterator iter = this.viewIDs.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                sb.append(iter.next());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private void readViewIDs() {
        this.viewIDs = new HashSet(3);
        IConfigurationElement[] children = this.element.getChildren("view");
        if (children == null || children.length == 0) {
            return;
        }
        String viewID = null;
        int i = 0;
        while (i < children.length) {
            viewID = children[i].getAttribute("id");
            if (viewID != null) {
                this.viewIDs.add(viewID);
            }
            ++i;
        }
    }

    public AdapterFactory createInstance() {
        if (this.element == null) {
            return null;
        }
        AdapterFactory factory = null;
        try {
            factory = (AdapterFactory)this.element.createExecutableExtension("className");
        }
        catch (CoreException e) {
            JEMUtilPlugin.getLogger().logError((Throwable)e);
            factory = null;
        }
        return factory;
    }

    public String getPackageURI() {
        return this.packageURI;
    }

    public Set getViewIDs() {
        return this.viewIDs;
    }

    public boolean appliesTo(String viewID) {
        return this.viewIDs.isEmpty() || this.viewIDs.contains(viewID);
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AdapterFactoryDescriptor)) {
            return 1;
        }
        AdapterFactoryDescriptor desc = (AdapterFactoryDescriptor)o;
        int pCompare = this.getPriority() - desc.getPriority();
        if (pCompare != 0) {
            return -pCompare;
        }
        if (this.viewIDs != null && !this.viewIDs.isEmpty()) {
            return -1;
        }
        return 1;
    }

    public String getID() {
        return this.id;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }
}

