/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;

final class CommitterColors {
    private static CommitterColors fInstance;
    private Map fColors = new HashMap();
    private int fCount = 0;

    public static CommitterColors getDefault() {
        if (fInstance == null) {
            fInstance = new CommitterColors();
        }
        return fInstance;
    }

    private CommitterColors() {
    }

    public RGB getCommitterRGB(String committer) {
        RGB rgb = (RGB)this.fColors.get(committer);
        if (rgb == null) {
            rgb = this.computeRGB(this.fCount++);
            this.fColors.put(committer, rgb);
        }
        return rgb;
    }

    private RGB computeRGB(int ordinal) {
        float hue = this.computeHue(ordinal);
        RGB rgb = new RGB(hue, 1.0f, 1.0f);
        return rgb;
    }

    private float computeHue(int ordinal) {
        int base = 3;
        int l = ordinal < base ? 0 : (int)Math.floor(Math.log(ordinal / base) / Math.log(2.0));
        int m = (int)Math.pow(2.0, l) * base;
        int j = ordinal < base ? ordinal : ordinal - m;
        float offset = ordinal < base ? 0.0f : (float)((double)(180.0f / (float)base) / Math.pow(2.0, l));
        float delta = ordinal < base ? 120.0f : 2.0f * offset;
        float hue = (offset + (float)j * delta) % 360.0f;
        return hue;
    }
}

