<?PHP

/* **********************************************
	File: class-check.php
	Desc: Used to test whether or not the 
		  Zend Debug Server can handle PHP 5 
		  Classes.
	Author: Cash Coleman <cash@zend.com>
	Version: 1.0.0
*********************************************** */

class Counter {

	private static $count = 0;
	const SUCCESS = "Debug::const Verified\n";
	
	
	function __construct() {
		self::$count++;
	}
	
	function __destruct() {
		self::$count--;
	}
	
	function __clone() {
		print("Debug::clone Verified.\n");
	}
	
	function getCount() {
		return self::$count;
	}	
}



interface start {
	function start();
}

class class_check implements start {
	function start() {
		// Create an instance of the Counter class.
		$c = new Counter();
		// Print the number of instances that have been created...
		print ("Debug::Class Instance ID: " . $c->getCount() . "\n");
		if ($c->getCount() == "1") {
			print("Debug::Class Instance Verified\n");
		} else {
			print("Debug::Class Instance Failed!\n");
		}
		// Create a second instance of the Counter class.
		$c2 = new Counter();
		// Again, print the number of instances of the class 
		// that have been instantiated.
		print ("Debug::Class Instance ID: " . $c->getCount() . "\n");
		if ($c->getCount() == "2") {
			print("Debug::Class Instance Verified\n");
		} else {
			print("Debug::Class Instance Failed!\n");
		}		
		// Now, destroy one instance...
		$c2 = NULL;
		// Finally, print and see that the class instance count 
		// has decreased by one.
		print ("Debug::Class Instance ID: " . $c->getCount() . "\n");
		if ($c->getCount() == "1") {
			print("Debug::Class Instance Verified\n");
		} else {
			print("Debug::Class Instance Failed!\n");
		}		
	}

}



?>