/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.actions.OpenActionUtil;
import org.eclipse.php.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class SelectionConverter {
    private static final PHPCodeData[] EMPTY_RESULT = new PHPCodeData[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart iWorkbenchPart) {
        ISelection iSelection;
        PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor(iWorkbenchPart);
        if (pHPStructuredEditor != null) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve(pHPStructuredEditor));
        }
        ISelectionProvider iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider();
        if (iSelectionProvider != null && (iSelection = iSelectionProvider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public static PHPCodeData[] getElements(IStructuredSelection iStructuredSelection) {
        if (!iStructuredSelection.isEmpty()) {
            PHPCodeData[] pHPCodeDataArray = new PHPCodeData[iStructuredSelection.size()];
            int n = 0;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof PHPCodeData)) {
                    return EMPTY_RESULT;
                }
                pHPCodeDataArray[n] = (PHPCodeData)e;
                ++n;
            }
            return pHPCodeDataArray;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(PHPStructuredEditor pHPStructuredEditor) {
        if (pHPStructuredEditor == null) {
            return false;
        }
        return SelectionConverter.getInput(pHPStructuredEditor) != null;
    }

    public static PHPCodeData[] codeResolveOrInput(PHPStructuredEditor pHPStructuredEditor) {
        ITextSelection iTextSelection;
        PHPFileData pHPFileData = SelectionConverter.getInput(pHPStructuredEditor);
        PHPCodeData[] pHPCodeDataArray = SelectionConverter.codeResolve((PHPCodeData)pHPFileData, iTextSelection = (ITextSelection)pHPStructuredEditor.getSelectionProvider().getSelection());
        if (pHPCodeDataArray.length == 0) {
            pHPCodeDataArray = new PHPCodeData[]{pHPFileData};
        }
        return pHPCodeDataArray;
    }

    public static PHPCodeData[] codeResolveOrInputHandled(PHPStructuredEditor pHPStructuredEditor, Shell shell, String string) {
        return SelectionConverter.codeResolveOrInput(pHPStructuredEditor);
    }

    public static PHPCodeData codeResolveOrInput(PHPStructuredEditor pHPStructuredEditor, Shell shell, String string, String string2) {
        PHPCodeData[] pHPCodeDataArray = SelectionConverter.codeResolveOrInput(pHPStructuredEditor);
        if (pHPCodeDataArray == null || pHPCodeDataArray.length == 0) {
            return null;
        }
        PHPCodeData pHPCodeData = pHPCodeDataArray[0];
        if (pHPCodeDataArray.length > 1) {
            pHPCodeData = OpenActionUtil.selectPHPElement(pHPCodeDataArray, shell, string, string2);
        }
        return pHPCodeData;
    }

    public static PHPCodeData codeResolveOrInputHandled(PHPStructuredEditor pHPStructuredEditor, Shell shell, String string, String string2) {
        return SelectionConverter.codeResolveOrInput(pHPStructuredEditor, shell, string, string2);
    }

    public static PHPCodeData[] codeResolve(PHPStructuredEditor pHPStructuredEditor) {
        return SelectionConverter.codeResolve((PHPCodeData)SelectionConverter.getInput(pHPStructuredEditor), (ITextSelection)pHPStructuredEditor.getSelectionProvider().getSelection());
    }

    public static PHPCodeData codeResolve(PHPStructuredEditor pHPStructuredEditor, Shell shell, String string, String string2) {
        PHPCodeData[] pHPCodeDataArray = SelectionConverter.codeResolve(pHPStructuredEditor);
        if (pHPCodeDataArray == null || pHPCodeDataArray.length == 0) {
            return null;
        }
        PHPCodeData pHPCodeData = pHPCodeDataArray[0];
        if (pHPCodeDataArray.length > 1) {
            pHPCodeData = OpenActionUtil.selectPHPElement(pHPCodeDataArray, shell, string, string2);
        }
        return pHPCodeData;
    }

    public static PHPCodeData[] codeResolveHandled(PHPStructuredEditor pHPStructuredEditor, Shell shell, String string) {
        return SelectionConverter.codeResolve(pHPStructuredEditor);
    }

    public static PHPCodeData getElementAtOffset(PHPStructuredEditor pHPStructuredEditor) {
        return SelectionConverter.getElementAtOffset((PHPCodeData)SelectionConverter.getInput(pHPStructuredEditor), (ITextSelection)pHPStructuredEditor.getSelectionProvider().getSelection());
    }

    public static PHPFileData getInput(PHPStructuredEditor pHPStructuredEditor) {
        if (pHPStructuredEditor == null) {
            return null;
        }
        return pHPStructuredEditor.getPHPFileData();
    }

    public static PHPFileData getInputAsCompilationUnit(PHPStructuredEditor pHPStructuredEditor) {
        PHPFileData pHPFileData = SelectionConverter.getInput(pHPStructuredEditor);
        if (pHPFileData instanceof PHPFileData) {
            return pHPFileData;
        }
        return null;
    }

    public static PHPCodeData[] codeResolve(PHPCodeData pHPCodeData, ITextSelection iTextSelection) {
        String string = iTextSelection.getText();
        if (string == null) {
            return EMPTY_RESULT;
        }
        if ("".equals(string = string.trim())) {
            return EMPTY_RESULT;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (pHPCodeData instanceof PHPFileData && string.matches("^[\\w]+$")) {
            CodeData[] codeDataArray;
            CodeData[] codeDataArray2;
            IProject iProject;
            PHPWorkspaceModelManager pHPWorkspaceModelManager = PHPWorkspaceModelManager.getInstance();
            PHPProjectModel pHPProjectModel = pHPWorkspaceModelManager.getModelForProject(iProject = pHPWorkspaceModelManager.getProjectForFileData((PHPFileData)pHPCodeData, null));
            PHPClassData pHPClassData = pHPProjectModel.getClass(pHPCodeData.getName(), string);
            if (pHPClassData != null) {
                arrayList.add(pHPClassData);
            }
            if ((codeDataArray2 = pHPProjectModel.getFunctions(string)) != null && codeDataArray2.length > 0) {
                arrayList.addAll(Arrays.asList(codeDataArray2));
            }
            if ((codeDataArray = pHPProjectModel.getConstants(string, false)) != null && codeDataArray.length > 0) {
                arrayList.addAll(Arrays.asList(codeDataArray));
            }
            return arrayList.toArray(new PHPCodeData[arrayList.size()]);
        }
        return EMPTY_RESULT;
    }

    public static PHPCodeData getElementAtOffset(PHPCodeData pHPCodeData, ITextSelection iTextSelection) {
        if (pHPCodeData instanceof PHPFileData) {
            PHPFileData pHPFileData = (PHPFileData)pHPCodeData;
            PHPCodeData pHPCodeData2 = PHPModelUtil.getElementAt((PHPCodeData)pHPFileData, (int)iTextSelection.getOffset());
            if (pHPCodeData2 == null) {
                return pHPCodeData;
            }
            return pHPCodeData2;
        }
        return null;
    }

    public static PHPCodeData resolveEnclosingElement(PHPStructuredEditor pHPStructuredEditor, ITextSelection iTextSelection) {
        return SelectionConverter.resolveEnclosingElement((PHPCodeData)SelectionConverter.getInput(pHPStructuredEditor), iTextSelection);
    }

    public static PHPCodeData resolveEnclosingElement(PHPCodeData pHPCodeData, ITextSelection iTextSelection) {
        PHPCodeData pHPCodeData2 = null;
        if (!(pHPCodeData instanceof PHPFileData)) {
            return null;
        }
        PHPFileData pHPFileData = (PHPFileData)pHPCodeData;
        pHPCodeData2 = PHPModelUtil.getElementAt((PHPCodeData)pHPFileData, (int)iTextSelection.getOffset());
        if (pHPCodeData2 == null) {
            return pHPCodeData;
        }
        return pHPCodeData2;
    }
}

