/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.explorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.core.phpModel.PHPModelUtil;
import org.eclipse.php.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.ui.dnd.PHPViewerDropAdapter;
import org.eclipse.php.ui.dnd.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;

class FileTransferDropAdapter
extends PHPViewerDropAdapter
implements TransferDropTargetListener {
    FileTransferDropAdapter(AbstractTreeViewer abstractTreeViewer) {
        super((StructuredViewer)abstractTreeViewer, 24);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
        dropTargetEvent.detail = 0;
        boolean bl = object instanceof IFolder;
        boolean bl2 = object instanceof PHPProjectModel;
        boolean bl3 = object instanceof IContainer;
        if (!(bl || bl2 || bl3)) {
            return;
        }
        if (bl3) {
            IContainer iContainer = (IContainer)object;
            if (iContainer.isAccessible() && !iContainer.isReadOnly()) {
                dropTargetEvent.detail = 1;
            }
        } else if (!PHPModelUtil.isReadOnly((Object)object)) {
            dropTargetEvent.detail = 1;
        }
    }

    public void drop(Object object, final DropTargetEvent dropTargetEvent) {
        int n = dropTargetEvent.detail;
        dropTargetEvent.detail = 0;
        final Object object2 = dropTargetEvent.data;
        if (object2 == null || !(object2 instanceof String[]) || n != 1) {
            return;
        }
        final IContainer iContainer = this.getActualTarget(object);
        if (iContainer == null) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                FileTransferDropAdapter.this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(FileTransferDropAdapter.this.getShell()).copyFiles((String[])object2, iContainer);
                dropTargetEvent.detail = 1;
            }
        });
    }

    private IContainer getActualTarget(Object object) {
        if (object instanceof IContainer) {
            return (IContainer)object;
        }
        if (object instanceof PHPCodeData) {
            return PHPModelUtil.getResource((Object)((PHPCodeData)object)).getParent();
        }
        return null;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

