/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.debug.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.php.debug.core.PHPDebugPlugin;
import org.eclipse.php.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.debug.core.preferences.PHPexeItem;
import org.eclipse.php.debug.core.preferences.PHPexes;
import org.eclipse.php.debug.ui.Logger;
import org.eclipse.php.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.debug.ui.preferences.PHPDebugPreferencesAddon;
import org.eclipse.php.server.core.Server;
import org.eclipse.php.server.core.manager.ServersManager;
import org.eclipse.php.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;
import org.osgi.service.prefs.BackingStoreException;

public class PHPDebugPreferencesAddon
extends AbstractPHPPreferencePageBlock {
    private static final String SERVERS_PAGE_ID = "org.eclipse.php.server.internal.ui.PHPServersPreferencePage";
    private static final String PHP_EXE_PAGE_ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private Button fStopAtFirstLine;
    private Combo fDefaultServer;
    private Combo fDefaultPHPExe;
    private EncodingSettings fEncodingSettings;
    private PropertyPage propertyPage;

    public void setCompositeAddon(Composite composite) {
        Composite composite2 = this.addPageContents(composite);
        this.addProjectPreferenceSubsection(this.createSubsection(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_6));
    }

    public void initializeValues(PropertyPage propertyPage) {
        String string;
        IEclipsePreferences iEclipsePreferences;
        this.propertyPage = propertyPage;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(propertyPage);
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
        String string2 = ServersManager.getDefaultServer(null).getName();
        String string3 = preferences.getString(PHPDebugCorePreferenceNames.DEFAULT_PHP);
        String string4 = preferences.getString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe);
        if (iScopeContextArray[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier())) != null && this.getProject(propertyPage) != null && !(string = ServersManager.getDefaultServer((IProject)this.getProject(propertyPage)).getName()).equals("")) {
            string2 = string;
            bl = iEclipsePreferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, bl);
            string4 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, "");
            string3 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, string3);
        }
        this.fStopAtFirstLine.setSelection(bl);
        this.fDefaultServer.select(this.fDefaultServer.indexOf(string2));
        this.fDefaultPHPExe.select(this.fDefaultPHPExe.indexOf(string3));
        this.fEncodingSettings.setIANATag(string4);
    }

    public boolean performOK(boolean bl) {
        this.savePreferences(bl);
        return true;
    }

    public void performApply(boolean bl) {
        this.performOK(bl);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fStopAtFirstLine.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE));
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe);
        this.fEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void loadServers(Combo combo) {
        combo.removeAll();
        Server[] serverArray = ServersManager.getServers();
        if (serverArray != null) {
            int n = 0;
            while (n < serverArray.length) {
                combo.add(serverArray[n].getName());
                ++n;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadPHPExes(Combo combo) {
        combo.removeAll();
        PHPexes pHPexes = new PHPexes();
        pHPexes.load(PHPProjectPreferences.getModelPreferences());
        PHPexeItem[] pHPexeItemArray = pHPexes.getItems();
        if (pHPexeItemArray != null) {
            int n = 0;
            while (n < pHPexeItemArray.length) {
                combo.add(pHPexeItemArray[n].getName());
                ++n;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_9, "defaultPHPServer");
        this.fDefaultServer = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_serversLink, SERVERS_PAGE_ID);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_12, PHPDebugCorePreferenceNames.DEFAULT_PHP);
        this.fDefaultPHPExe = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink, PHP_EXE_PAGE_ID);
        this.fEncodingSettings = this.addEncodingSettings(composite, "Debug Transfer Encoding");
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, 0);
    }

    private void addLink(Composite composite, String string, final String string2) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        link.setText(string);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugPreferencesAddon.this.propertyPage.getShell(), (String)string2, null, null);
                preferenceDialog.setBlockOnOpen(true);
                preferenceDialog.addPageChangedListener(new IPageChangedListener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void pageChanged(PageChangedEvent pageChangedEvent) {
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                String string = PHPDebugPreferencesAddon.access$1(1.access$0(2.access$0(this.this$2))).getText();
                                String string2 = PHPDebugPreferencesAddon.access$2(1.access$0(2.access$0(this.this$2))).getText();
                                PHPDebugPreferencesAddon.access$3(1.access$0(2.access$0(this.this$2)), PHPDebugPreferencesAddon.access$1(1.access$0(2.access$0(this.this$2))));
                                PHPDebugPreferencesAddon.access$4(1.access$0(2.access$0(this.this$2)), PHPDebugPreferencesAddon.access$2(1.access$0(2.access$0(this.this$2))));
                                PHPDebugPreferencesAddon.access$5(1.access$0(2.access$0(this.this$2)), PHPDebugPreferencesAddon.access$1(1.access$0(2.access$0(this.this$2))), PHPDebugPreferencesAddon.access$1(1.access$0(2.access$0(this.this$2))).indexOf(string));
                                PHPDebugPreferencesAddon.access$5(1.access$0(2.access$0(this.this$2)), PHPDebugPreferencesAddon.access$2(1.access$0(2.access$0(this.this$2))), PHPDebugPreferencesAddon.access$2(1.access$0(2.access$0(this.this$2))).indexOf(string2));
                            }
                        });
                    }

                    static /* synthetic */ 1 access$0(2 var0) {
                        return var0.this$1;
                    }
                });
                preferenceDialog.open();
            }

            static /* synthetic */ PHPDebugPreferencesAddon access$0(1 var0) {
                return var0.PHPDebugPreferencesAddon.this;
            }
        });
    }

    private void selectComboItem(Combo combo, int n) {
        if (n < 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            combo.select(n);
        }
    }

    private EncodingSettings addEncodingSettings(Composite composite, String string) {
        EncodingSettings encodingSettings = new EncodingSettings(composite, "Debug Transfer Encoding");
        GridData gridData = (GridData)encodingSettings.getLayoutData();
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 0;
        gridData.verticalIndent = -5;
        gridData.horizontalIndent = -5;
        encodingSettings.setLayoutData((Object)gridData);
        return encodingSettings;
    }

    private Combo addCombo(Composite composite, int n) {
        Combo combo = new Combo(composite, 2060);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = n;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private void savePreferences(boolean bl) {
        Preferences preferences;
        String string = this.fDefaultPHPExe.getText();
        PHPexes pHPexes = new PHPexes();
        pHPexes.load(PHPProjectPreferences.getModelPreferences());
        if (pHPexes.getItem(string) == null) {
            preferences = pHPexes.getDefaultItem();
            string = preferences != null ? preferences.getName() : "";
        }
        preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier());
        IProject iProject = this.getProject(this.propertyPage);
        if (bl && iEclipsePreferences != null && iScopeContextArray[0] instanceof ProjectScope && iProject != null) {
            iEclipsePreferences.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fEncodingSettings.getIANATag());
            ServersManager.setDefaultServer((IProject)iProject, (String)this.fDefaultServer.getText());
        } else if (iProject == null) {
            preferences.setValue(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            preferences.setValue(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
            preferences.setValue(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fEncodingSettings.getIANATag());
            ServersManager.setDefaultServer(null, (String)this.fDefaultServer.getText());
        } else if (iEclipsePreferences != null) {
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEBUG_PORT);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEFAULT_PHP);
            ServersManager.setDefaultServer((IProject)iProject, null);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        }
        try {
            iEclipsePreferences.flush();
            PHPDebugPlugin.getDefault().savePluginPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.logException(backingStoreException);
        }
    }

    static /* synthetic */ Combo access$1(PHPDebugPreferencesAddon pHPDebugPreferencesAddon) {
        return pHPDebugPreferencesAddon.fDefaultServer;
    }

    static /* synthetic */ Combo access$2(PHPDebugPreferencesAddon pHPDebugPreferencesAddon) {
        return pHPDebugPreferencesAddon.fDefaultPHPExe;
    }

    static /* synthetic */ void access$3(PHPDebugPreferencesAddon pHPDebugPreferencesAddon, Combo combo) {
        pHPDebugPreferencesAddon.loadServers(combo);
    }

    static /* synthetic */ void access$4(PHPDebugPreferencesAddon pHPDebugPreferencesAddon, Combo combo) {
        pHPDebugPreferencesAddon.loadPHPExes(combo);
    }

    static /* synthetic */ void access$5(PHPDebugPreferencesAddon pHPDebugPreferencesAddon, Combo combo, int n) {
        pHPDebugPreferencesAddon.selectComboItem(combo, n);
    }
}

