/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser.management;

import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.ParserClientComposite;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

class ProjectParsingManager
implements IProjectModelListener {
    private Collection parserClientFactoryCollection = new HashSet();
    private PHPParserManager parserManager;
    private IProject project;
    private PhpVersionListener phpVersionListener;

    ProjectParsingManager(IProject iProject) {
        this.project = iProject;
        String string = PhpVersionProjectPropertyHandler.getVersion(iProject);
        this.setPHPVersion(string);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
    }

    private void setPHPVersion(String string) {
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(string);
        this.parserManager = pHPLanguageManager.createPHPParserManager();
    }

    public void fileAdded(IFile iFile) {
        InputStreamReader inputStreamReader;
        ParserClient parserClient = this.buildParserClient(iFile, 1);
        if (parserClient == null) {
            return;
        }
        try {
            inputStreamReader = new InputStreamReader(iFile.getContents(), iFile.getCharset());
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            PHPCorePlugin.log(unsupportedEncodingException);
            return;
        }
        Pattern[] patternArray = TaskPatternsProvider.getInstance().getPatternsForProject(iFile.getProject());
        try {
            this.parserManager.parse(inputStreamReader, iFile.getFullPath().toString(), iFile.getModificationStamp(), parserClient, patternArray, UseAspTagsHandler.useAspTagsAsPhp(this.project));
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
            return;
        }
    }

    private ParserClient buildParserClient(IFile iFile, int n) {
        ParserClientComposite parserClientComposite = new ParserClientComposite();
        Iterator iterator = this.parserClientFactoryCollection.iterator();
        while (iterator.hasNext()) {
            IParserClientFactory iParserClientFactory = (IParserClientFactory)iterator.next();
            if (!iParserClientFactory.isParsable(iFile.getFullPath().toString(), n)) continue;
            ParserClient parserClient = iParserClientFactory.create();
            parserClientComposite.add(parserClient);
        }
        if (parserClientComposite.isEmpty()) {
            return null;
        }
        return parserClientComposite;
    }

    public void fileRemoved(IFile iFile) {
    }

    public void fileChanged(IFile iFile, IStructuredDocument iStructuredDocument) {
        ParserClient parserClient = this.buildParserClient(iFile, 2);
        if (parserClient == null) {
            return;
        }
        try {
            StringReader stringReader = new StringReader(iStructuredDocument.get());
            Pattern[] patternArray = TaskPatternsProvider.getInstance().getPatternsForProject(iFile.getProject());
            this.parserManager.parse(stringReader, iFile.getFullPath().toString(), iFile.getModificationStamp(), parserClient, patternArray, UseAspTagsHandler.useAspTagsAsPhp(this.project));
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
            return;
        }
    }

    public void addParserClient(IParserClientFactory iParserClientFactory) {
        this.parserClientFactoryCollection.add(iParserClientFactory);
    }

    public void removeParserClient(IParserClientFactory iParserClientFactory) {
        this.parserClientFactoryCollection.remove(iParserClientFactory);
    }

    public IProject getProject() {
        return this.project;
    }

    public void dispose() {
        this.parserClientFactoryCollection.clear();
        this.parserClientFactoryCollection = null;
        this.parserManager = null;
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        this.phpVersionListener = null;
        this.project = null;
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string = (String)preferencesPropagatorEvent.getNewValue();
            ProjectParsingManager.this.setPHPVersion(string);
        }

        public IProject getProject() {
            return ProjectParsingManager.this.project;
        }
    }
}

