/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.internal.proxy;

import com.ibm.icu.util.StringTokenizer;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.internal.proxy.InternetMessages;
import org.eclipse.wst.internet.internal.proxy.NonProxyHostsContentProvider;
import org.eclipse.wst.internet.internal.proxy.NonProxyHostsLabelProvider;

public class NonProxyHostsComposite
extends Composite {
    private Table table_;
    private TableViewer tableViewer_;
    private TreeSet tableValues_;
    private Button add_;
    private Button edit_;
    private Button remove_;

    public NonProxyHostsComposite(Composite parent, int style) {
        super(parent, style);
        this.createWidgets();
    }

    protected void createWidgets() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 6;
        layout.verticalSpacing = 6;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.table_ = new Table((Composite)this, 68354);
        GridData data = new GridData(784);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.table_, "org.eclipse.wst.internet.proxy.inpp0140");
        this.table_.setLayoutData((Object)data);
        this.table_.setHeaderVisible(false);
        this.table_.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        new TableColumn(this.table_, 0);
        ColumnWeightData colData = new ColumnWeightData(100, 60, false);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        this.table_.setLayout((Layout)tableLayout);
        this.tableViewer_ = new TableViewer(this.table_);
        this.tableViewer_.setContentProvider((IContentProvider)new NonProxyHostsContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new NonProxyHostsLabelProvider());
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NonProxyHostsComposite.this.enableButtons();
            }
        });
        Composite buttonComp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 8;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(144);
        buttonComp.setLayoutData((Object)data);
        this.add_ = this.createButton(buttonComp, InternetMessages.BUTTON_PREFERENCE_ADD);
        this.add_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(NonProxyHostsComposite.this.getShell(), InternetMessages.TITLE_PREFERENCE_HOSTS_DIALOG, InternetMessages.LABEL_PREFERENCE_HOSTS_DIALOG, "", null);
                if (dialog.open() != 1) {
                    NonProxyHostsComposite.this.updateList(dialog.getValue());
                }
            }
        });
        this.edit_ = this.createButton(buttonComp, InternetMessages.BUTTON_PREFERENCE_EDIT);
        this.edit_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)NonProxyHostsComposite.this.tableViewer_.getSelection();
                String selectedHosts = NonProxyHostsComposite.this.getStringList(selection.iterator());
                InputDialog dialog = new InputDialog(NonProxyHostsComposite.this.getShell(), InternetMessages.TITLE_PREFERENCE_HOSTS_DIALOG, InternetMessages.LABEL_PREFERENCE_HOSTS_DIALOG, selectedHosts, null);
                if (dialog.open() != 1) {
                    NonProxyHostsComposite.this.removeFromList(selection);
                    NonProxyHostsComposite.this.updateList(dialog.getValue());
                }
            }
        });
        this.edit_.setEnabled(false);
        this.remove_ = this.createButton(buttonComp, InternetMessages.BUTTON_PREFERENCE_REMOVE);
        this.remove_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonProxyHostsComposite.this.removeFromList((IStructuredSelection)NonProxyHostsComposite.this.tableViewer_.getSelection());
                NonProxyHostsComposite.this.tableViewer_.refresh();
            }
        });
        this.remove_.setEnabled(false);
    }

    private Button createButton(Composite comp, String label) {
        Button button = new Button(comp, 8);
        button.setText(label);
        GridData data = new GridData(258);
        button.setLayoutData((Object)data);
        return button;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableButtons();
    }

    public void setList(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "|");
        this.tableValues_ = new TreeSet(Collections.list(tokenizer));
        this.tableViewer_.setInput((Object)this.tableValues_);
        this.tableViewer_.refresh();
    }

    public String getList() {
        return this.getStringList(this.tableValues_.iterator());
    }

    private String getStringList(Iterator iterator) {
        StringBuffer buffer = new StringBuffer();
        if (iterator.hasNext()) {
            buffer.append((String)iterator.next());
        }
        while (iterator.hasNext()) {
            buffer.append('|');
            buffer.append((String)iterator.next());
        }
        return buffer.toString();
    }

    private void removeFromList(IStructuredSelection selection) {
        this.tableValues_.removeAll(selection.toList());
    }

    private void updateList(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "|");
        TreeSet newValues = new TreeSet(Collections.list(tokenizer));
        this.tableValues_.addAll(newValues);
        this.tableViewer_.refresh();
    }

    private void enableButtons() {
        boolean enabled = this.getEnabled();
        if (enabled) {
            boolean itemsSelected = !this.tableViewer_.getSelection().isEmpty();
            this.add_.setEnabled(true);
            this.edit_.setEnabled(itemsSelected);
            this.remove_.setEnabled(itemsSelected);
        } else {
            this.add_.setEnabled(false);
            this.edit_.setEnabled(false);
            this.remove_.setEnabled(false);
        }
    }
}

