/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.elements.adapters.VariableLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.variables.JavaVariableColumnPresentation;
import org.eclipse.ui.IWorkbenchPart;

public class JavaVariableLabelAdapter
extends VariableLabelAdapter {
    public static JDIModelPresentation fLabelProvider = new JDIModelPresentation();

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        if (value instanceof IJavaValue) {
            return this.escapeSpecialChars(fLabelProvider.getFormattedValueText((IJavaValue)value));
        }
        return super.getValueText(variable, value, context);
    }

    protected String getValueTypeName(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = value.getReferenceTypeName();
            if (!this.isShowQualfiiedNames(context)) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = variable.getReferenceTypeName();
            if (!this.isShowQualfiiedNames(context)) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {}
        return typeName;
    }

    private boolean isShowQualfiiedNames(IPresentationContext context) {
        IWorkbenchPart part = context.getPart();
        if (part != null) {
            return JDIDebugUIPlugin.getDefault().getPluginPreferences().getBoolean(String.valueOf(part.getSite().getId()) + "." + IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES);
        }
        return false;
    }

    protected String getColumnText(IVariable variable, IValue value, String columnId, IPresentationContext context) throws CoreException {
        if (JavaVariableColumnPresentation.COLUMN_INSTANCE_ID.equals(columnId)) {
            if (value instanceof JDIObjectValue) {
                long uniqueId = ((JDIObjectValue)value).getUniqueId();
                StringBuffer buffer = new StringBuffer();
                buffer.append(uniqueId);
                return buffer.toString();
            }
            return "";
        }
        return super.getColumnText(variable, value, columnId, context);
    }
}

