/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ant;

import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.EnvironmentMessages;
import org.eclipse.wst.command.internal.env.ant.AntEnvironment;
import org.eclipse.wst.command.internal.env.ant.AntOperationManager;
import org.eclipse.wst.command.internal.env.ant.AntStatusHandler;
import org.eclipse.wst.command.internal.env.context.PersistentResourceContext;
import org.eclipse.wst.command.internal.env.core.CommandManager;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistryImpl;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.FragmentListener;
import org.eclipse.wst.common.environment.IEnvironment;

public class AntController {
    private AntOperationManager operationManager_;

    public AntController(Hashtable properties) {
        TransientResourceContext resourceContext = (TransientResourceContext)PersistentResourceContext.getInstance().copy();
        AntStatusHandler handler = new AntStatusHandler();
        AntEnvironment environment = new AntEnvironment(this, resourceContext, handler, properties);
        DataFlowManager dataManager = new DataFlowManager(new DataMappingRegistryImpl(), (IEnvironment)environment);
        CommandFragment rootFragment = environment.getRootCommandFragment();
        if (rootFragment == null) {
            handler.reportError((IStatus)new Status(4, "ws_ant", 9999, EnvironmentMessages.MSG_ERROR_ANT_SCENARIO_TYPE, null));
            return;
        }
        this.createOperationManager(rootFragment, dataManager, environment);
        DataMappingRegistryImpl dataRegistry_ = new DataMappingRegistryImpl();
        rootFragment.registerDataMappings((DataMappingRegistry)dataRegistry_);
        ((AntOperationManager)this.getOperationManager()).moveForwardToNextStop((IProgressMonitor)new NullProgressMonitor());
    }

    private void createOperationManager(CommandFragment frag, DataFlowManager mgr, AntEnvironment env) {
        this.operationManager_ = new AntOperationManager(frag, mgr, env);
        this.operationManager_.setPeekFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return AntController.this.peekFragment(fragment);
            }
        });
        this.operationManager_.setNextFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return AntController.this.nextFragment(fragment);
            }
        });
        this.operationManager_.setUndoFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return AntController.this.undoFragment(fragment);
            }
        });
    }

    protected CommandManager getOperationManager() {
        return this.operationManager_;
    }

    protected boolean peekFragment(CommandFragment fragment) {
        return true;
    }

    protected boolean nextFragment(CommandFragment fragment) {
        return true;
    }

    protected boolean undoFragment(CommandFragment fragment) {
        return true;
    }
}

