/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.appserver;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.appserver.DevClassPathHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class PluginClassLoaderWrapper
extends URLClassLoader {
    private String plugin;
    private Bundle bundle;

    public PluginClassLoaderWrapper(String plugin) {
        super(new URL[0]);
        this.plugin = plugin;
        this.bundle = Platform.getBundle((String)plugin);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.bundle.loadClass(className);
    }

    public URL getResource(String resName) {
        return this.bundle.getResource(resName);
    }

    public URL[] getURLs() {
        Set urls = this.getPluginClasspath(this.plugin);
        return urls.toArray(new URL[urls.size()]);
    }

    private Set getPluginClasspath(String pluginId) {
        HashSet plugins = new HashSet();
        this.addPluginWithPrereqs(pluginId, plugins);
        HashSet<URL> urls = new HashSet<URL>();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            try {
                String[] devpaths;
                URL url;
                Bundle b = Platform.getBundle((String)id);
                if (b == null) continue;
                String headers = (String)b.getHeaders().get("Bundle-ClassPath");
                ManifestElement[] paths = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)headers);
                if (paths != null) {
                    int i = 0;
                    while (i < paths.length) {
                        String path = paths[i].getValue();
                        url = b.getEntry(path);
                        if (url != null) {
                            try {
                                urls.add(FileLocator.toFileURL((URL)url));
                            }
                            catch (IOException iOException) {}
                        }
                        ++i;
                    }
                }
                if ((devpaths = DevClassPathHelper.getDevClassPath(pluginId)) == null) continue;
                int i = 0;
                while (i < devpaths.length) {
                    url = b.getEntry(devpaths[i]);
                    if (url != null) {
                        try {
                            urls.add(FileLocator.toFileURL((URL)url));
                        }
                        catch (IOException iOException) {}
                    }
                    ++i;
                }
            }
            catch (BundleException bundleException) {}
        }
        return urls;
    }

    private void addPluginWithPrereqs(String pluginId, Set pluginIds) {
        if (pluginIds.contains(pluginId)) {
            return;
        }
        String[] immidiatePrereqs = this.getDirectPrereqs(pluginId);
        int i = 0;
        while (i < immidiatePrereqs.length) {
            this.addPluginWithPrereqs(immidiatePrereqs[i], pluginIds);
            ++i;
        }
        pluginIds.add(pluginId);
    }

    private String[] getDirectPrereqs(String pluginId) {
        try {
            String header;
            ManifestElement[] requires;
            Bundle bundle = Platform.getBundle((String)pluginId);
            if (bundle != null && (requires = ManifestElement.parseHeader((String)"Require-Bundle", (String)(header = (String)bundle.getHeaders().get("Require-Bundle")))) != null) {
                String[] reqs = new String[requires.length];
                int i = 0;
                while (i < requires.length) {
                    reqs[i] = requires[i].getValue();
                    ++i;
                }
                return reqs;
            }
        }
        catch (BundleException bundleException) {}
        return new String[0];
    }
}

