/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;

public class NLSSubstitution {
    public static final int EXTERNALIZED = 0;
    public static final int IGNORED = 1;
    public static final int INTERNALIZED = 2;
    public static final int DEFAULT = 0;
    public static final int STATE_COUNT = 3;
    private int fState;
    private String fKey;
    private String fCachedPrefixPlusKey;
    private String fValue;
    private int fInitialState;
    private String fInitialKey;
    private String fInitialValue;
    private NLSElement fNLSElement;
    private AccessorClassReference fAccessorClassReference;
    private String fNewAccessorClassName;
    private String fPrefix = "";

    public NLSSubstitution(int state, String value, NLSElement element) {
        this.fNLSElement = element;
        this.fValue = value;
        this.fState = state;
        this.fInitialState = state;
        this.fInitialValue = value;
        this.fCachedPrefixPlusKey = null;
        Assert.isTrue((state == 0 || state == 1 || state == 2 ? 1 : 0) != 0);
    }

    public NLSSubstitution(int state, String key, String value, NLSElement element, AccessorClassReference accessorClassReference) {
        this(state, value, element);
        if (state != 0) {
            throw new IllegalArgumentException("Set to INTERNALIZE/IGNORED State with different Constructor");
        }
        this.fKey = key;
        this.fInitialKey = key;
        this.fAccessorClassReference = accessorClassReference;
        this.fNewAccessorClassName = null;
    }

    public static int countItems(NLSSubstitution[] elems, int task) {
        Assert.isTrue((task == 0 || task == 1 || task == 2 ? 1 : 0) != 0);
        int result = 0;
        int i = 0;
        while (i < elems.length) {
            if (elems[i].fState == task) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public NLSElement getNLSElement() {
        return this.fNLSElement;
    }

    public String getKeyWithoutPrefix() {
        return this.fKey;
    }

    public String getKey() {
        if (this.fState == 0 && this.hasStateChanged()) {
            if (this.fCachedPrefixPlusKey == null) {
                int length = 0;
                if (this.fPrefix != null) {
                    length += this.fPrefix.length();
                }
                if (this.fKey != null) {
                    length += this.fKey.length();
                }
                StringBuffer sb = new StringBuffer(length);
                sb.append(this.fPrefix);
                sb.append(this.fKey);
                this.fCachedPrefixPlusKey = sb.toString();
            }
            return this.fCachedPrefixPlusKey;
        }
        return this.fKey;
    }

    public void setKey(String key) {
        if (this.fState != 0) {
            throw new IllegalStateException("Must be in Externalized State !");
        }
        this.fCachedPrefixPlusKey = null;
        this.fKey = key;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public void setInitialValue(String value) {
        this.fInitialValue = value;
    }

    public String getValue() {
        return this.fValue;
    }

    public String getValueNonEmpty() {
        if (this.fValue == null) {
            return "";
        }
        return this.fValue;
    }

    public int getState() {
        return this.fState;
    }

    public void setState(int state) {
        this.fCachedPrefixPlusKey = null;
        this.fState = state;
    }

    public void setUpdatedAccessor(String accessorClassName) {
        this.fNewAccessorClassName = accessorClassName;
    }

    public String getUpdatedAccessor() {
        return this.fNewAccessorClassName;
    }

    public boolean hasStateChanged() {
        return this.fState != this.fInitialState;
    }

    public boolean isKeyRename() {
        return this.fInitialKey != null && !this.fInitialKey.equals(this.fKey);
    }

    public boolean isValueRename() {
        return this.fInitialValue != null && !this.fInitialValue.equals(this.fValue);
    }

    public boolean isAccessorRename() {
        return this.fAccessorClassReference != null && this.fNewAccessorClassName != null && !this.fNewAccessorClassName.equals(this.fAccessorClassReference.getName());
    }

    public boolean hasPropertyFileChange() {
        if (this.fInitialState != 0 && this.fState != 0) {
            return false;
        }
        if (this.fInitialState != this.fState) {
            return true;
        }
        if (this.fState == 0) {
            if (this.fInitialValue == null) {
                return true;
            }
            if (!this.fInitialValue.equals(this.fValue)) {
                return true;
            }
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAccessorClassChange() {
        if (this.fInitialState != 0 && this.fState != 0) {
            return false;
        }
        if (this.fInitialState != this.fState) {
            return true;
        }
        if (this.fState == 0) {
            if (this.fInitialValue == null) {
                return true;
            }
            if (!this.fInitialValue.equals(this.fValue)) {
                return false;
            }
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasSourceChange() {
        if (this.hasStateChanged()) {
            return true;
        }
        if (this.fState == 0) {
            if (!this.fInitialKey.equals(this.fKey)) {
                return true;
            }
            if (this.isAccessorRename()) {
                return true;
            }
        } else if (!this.fInitialValue.equals(this.fValue)) {
            return true;
        }
        return false;
    }

    public int getInitialState() {
        return this.fInitialState;
    }

    public String getInitialKey() {
        return this.fInitialKey;
    }

    public String getInitialValue() {
        return this.fInitialValue;
    }

    public AccessorClassReference getAccessorClassReference() {
        return this.fAccessorClassReference;
    }

    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
        this.fCachedPrefixPlusKey = null;
    }

    public boolean isConflicting(NLSSubstitution[] substitutions) {
        if (this.fState == 0) {
            String currKey = this.getKey();
            String currValue = this.getValueNonEmpty();
            int i = 0;
            while (i < substitutions.length) {
                NLSSubstitution substitution = substitutions[i];
                if (substitution != this && substitution.getState() == 0 && currKey.equals(substitution.getKey()) && !currValue.equals(substitution.getValueNonEmpty())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String internalGetKeyWithoutPrefix() {
        if (this.fState == 0 && this.fPrefix != null && this.fKey != null && this.fKey.indexOf(this.fPrefix) == 0) {
            return this.fKey.substring(this.fPrefix.length());
        }
        return this.fKey;
    }

    public void generateKey(NLSSubstitution[] substitutions) {
        if (this.fState != 0 || this.fState == 0 && this.hasStateChanged()) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            int i = 0;
            while (i < substitutions.length) {
                NLSSubstitution substitution = substitutions[i];
                if (substitution != this && substitution.fState == 0) {
                    try {
                        int value = Integer.parseInt(substitution.internalGetKeyWithoutPrefix());
                        min = Math.min(min, value);
                        max = Math.max(max, value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
            this.fCachedPrefixPlusKey = null;
            this.fKey = min == Integer.MAX_VALUE ? this.createKey(0) : (min > 0 ? this.createKey(min - 1) : this.createKey(max + 1));
        }
    }

    public static void updateSubtitutions(NLSSubstitution[] substitutions, Properties props, String accessorClassName) {
        int i = 0;
        while (i < substitutions.length) {
            NLSSubstitution substitution = substitutions[i];
            if (substitution.getState() == 0 && !substitution.hasStateChanged()) {
                substitution.setInitialValue(props.getProperty(substitution.getKey()));
                substitution.setUpdatedAccessor(accessorClassName);
            }
            ++i;
        }
    }

    public void revert() {
        this.fState = this.fInitialState;
        this.fKey = this.fInitialKey;
        this.fCachedPrefixPlusKey = null;
        this.fValue = this.fInitialValue;
    }

    private String createKey(int counter) {
        return String.valueOf(counter);
    }
}

