/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

public class DeleteAction
extends SelectionDispatchAction {
    public DeleteAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.DeleteAction_text);
        this.setDescription(PHPUIMessages.DeleteAction_desc);
        ISharedImages iSharedImages = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.delete_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        if (ActionUtils.containsOnlyProjects(iStructuredSelection.toList())) {
            this.setEnabled(this.createWorkbenchAction(iStructuredSelection).isEnabled());
            return;
        }
        Object[] objectArray = iStructuredSelection.toArray();
        boolean bl = ActionUtils.isDeleteAvailable(objectArray);
        if (bl) {
            bl = !ActionUtils.arePHPElements(objectArray);
        }
        this.setEnabled(bl);
    }

    private IAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        DeleteResourceAction deleteResourceAction = new DeleteResourceAction(this.getShell());
        deleteResourceAction.selectionChanged(iStructuredSelection);
        return deleteResourceAction;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (ActionUtils.containsOnlyProjects(iStructuredSelection.toList())) {
            this.createWorkbenchAction(iStructuredSelection).run();
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StructuredSelection structuredSelection = iStructuredSelection.toList().iterator();
        while (structuredSelection.hasNext()) {
            Object e = structuredSelection.next();
            if (e instanceof PHPFileData) {
                PHPFileData pHPFileData = (PHPFileData)e;
                arrayList.add(PHPModelUtil.getResource((Object)pHPFileData));
                continue;
            }
            if (!(e instanceof IFile) && !(e instanceof IFolder)) continue;
            arrayList.add(e);
        }
        if (arrayList.size() == iStructuredSelection.size()) {
            structuredSelection = new StructuredSelection(arrayList);
            this.createWorkbenchAction((IStructuredSelection)structuredSelection).run();
            return;
        }
    }
}

